/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class ColorUtilities {
    private static Logger log = Logger.getLogger(ColorUtilities.class);
    public static Map<Object, Color> colorCache = new WeakHashMap<Object, Color>(1000);
    private static float[] whiteComponents = Color.white.getRGBColorComponents(null);
    static Map<String, String> colorSymbols = new HashMap<String, String>();
    private static float[] hsbvals;

    public static Color randomColor(int idx, float alpha) {
        int col1 = 0;
        int col2 = 0;
        int col3 = 0;
        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;
        col1 = Math.abs(BASE_COL + ++idx * 33 % RAND_COL);
        col2 = Math.abs(BASE_COL + idx * 55 % RAND_COL);
        col3 = Math.abs(BASE_COL + idx * 77 % RAND_COL);
        return new Color(col1, col2, col3, (int)(255.0f * alpha));
    }

    public static Color randomColor(int idx) {
        int col1 = 0;
        int col2 = 0;
        int col3 = 0;
        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;
        col1 = Math.abs(BASE_COL + ++idx * 33 % RAND_COL);
        col2 = Math.abs(BASE_COL + idx * 55 % RAND_COL);
        col3 = Math.abs(BASE_COL + idx * 77 % RAND_COL);
        return new Color(col1, col2, col3);
    }

    public static Color adjustHSB(Color inputColor, float hue, float saturation, float brightness) {
        Color.RGBtoHSB(inputColor.getRed(), inputColor.getGreen(), inputColor.getBlue(), hsbvals);
        return Color.getHSBColor(hue * hsbvals[0], saturation * hsbvals[1], brightness * hsbvals[2]);
    }

    public static String colorToString(Color color) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(color.getRed());
        buffer.append(",");
        buffer.append(color.getGreen());
        buffer.append(",");
        buffer.append(color.getBlue());
        return buffer.toString();
    }

    public static Color stringToColor(String string) {
        try {
            Color c2 = colorCache.get(string);
            if (c2 == null) {
                if (string.contains(",")) {
                    String[] rgb = string.split(",");
                    int red = Integer.parseInt(rgb[0]);
                    int green = Integer.parseInt(rgb[1]);
                    int blue = Integer.parseInt(rgb[2]);
                    c2 = new Color(red, green, blue);
                } else if (string.startsWith("#")) {
                    c2 = ColorUtilities.hexToColor(string.substring(1));
                    if (string.length() == 6) {
                        int red = Integer.parseInt(string.substring(0, 2), 16);
                        int green = Integer.parseInt(string.substring(2, 4), 16);
                        int blue = Integer.parseInt(string.substring(4, 6), 16);
                        c2 = new Color(red, green, blue);
                    }
                } else {
                    String hexString = colorSymbols.get(string.toLowerCase());
                    if (hexString != null) {
                        c2 = ColorUtilities.hexToColor(hexString);
                    }
                }
                if (c2 == null) {
                    c2 = Color.black;
                }
                colorCache.put(string, c2);
            }
            return c2;
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Error in color string. ", numberFormatException);
            return Color.black;
        }
    }

    private static Color hexToColor(String string) {
        if (string.length() == 6) {
            int red = Integer.parseInt(string.substring(0, 2), 16);
            int green = Integer.parseInt(string.substring(2, 4), 16);
            int blue = Integer.parseInt(string.substring(4, 6), 16);
            return new Color(red, green, blue);
        }
        return null;
    }

    public static Color getCompositeColor(float[] dest, float[] source, float alpha) {
        int a2 = 255;
        int r = (int)((double)((alpha * source[0] + (1.0f - alpha) * dest[0]) * 255.0f) + 0.5);
        int g2 = (int)((double)((alpha * source[1] + (1.0f - alpha) * dest[1]) * 255.0f) + 0.5);
        int b2 = (int)((double)((alpha * source[2] + (1.0f - alpha) * dest[2]) * 255.0f) + 0.5);
        int value = (a2 & 0xFF) << 24 | (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | (b2 & 0xFF) << 0;
        Color c2 = colorCache.get(value);
        if (c2 == null) {
            c2 = new Color(value);
            colorCache.put(value, c2);
        }
        return c2;
    }

    public static Color getCompositeColor(float[] source, float alpha) {
        return ColorUtilities.getCompositeColor(whiteComponents, source, alpha);
    }

    static {
        colorSymbols.put("white", "FFFFFF");
        colorSymbols.put("silver", "C0C0C0");
        colorSymbols.put("gray", "808080");
        colorSymbols.put("black", "000000");
        colorSymbols.put("red", "FF0000");
        colorSymbols.put("maroon", "800000");
        colorSymbols.put("yellow", "FFFF00");
        colorSymbols.put("olive", "808000");
        colorSymbols.put("lime", "00FF00");
        colorSymbols.put("green", "008000");
        colorSymbols.put("aqua", "00FFFF");
        colorSymbols.put("teal", "008080");
        colorSymbols.put("blue", "0000FF");
        colorSymbols.put("navy", "000080");
        colorSymbols.put("fuchsia", "FF00FF");
        colorSymbols.put("purple", "800080");
        colorSymbols.put("orange", "FFA500");
        colorSymbols.put("magenta", "FF00FF");
        hsbvals = new float[3];
    }
}

