/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.broad.igv.util.IGVHttpUtils;

public class TestS3Access {
    public static void main(String[] args) {
        try {
            TestS3Access.testAsciiDownload();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testAsciiDownload() throws IOException {
        String broadURL = "http://www.broadinstitute.org/igvdata/annotations/hg18/refGene.txt";
        String s3URL = "http://s3.amazonaws.com/genomespace-igv/refGene.txt";
        for (int i2 = 0; i2 < 10; ++i2) {
            for (String url : Arrays.asList(broadURL, s3URL)) {
                BufferedReader reader = TestS3Access.openBufferedReader(url);
                int nLines = 0;
                long t0 = System.currentTimeMillis();
                while (reader.readLine() != null) {
                    ++nLines;
                }
                System.out.println(url + " read " + nLines + " in " + (System.currentTimeMillis() - t0) + " ms ");
                reader.close();
            }
        }
    }

    public static BufferedReader openBufferedReader(String pathOrUrl) throws IOException {
        BufferedReader reader = null;
        if (IGVHttpUtils.isURL(pathOrUrl)) {
            URL url = new URL(pathOrUrl);
            HttpURLConnection connection = IGVHttpUtils.openConnection(url);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        } else {
            File file = new File(pathOrUrl);
            FileInputStream fileInput = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                GZIPInputStream in = new GZIPInputStream(fileInput);
                reader = new BufferedReader(new InputStreamReader(in));
            } else {
                reader = new BufferedReader(new InputStreamReader(fileInput));
            }
        }
        return reader;
    }
}

