/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.tdf.TileFactory;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.CompressionUtils;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;
import org.broad.tribble.util.SeekableStream;

public class TDFReader {
    static final Logger log = Logger.getLogger(TDFReader.class);
    public static final int GZIP_FLAG = 1;
    private SeekableStream seekableStream = null;
    private int version;
    private Map<String, IndexEntry> datasetIndex;
    private Map<String, IndexEntry> groupIndex;
    private TrackType trackType;
    private String trackLine;
    private String[] trackNames;
    LRUCache<String, TDFGroup> groupCache = new LRUCache(this, 20);
    LRUCache<String, TDFDataset> datasetCache = new LRUCache(this, 20);
    Map<WindowFunction, Double> valueCache = new HashMap<WindowFunction, Double>();
    private List<WindowFunction> windowFunctions;
    ResourceLocator locator;
    boolean compressed = false;

    public static TDFReader getReader(String path) {
        return TDFReader.getReader(new ResourceLocator(path));
    }

    public static TDFReader getReader(ResourceLocator locator) {
        return new TDFReader(locator);
    }

    public TDFReader(ResourceLocator locator) {
        this.locator = locator;
        try {
            this.seekableStream = IGVSeekableStreamFactory.getStreamFor(locator.getPath());
            this.readHeader();
        }
        catch (IOException ex) {
            log.error("Error loading file: " + locator.getPath(), ex);
            throw new DataLoadException("Error loading file: " + ex.toString(), locator.getPath());
        }
    }

    public void close() {
        try {
            this.seekableStream.close();
        }
        catch (IOException e2) {
            log.error("Error closing reader for: " + this.getPath(), e2);
        }
    }

    public String getPath() {
        return this.locator.getPath();
    }

    private void readHeader() throws IOException {
        int i2;
        byte[] buffer = this.readBytes(0L, 24);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int magicNumber = byteBuffer.getInt();
        byte[] magicBytes = new byte[4];
        System.arraycopy(buffer, 0, magicBytes, 0, 4);
        String magicString = new String(magicBytes);
        if (!magicString.startsWith("TDF") && magicString.startsWith("IBF")) {
            String msg = "Error reading header: bad magic number.";
        }
        this.version = byteBuffer.getInt();
        long idxPosition = byteBuffer.getLong();
        int idxByteCount = byteBuffer.getInt();
        int nHeaderBytes = byteBuffer.getInt();
        byte[] bytes = this.readBytes(24L, nHeaderBytes);
        byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.version >= 2) {
            int nWFs = byteBuffer.getInt();
            this.windowFunctions = new ArrayList<WindowFunction>(nWFs);
            for (i2 = 0; i2 < nWFs; ++i2) {
                String wfName = StringUtils.readString(byteBuffer);
                try {
                    this.windowFunctions.add(WindowFunction.valueOf(wfName));
                    continue;
                }
                catch (Exception e2) {
                    log.error("Error creating window function: " + wfName, e2);
                }
            }
        } else {
            this.windowFunctions = Arrays.asList(WindowFunction.mean);
        }
        try {
            this.trackType = TrackType.valueOf(StringUtils.readString(byteBuffer));
        }
        catch (Exception e3) {
            this.trackType = TrackType.OTHER;
        }
        this.trackLine = StringUtils.readString(byteBuffer).trim();
        int nTracks = byteBuffer.getInt();
        this.trackNames = new String[nTracks];
        for (i2 = 0; i2 < nTracks; ++i2) {
            this.trackNames[i2] = StringUtils.readString(byteBuffer);
        }
        if (this.version > 2) {
            String genomeId = StringUtils.readString(byteBuffer);
            int flags = byteBuffer.getInt();
            this.compressed = (flags & 1) != 0;
        } else {
            this.compressed = false;
        }
        this.readMasterIndex(idxPosition, idxByteCount);
    }

    private void readMasterIndex(long idxPosition, int nBytes) throws IOException {
        byte[] bytes = this.readBytes(idxPosition, nBytes);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int nDatasets = byteBuffer.getInt();
        this.datasetIndex = new LinkedHashMap<String, IndexEntry>(nDatasets);
        for (int i2 = 0; i2 < nDatasets; ++i2) {
            String name = StringUtils.readString(byteBuffer);
            long fPosition = byteBuffer.getLong();
            int n2 = byteBuffer.getInt();
            this.datasetIndex.put(name, new IndexEntry(fPosition, n2));
        }
        int nGroups = byteBuffer.getInt();
        this.groupIndex = new LinkedHashMap<String, IndexEntry>(nGroups);
        for (int i3 = 0; i3 < nGroups; ++i3) {
            String name = StringUtils.readString(byteBuffer);
            long fPosition = byteBuffer.getLong();
            int n3 = byteBuffer.getInt();
            this.groupIndex.put(name, new IndexEntry(fPosition, n3));
        }
    }

    public TDFDataset getDataset(String chr, int zoom, WindowFunction windowFunction) {
        String wf = this.getVersion() < 2 ? "" : "/" + windowFunction.toString();
        String dsName = "/" + chr + "/z" + zoom + wf;
        TDFDataset ds = this.getDataset(dsName);
        return ds;
    }

    public synchronized TDFDataset getDataset(String name) {
        if (this.datasetCache.containsKey(name)) {
            return this.datasetCache.get(name);
        }
        try {
            if (this.datasetIndex.containsKey(name)) {
                IndexEntry ie = this.datasetIndex.get(name);
                long position = ie.position;
                int nBytes = ie.nBytes;
                byte[] buffer = this.readBytes(position, nBytes);
                ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                TDFDataset ds = new TDFDataset(name, byteBuffer, this);
                this.datasetCache.put(name, ds);
                return ds;
            }
            return null;
        }
        catch (IOException ex) {
            log.error("Error reading dataset: " + name, ex);
            throw new RuntimeException("System error occured while reading dataset: " + name);
        }
    }

    public Collection<String> getDatasetNames() {
        return this.datasetIndex.keySet();
    }

    public Collection<String> getGroupNames() {
        return this.groupIndex.keySet();
    }

    public synchronized TDFGroup getGroup(String name) {
        if (this.groupCache.containsKey(name)) {
            return this.groupCache.get(name);
        }
        try {
            IndexEntry ie = this.groupIndex.get(name);
            long position = ie.position;
            int nBytes = ie.nBytes;
            byte[] buffer = this.readBytes(position, nBytes);
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            TDFGroup group = new TDFGroup(name, byteBuffer);
            this.groupCache.put(name, group);
            return group;
        }
        catch (IOException ex) {
            log.error("Error reading group: " + name, ex);
            throw new RuntimeException("System error occured while reading group: " + name);
        }
    }

    public synchronized TDFTile readTile(TDFDataset ds, int tileNumber) {
        try {
            if (tileNumber >= ds.tilePositions.length) {
                return null;
            }
            long position = ds.tilePositions[tileNumber];
            if (position < 0L) {
                return null;
            }
            int nBytes = ds.tileSizes[tileNumber];
            byte[] buffer = this.readBytes(position, nBytes);
            if (this.compressed) {
                buffer = CompressionUtils.decompress(buffer);
            }
            return TileFactory.createTile(buffer, this.trackNames.length);
        }
        catch (IOException ex) {
            String tileName = ds.getName() + "[" + tileNumber + "]";
            log.error("Error reading data tile: " + tileName, ex);
            throw new RuntimeException("System error occured while reading tile: " + tileName);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public String getTrackLine() {
        return this.trackLine;
    }

    public String[] getTrackNames() {
        return this.trackNames;
    }

    private Double getValue(WindowFunction wf) {
        if (!this.valueCache.containsKey((Object)wf)) {
            TDFGroup rootGroup = this.getGroup("/");
            String maxString = rootGroup.getAttribute(wf.getDisplayName());
            try {
                this.valueCache.put(wf, Double.parseDouble(maxString));
            }
            catch (Exception e2) {
                log.info("Warning: value '" + wf.toString() + "' not found in tdf value " + this.getPath());
                this.valueCache.put(wf, null);
            }
        }
        return this.valueCache.get((Object)wf);
    }

    public double getUpperLimit() {
        double upperLimit;
        Double val = this.getValue(WindowFunction.percentile98);
        double d2 = upperLimit = val == null ? this.getDataMax() : val.doubleValue();
        if (upperLimit < 1.0E-30 && this.getLowerLimit() < 1.0E-30) {
            upperLimit = 100.0;
        }
        return upperLimit;
    }

    public double getLowerLimit() {
        Double val = this.getValue(WindowFunction.percentile2);
        return val == null ? this.getDataMin() : val.doubleValue();
    }

    public double getDataMax() {
        Double val = this.getValue(WindowFunction.max);
        return val == null ? 100.0 : val;
    }

    public double getDataMin() {
        Double val = this.getValue(WindowFunction.min);
        return val == null ? 0.0 : val;
    }

    public byte[] readBytes(long position, int nBytes) throws IOException {
        this.seekableStream.seek(position);
        byte[] buffer = new byte[nBytes];
        this.seekableStream.read(buffer, 0, nBytes);
        return buffer;
    }

    public List<WindowFunction> getWindowFunctions() {
        return this.windowFunctions;
    }

    class IndexEntry {
        long position;
        int nBytes;

        public IndexEntry(long position, int nBytes) {
            this.position = position;
            this.nBytes = nBytes;
        }
    }
}

