/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.jidesoft.swing.JidePopupMenu;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class EWigTrack
extends AbstractTrack {
    char[] nucleotides = new char[]{'A', 'C', 'G', 'T'};
    public static Color grey1 = new Color(230, 230, 230);
    Map<Character, TDFDataSource> baseSources;
    TDFDataSource scoreSource;

    public EWigTrack(ResourceLocator locator, Genome genome) {
        super(locator);
        TDFReader reader = TDFReader.getReader(locator.getPath());
        this.scoreSource = new TDFDataSource(reader, 4, "Pi", genome);
        this.scoreSource.setAggregateLikeBins(false);
        this.setDataRange(new DataRange(0.0f, 0.0f, 10.0f));
        this.baseSources = new HashMap<Character, TDFDataSource>();
        for (int i2 = 0; i2 < 4; ++i2) {
            TDFDataSource src = new TDFDataSource(reader, i2, Character.toString(this.nucleotides[i2]), genome);
            src.setAggregateLikeBins(false);
            this.baseSources.put(Character.valueOf(this.nucleotides[i2]), src);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.paint(context, rect);
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, ReferenceFrame frame) {
        return 0.0f;
    }

    private void paint(RenderContext context, Rectangle rect) {
        List<LocusScore> scores = this.scoreSource.getSummaryScoresForRange(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom());
        HashMap<Character, List<LocusScore>> nScores = new HashMap<Character, List<LocusScore>>();
        char[] arr$ = this.nucleotides;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c2 = Character.valueOf(arr$[i$]);
            nScores.put(c2, this.baseSources.get(c2).getSummaryScoresForRange(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom()));
        }
        Graphics2D graphics = context.getGraphic2DForColor(AlignmentRenderer.grey1);
        int lastpX = -1;
        for (int idx = 0; idx < scores.size(); ++idx) {
            LocusScore score = scores.get(idx);
            int startPosition = score.getStart();
            int endPosition = score.getEnd();
            int pX = (int)(rect.getX() + ((double)startPosition - context.getOrigin()) / context.getScale());
            int dX = Math.max(1, (int)(rect.getX() + ((double)endPosition - context.getOrigin()) / context.getScale()) - pX);
            if (dX > 4) {
                dX -= 2;
                ++pX;
            }
            if (pX + dX < 0) continue;
            if ((double)pX > context.getVisibleRect().getMaxX()) break;
            float totalCount = score.getScore();
            int pY = (int)rect.getMaxY() - 1;
            float dataMax = this.getDataRange().getMaximum();
            double height = (double)totalCount * rect.getHeight() / (double)dataMax;
            height = Math.min(height, (double)(rect.height - 1));
            for (char c3 : this.nucleotides) {
                try {
                    LocusScore ns = (LocusScore)((List)nScores.get(Character.valueOf(c3))).get(idx);
                    float count = ns.getScore() * totalCount;
                    Graphics2D tGraphics = context.getGraphic2DForColor(AlignmentRenderer.getNucleotideColors().get(Character.valueOf(c3)));
                    int h2 = (int)Math.round((double)count * height / (double)totalCount);
                    h2 = Math.min(pY - rect.y, h2);
                    int baseY = pY - h2;
                    if (h2 > 0) {
                        tGraphics.fillRect(pX, baseY, dX, h2);
                    }
                    pY = baseY;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            lastpX = pX;
        }
        context.getGraphic2DForColor(Color.gray).drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e2 = te.getMouseEvent();
        if (e2.isPopupTrigger()) {
            this.getPopupMenu(e2).show(e2.getComponent(), e2.getX(), e2.getY());
            return true;
        }
        return super.handleDataClick(te);
    }

    public JPopupMenu getPopupMenu(MouseEvent evt) {
        JidePopupMenu popupMenu = new JidePopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmp));
        popupMenu.add(TrackMenuUtils.getChangeTrackHeightItem(tmp));
        popupMenu.add(TrackMenuUtils.getDataRangeItem(tmp));
        return popupMenu;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        return "";
    }
}

