/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class GSFileBrowser
extends JDialog {
    private static Logger log = Logger.getLogger(GSFileBrowser.class);
    static ImageIcon folderIcon;
    static ImageIcon fileIcon;
    URL baseUrl;
    String userRootUrl = null;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JButton cancelButton;
    private JButton openButton;
    private JPanel splitPane1;
    private JScrollPane scrollPane1;
    private JList fileList;
    private JLabel label1;

    public static void main(String[] args) throws IOException, JSONException {
        new GSFileBrowser(null).setVisible(true);
    }

    public GSFileBrowser(Frame owner) throws IOException, JSONException {
        super(owner);
        this.initComponents();
        this.baseUrl = new URL("https://dmtest.genomespace.org:8444/datamanager/defaultdirectory");
        this.init(this.baseUrl);
    }

    void init(URL url) throws JSONException, IOException {
        if (folderIcon == null) {
            folderIcon = new ImageIcon(this.getClass().getResource("/images/Folder-icon.png"));
            fileIcon = new ImageIcon(this.getClass().getResource("/images/file-document.png"));
        }
        this.fileList.setCellRenderer(new CellRenderer());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    int index = GSFileBrowser.this.fileList.locationToIndex(e2.getPoint());
                    GSMetaData md = (GSMetaData)GSFileBrowser.this.fileList.getModel().getElementAt(index);
                    if (md.isDirectory) {
                        try {
                            GSFileBrowser.this.fetchContents(new URL(md.url));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (JSONException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        GSFileBrowser.this.load(Arrays.asList(new ResourceLocator(md.url)));
                    }
                }
            }
        };
        this.fileList.addMouseListener(mouseListener);
        this.fetchContents(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchContents(URL url) throws IOException, JSONException {
        StringBuffer buf = new StringBuffer();
        InputStream is = null;
        try {
            int b2;
            is = IGVHttpUtils.openConnectionStream(url);
            BufferedInputStream bis = new BufferedInputStream(is);
            while ((b2 = bis.read()) >= 0) {
                buf.append((char)b2);
            }
            JSONTokener tk = new JSONTokener(buf.toString());
            JSONObject obj = new JSONObject(tk);
            Object c2 = obj.get("contents");
            ArrayList<JSONObject> contents = new ArrayList<JSONObject>();
            if (c2 instanceof JSONObject) {
                contents.add((JSONObject)c2);
            } else {
                JSONArray tmp = (JSONArray)c2;
                int l2 = tmp.length();
                for (int i2 = 0; i2 < l2; ++i2) {
                    contents.add((JSONObject)tmp.get(i2));
                }
            }
            JSONObject directory = (JSONObject)obj.get("directory");
            String dirUrlString = directory.get("url").toString();
            this.setTitle(dirUrlString);
            if (this.userRootUrl == null) {
                this.userRootUrl = dirUrlString;
            }
            ArrayList<GSMetaData> dirElements = new ArrayList<GSMetaData>();
            ArrayList<GSMetaData> fileElements = new ArrayList<GSMetaData>();
            if (!dirUrlString.equals(this.userRootUrl)) {
                int lastSlashIdx = dirUrlString.lastIndexOf("/");
                String parentURL = dirUrlString.substring(0, lastSlashIdx);
                dirElements.add(new GSMetaData("Parent Directory", parentURL, "", "", true));
            }
            int contentsLength = contents.size();
            for (int i3 = 0; i3 < contentsLength; ++i3) {
                JSONObject o2 = (JSONObject)contents.get(i3);
                String name = (String)o2.get("name");
                String objurl = (String)o2.get("url");
                if (o2.get("directory").equals("true")) {
                    dirElements.add(new GSMetaData(name, objurl, "", "", true));
                    continue;
                }
                JSONObject dataFormat = o2.has("dataFormat") ? (JSONObject)o2.get("dataFormat") : null;
                String format = dataFormat == null ? "" : dataFormat.getString("name");
                String size = (String)o2.get("size");
                fileElements.add(new GSMetaData(name, objurl, format, size, false));
            }
            ArrayList<GSMetaData> elements = new ArrayList<GSMetaData>(dirElements.size() + fileElements.size());
            elements.addAll(dirElements);
            elements.addAll(fileElements);
            ListModel model = new ListModel(elements);
            this.fileList.setModel(model);
        }
        finally {
            is.close();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        this.dispose();
    }

    private void loadButtonActionPerformed(ActionEvent e2) {
        try {
            Object[] selections = this.fileList.getSelectedValues();
            if (selections.length == 1) {
                GSMetaData md = (GSMetaData)selections[0];
                if (md.isDirectory) {
                    this.fetchContents(new URL(md.url));
                    return;
                }
            }
            ArrayList<ResourceLocator> toLoad = new ArrayList<ResourceLocator>(selections.length);
            for (Object obj : selections) {
                if (!(obj instanceof GSMetaData)) continue;
                GSMetaData md = (GSMetaData)obj;
                if (md.isDirectory) continue;
                toLoad.add(new ResourceLocator(md.url));
            }
            if (toLoad.size() > 0) {
                this.load(toLoad);
            }
        }
        catch (Exception e1) {
            log.error("Error loading GS files", e1);
            MessageUtils.showMessage("Error: " + e1.toString());
        }
    }

    private void load(final List<ResourceLocator> toLoad) {
        this.setVisible(false);
        this.dispose();
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public void run() {
                IGV.getInstance().loadTracks(toLoad);
            }

            @Override
            public String getName() {
                return "GS Load";
            }
        };
        LongRunningTask.submit(runnable);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.cancelButton = new JButton();
        this.openButton = new JButton();
        this.splitPane1 = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.fileList = new JList();
        this.label1 = new JLabel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 85, 0};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSFileBrowser.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSFileBrowser.this.loadButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.openButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.splitPane1.setLayout(new BoxLayout(this.splitPane1, 1));
        this.scrollPane1.setViewportView(this.fileList);
        this.splitPane1.add(this.scrollPane1);
        this.label1.setHorizontalAlignment(0);
        this.label1.setIcon(new ImageIcon(this.getClass().getResource("/images/genomespacelogo.png")));
        this.splitPane1.add(this.label1);
        this.dialogPane.add((Component)this.splitPane1, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(490, 530);
        this.setLocationRelativeTo(this.getOwner());
    }

    static class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            GSMetaData metaData = (GSMetaData)value;
            String s = value.toString();
            this.setText(s);
            this.setIcon(metaData.isDirectory ? folderIcon : fileIcon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    static class ListModel
    extends AbstractListModel {
        ArrayList elements;

        ListModel(ArrayList elements) {
            this.elements = elements;
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        @Override
        public Object getElementAt(int i2) {
            return this.elements.get(i2);
        }
    }

    static class GSMetaData {
        boolean isDirectory;
        String name;
        String url;
        String format;
        String size;

        GSMetaData(String name, String url, String format, String size, boolean isDirectory) {
            this.isDirectory = isDirectory;
            this.name = name;
            this.url = url;
            this.format = format;
            this.size = size;
        }

        public String toString() {
            return this.name;
        }
    }
}

