/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.stream.IGVUrlHelper;
import org.broad.igv.util.stream.SeekableFTPStream;
import org.broad.igv.util.stream.SeekableServiceStream;
import org.broad.igv.util.stream.SeekableSplitStream;
import org.broad.tribble.util.SeekableFileStream;
import org.broad.tribble.util.SeekableHTTPStream;
import org.broad.tribble.util.SeekableStream;

public class IGVSeekableStreamFactory {
    public static SeekableStream getStreamFor(String path) throws IOException {
        if (path.endsWith(".list")) {
            return new SeekableSplitStream(path);
        }
        SeekableStream is = null;
        if (path.toLowerCase().startsWith("http:") || path.toLowerCase().startsWith("https:")) {
            HttpUtils.getInstance();
            boolean useByteRange = HttpUtils.useByteRange();
            if (useByteRange) {
                long contentLength = HttpUtils.getInstance().getContentLength(new URL(path));
                is = new SeekableHTTPStream(new IGVUrlHelper(new URL(path)));
            } else {
                is = new SeekableServiceStream(path);
            }
        } else {
            is = path.toLowerCase().startsWith("ftp:") ? new SeekableFTPStream(new URL(path)) : new SeekableFileStream(new File(path));
        }
        return is;
    }
}

