/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.DoubleArrayList;

public class Accumulator {
    public static int MAX_VALUE_COUNT = 100000;
    private static Logger log = Logger.getLogger(Accumulator.class);
    boolean isFinished = false;
    WindowFunction windowFunction;
    List<PercentileValue> percentiles;
    float sum = 0.0f;
    int basesCovered = 0;
    int nPts = 0;
    float value = Float.NaN;
    DoubleArrayList values;
    int nRepValues;
    float[] data;
    String[] probes;
    private int npts;
    private String[] names;
    static Set<WindowFunction> PERCENTILE_WINDOW_FUNCTIONS = new HashSet<WindowFunction>();

    public Accumulator(WindowFunction windowFunction, int nRepValues) {
        this(windowFunction);
        if (nRepValues > 0) {
            this.nRepValues = nRepValues;
            this.data = new float[nRepValues];
            this.probes = new String[nRepValues];
        }
    }

    public Accumulator(WindowFunction windowFunction) {
        this.windowFunction = windowFunction;
        if (PERCENTILE_WINDOW_FUNCTIONS.contains((Object)windowFunction)) {
            this.values = new DoubleArrayList();
            this.percentiles = new ArrayList<PercentileValue>();
        }
    }

    public boolean hasData() {
        return this.basesCovered > 0;
    }

    public void add(int nBases, float v, String probe) {
        if (nBases < 1) {
            nBases = 1;
        }
        if (!Float.isNaN(v)) {
            if (this.data != null && this.nPts < this.data.length) {
                this.data[this.nPts] = v;
                this.probes[this.nPts] = probe;
            }
            switch (this.windowFunction) {
                case min: {
                    this.value = Float.isNaN(this.value) ? v : Math.min(this.value, v);
                    break;
                }
                case max: {
                    this.value = Float.isNaN(this.value) ? v : Math.max(this.value, v);
                    break;
                }
                case mean: {
                    this.sum += (float)nBases * v;
                    break;
                }
                default: {
                    if (this.values == null) break;
                    this.values.add(v);
                    if (this.values.size() <= MAX_VALUE_COUNT) break;
                    this.computePercentiles();
                    this.values.clear();
                }
            }
            ++this.nPts;
            this.basesCovered += nBases;
        }
    }

    public void finish() {
        if (this.isFinished) {
            return;
        }
        if (this.windowFunction == WindowFunction.mean) {
            this.value = Float.isNaN(this.sum) ? Float.NaN : this.sum / (float)this.basesCovered;
        } else if (this.values != null) {
            if (this.values.size() == 1) {
                this.value = (float)this.values.get(0);
            } else {
                if (this.values.size() > 1) {
                    this.computePercentiles();
                }
                float v = Float.NaN;
                if (this.percentiles != null && this.percentiles.size() > 0) {
                    double weightedSum = 0.0;
                    double sumOfWeights = 0.0;
                    for (PercentileValue pv : this.percentiles) {
                        double weight = (double)pv.nPoints / (double)this.basesCovered;
                        sumOfWeights += weight;
                        weightedSum += weight * pv.value;
                    }
                    v = (float)(weightedSum / sumOfWeights);
                }
                this.value = v;
            }
        }
        this.values = null;
        this.isFinished = true;
    }

    private void computePercentiles() {
        if (this.values != null) {
            double[] valueArray = this.values.toArray();
            double p2 = this.getPercentile(this.windowFunction);
            if (p2 > 0.0) {
                float v = (float)StatUtils.percentile(valueArray, p2);
                if (Float.isInfinite(v)) {
                    log.error("Infinite percentile (" + (Object)((Object)this.windowFunction) + ")");
                } else {
                    this.percentiles.add(new PercentileValue(valueArray.length, v));
                }
            }
        }
    }

    public float getValue() {
        if (!this.isFinished) {
            this.finish();
        }
        return this.value;
    }

    public double getPercentile(WindowFunction wf) {
        switch (wf) {
            case percentile2: {
                return 2.0;
            }
            case percentile10: {
                return 10.0;
            }
            case percentile90: {
                return 90.0;
            }
            case percentile98: {
                return 98.0;
            }
            case median: {
                return 50.0;
            }
        }
        return -1.0;
    }

    public int getNpts() {
        return this.npts;
    }

    public String[] getNames() {
        return this.names;
    }

    public float[] getData() {
        return this.data;
    }

    static {
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.median);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile2);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile10);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile90);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile98);
    }

    class PercentileValue {
        int nPoints;
        double value;

        PercentileValue(int nPoints, double value) {
            this.nPoints = nPoints;
            this.value = value;
        }
    }
}

