/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ExponentialDistribution;

public class ExponentialDistributionImpl
extends AbstractContinuousDistribution
implements ExponentialDistribution,
Serializable {
    private static final long serialVersionUID = 2401296428283614780L;
    private double mean;

    public ExponentialDistributionImpl(double mean) {
        this.setMean(mean);
    }

    public void setMean(double mean) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("mean must be positive.");
        }
        this.mean = mean;
    }

    public double getMean() {
        return this.mean;
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret = x <= 0.0 ? 0.0 : 1.0 - Math.exp(-x / this.getMean());
        return ret;
    }

    public double inverseCumulativeProbability(double p2) throws MathException {
        if (p2 < 0.0 || p2 > 1.0) {
            throw new IllegalArgumentException("probability argument must be between 0 and 1 (inclusive)");
        }
        double ret = p2 == 1.0 ? Double.POSITIVE_INFINITY : -this.getMean() * Math.log(1.0 - p2);
        return ret;
    }

    protected double getDomainLowerBound(double p2) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p2) {
        if (p2 < 0.5) {
            return this.getMean();
        }
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p2) {
        if (p2 < 0.5) {
            return this.getMean() * 0.5;
        }
        return this.getMean();
    }
}

