/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.PaintPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class BasicJideOptionPaneUI
extends BasicOptionPaneUI {
    private Container _detailsArea;
    private Container _buttonArea;
    private Container _bannerArea;
    private Component _titleComponent;
    private ThemePainter _painter;
    private int _detailsPreferredWidth = -1;
    private static boolean _detailsVisible = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJideOptionPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new JideBoxLayout(this.optionPane, 1);
    }

    public static boolean isDetailsVisible() {
        return _detailsVisible;
    }

    public static void setDetailsVisible(boolean bl) {
        _detailsVisible = bl;
    }

    protected void installComponents() {
        if (UIDefaultsLookup.get("OptionPane.showBanner") == null || UIDefaultsLookup.getBoolean("OptionPane.showBanner")) {
            this._bannerArea = this.createBannerArea();
            this.optionPane.add((Component)this._bannerArea, "fix");
        }
        Container container = this.createMessageArea();
        LookAndFeel.installBorder((JComponent)container, "OptionPane.border");
        this.optionPane.add(container);
        Container container2 = this.createSeparator();
        if (container2 != null) {
            this.optionPane.add(container2);
        }
        this._buttonArea = this.createButtonArea();
        this.optionPane.add((Component)this._buttonArea, "fix");
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
        if (this.shouldDetailsButtonVisible()) {
            this.updateDetailsComponent();
        }
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("details".equals(propertyChangeEvent.getPropertyName())) {
                    Component component;
                    BasicJideOptionPaneUI.this.updateDetailsComponent();
                    if (BasicJideOptionPaneUI.this._buttonArea instanceof ButtonPanel && (component = ((ButtonPanel)BasicJideOptionPaneUI.this._buttonArea).getButtonByName("DETAILS")) != null) {
                        component.setVisible(propertyChangeEvent.getNewValue() != null);
                    }
                } else if ("title".equals(propertyChangeEvent.getPropertyName())) {
                    BasicJideOptionPaneUI.this.updateTitleComponent(BasicJideOptionPaneUI.this._bannerArea);
                }
            }
        });
    }

    protected void updateDetailsComponent() {
        if (this._detailsArea != null) {
            this.optionPane.remove(this._detailsArea);
            this._detailsArea = null;
        }
        this._detailsArea = this.createDetailsComponent();
        if (this._detailsArea != null) {
            this.optionPane.add((Component)this._detailsArea, "vary");
            this._detailsArea.setVisible(BasicJideOptionPaneUI.isDetailsVisible());
        }
    }

    protected Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        Border border = (Border)UIDefaultsLookup.get("OptionPane.messageAreaBorder");
        if (border != null) {
            jPanel.setBorder(border);
        }
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setName("OptionPane.body");
        jPanel3.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            serializable = new JPanel();
            serializable.setName("OptionPane.separator");
            serializable.setPreferredSize(new Dimension(15, 1));
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        int n2 = UIDefaultsLookup.getInt("OptionPane.messageAnchor");
        ((GridBagConstraints)serializable).anchor = n2 == 0 ? 10 : n2;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        Object object = this.getMessage();
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, object, this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    protected Container createSeparator() {
        return new JSeparator();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.optionPane.setBorder(BorderFactory.createEmptyBorder());
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this._painter = null;
    }

    protected Container createDetailsComponent() {
        if (!(this.optionPane instanceof JideOptionPane)) {
            return null;
        }
        JideOptionPane jideOptionPane = (JideOptionPane)this.optionPane;
        Object object = jideOptionPane.getDetails();
        if (object instanceof Container) {
            this._detailsPreferredWidth = ((Container)object).getPreferredSize().width;
            return (Container)object;
        }
        if (object instanceof Component) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)object);
            this._detailsPreferredWidth = jPanel.getPreferredSize().width;
            return jPanel;
        }
        if (object instanceof String) {
            JTextArea jTextArea = new JTextArea((String)object);
            jTextArea.setEditable(false);
            jTextArea.setRows(20);
            jTextArea.setColumns(60);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(new JScrollPane(jTextArea));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 6, 10, 6));
            this._detailsPreferredWidth = jPanel.getPreferredSize().width;
            return jPanel;
        }
        return null;
    }

    protected Container createButtonArea() {
        boolean bl;
        int n2 = UIDefaultsLookup.getInt("OptionPane.buttonOrientation");
        n2 = n2 == 0 ? 0 : n2;
        ButtonPanel buttonPanel = new ButtonPanel(n2);
        Border border = (Border)UIDefaultsLookup.get("OptionPane.buttonAreaBorder");
        buttonPanel.setName("OptionPane.buttonArea");
        if (border != null) {
            buttonPanel.setBorder(border);
        }
        buttonPanel.setSizeConstraint((bl = UIDefaultsLookup.getBoolean("OptionPane.sameSizeButtons")) ? 0 : 1);
        int n3 = UIDefaultsLookup.getInt("OptionPane.buttonPadding");
        n3 = n3 == 0 ? 6 : n3;
        buttonPanel.setButtonGap(n3);
        this.addButtonComponents(buttonPanel, this.getButtons(), this.getInitialValueIndex());
        return buttonPanel;
    }

    protected void addButtonComponents(Container container, Object[] objectArray, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            int n3 = objectArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                JButton jButton;
                Component component;
                Object object = objectArray[i2];
                if (object instanceof Component) {
                    component = (Component)object;
                    container.add(component, "ALTERNATIVE");
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof ButtonFactory ? ((ButtonFactory)object).createButton() : (object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString()));
                    jButton.setMultiClickThreshhold(UIDefaultsLookup.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(jButton);
                    if ("YES".equals(jButton.getName()) || "NO".equals(jButton.getName()) || "OK".equals(jButton.getName()) || "CLOSE".equals(jButton.getName()) || "FINISH".equals(jButton.getName())) {
                        container.add((Component)jButton, "AFFIRMATIVE");
                    } else if ("CANCEL".equals(jButton.getName())) {
                        container.add((Component)jButton, "CANCEL");
                    } else if ("HELP".equals(jButton.getName())) {
                        container.add((Component)jButton, "HELP");
                    } else {
                        container.add((Component)jButton, "ALTERNATIVE");
                    }
                    if ("DETAILS".equals(jButton.getName())) {
                        jButton.addActionListener(new AbstractAction(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JButton jButton = (JButton)actionEvent.getSource();
                                Container container = jButton.getTopLevelAncestor();
                                ResourceBundle resourceBundle = ButtonResources.getResourceBundle(BasicJideOptionPaneUI.this.optionPane.getLocale());
                                if (BasicJideOptionPaneUI.this._detailsArea.isVisible()) {
                                    BasicJideOptionPaneUI.setDetailsVisible(false);
                                    BasicJideOptionPaneUI.this._detailsArea.setVisible(false);
                                    jButton.setText(resourceBundle.getString("Button.showDetails"));
                                    jButton.setMnemonic(resourceBundle.getString("Button.showDetails.mnemonic").charAt(0));
                                } else {
                                    BasicJideOptionPaneUI.setDetailsVisible(true);
                                    BasicJideOptionPaneUI.this._detailsArea.setVisible(true);
                                    jButton.setText(resourceBundle.getString("Button.hideDetails"));
                                    jButton.setMnemonic(resourceBundle.getString("Button.hideDetails.mnemonic").charAt(0));
                                }
                                if (container instanceof Window) {
                                    ((Window)container).pack();
                                }
                            }
                        });
                        jButton.setVisible(this.shouldDetailsButtonVisible());
                    } else {
                        ActionListener actionListener = this.createButtonActionListener(i2);
                        if (actionListener != null) {
                            jButton.addActionListener(actionListener);
                        }
                    }
                    component = jButton;
                }
                if (i2 != n2) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addAncestorListener(new AncestorListener(){

                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        JButton jButton = (JButton)ancestorEvent.getComponent();
                        JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
                        if (jRootPane != null) {
                            jRootPane.setDefaultButton(jButton);
                        }
                    }

                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }

                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
        }
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                Object[] objectArray2;
                int n2 = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                if (n2 == 0) {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.noIcon"))};
                } else if (n2 == 1) {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.noIcon")), new ButtonFactory("CANCEL", UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (n2 == 2) {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("OK", UIDefaultsLookup.getString("OptionPane.okButtonText", locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.okIcon")), new ButtonFactory("CANCEL", UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (n2 == 3) {
                    objectArray2 = new ButtonFactory[1];
                    ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
                    objectArray2[0] = new ButtonFactory("CLOSE", resourceBundle.getString("Button.close"), resourceBundle.getString("Button.close.mnemonic").charAt(0), null);
                } else {
                    objectArray2 = new ButtonFactory[]{new ButtonFactory("OK", UIDefaultsLookup.getString("OptionPane.okButtonText", locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.okIcon"))};
                }
                return this.addDetailsButton(objectArray2, true);
            }
            return this.addDetailsButton(objectArray, true);
        }
        return null;
    }

    protected Object[] addDetailsButton(Object[] objectArray, boolean bl) {
        if (bl) {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = objectArray[i2];
            }
            ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
            objectArray2[objectArray2.length - 1] = new ButtonFactory("DETAILS", resourceBundle.getString("Button.showDetails"), resourceBundle.getString("Button.showDetails.mnemonic").charAt(0), null);
            return objectArray2;
        }
        return objectArray;
    }

    private boolean shouldDetailsButtonVisible() {
        return this.optionPane instanceof JideOptionPane && ((JideOptionPane)this.optionPane).getDetails() != null;
    }

    protected void configureButton(JButton jButton) {
        Font font = (Font)UIDefaultsLookup.get("OptionPane.buttonFont");
        if (font != null) {
            jButton.setFont(font);
        }
    }

    protected int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIDefaultsLookup.get(string, locale);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setName("OptionPane.iconLabel");
            container.add((Component)jLabel, "Before");
        }
    }

    protected Container createBannerArea() {
        PaintPanel paintPanel = new PaintPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width < BasicJideOptionPaneUI.this._detailsPreferredWidth) {
                    dimension.width = BasicJideOptionPaneUI.this._detailsPreferredWidth;
                }
                return dimension;
            }
        };
        this.customizeBannerArea(paintPanel);
        paintPanel.setLayout(new BorderLayout(10, 10));
        this.addIcon(paintPanel);
        this.updateTitleComponent(paintPanel);
        paintPanel.add((Component)new JLabel(UIDefaultsLookup.getIcon("OptionPane.bannerIcon")), "After");
        return paintPanel;
    }

    protected void customizeBannerArea(PaintPanel paintPanel) {
        Object object;
        Paint paint = (Paint)UIDefaultsLookup.get("OptionPane.bannerBackgroundPaint");
        if (paint != null) {
            paintPanel.setBackgroundPaint(paint);
        } else {
            boolean bl;
            object = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundDk");
            Object object2 = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundLt");
            boolean bl2 = bl = UIDefaultsLookup.get("OptionPane.bannerBackgroundDirection") == null || UIDefaultsLookup.getBoolean("OptionPane.bannerBackgroundDirection");
            if (object == null && object2 != null) {
                object = object2;
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            } else if (object != null && object2 == null) {
                object2 = object;
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            } else if (object != null && object2 != null) {
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            }
        }
        object = UIDefaultsLookup.getBorder("OptionPane.bannerBorder");
        paintPanel.setBorder((Border)(object != null ? object : BorderFactory.createEmptyBorder(0, 10, 0, 0)));
    }

    private void updateTitleComponent(Container container) {
        Object object;
        if (container == null) {
            return;
        }
        if (this._titleComponent != null) {
            container.remove(this._titleComponent);
            this._titleComponent = null;
        }
        Object object2 = object = this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getTitle() : null;
        if (object instanceof String) {
            if (((String)object).startsWith("<html>") || ((String)object).startsWith("<HTML>")) {
                JLabel jLabel = new JLabel((String)object);
                this._titleComponent = jLabel;
            } else {
                String[] stringArray = BasicJideOptionPaneUI.fitInWidth((String)object, UIDefaultsLookup.getInt("OptionPane.bannerMaxCharsPerLine"));
                NullPanel nullPanel = new NullPanel();
                nullPanel.setLayout(new BoxLayout(nullPanel, 1));
                nullPanel.setOpaque(false);
                nullPanel.add(Box.createGlue());
                for (String string : stringArray) {
                    JLabel jLabel = new JLabel(string);
                    jLabel.setFont(jLabel.getFont().deriveFont(UIDefaultsLookup.getInt("OptionPane.bannerFontStyle"), UIDefaultsLookup.getInt("OptionPane.bannerFontSize")));
                    Color color = UIDefaultsLookup.getColor("OptionPane.bannerForeground");
                    jLabel.setForeground(color != null ? color : this.getPainter().getOptionPaneBannerForeground());
                    nullPanel.add(jLabel);
                }
                nullPanel.add(Box.createGlue());
                this._titleComponent = nullPanel;
            }
        } else if (object instanceof Component) {
            this._titleComponent = (Component)object;
        }
        if (this._titleComponent != null) {
            container.add(this._titleComponent, "Center");
        }
    }

    private static String[] fitInWidth(String string, int n2) {
        if (string == null) {
            string = "";
        }
        String string2 = BasicJideOptionPaneUI.blankString(n2, (byte)32);
        string = BasicJideOptionPaneUI.replaceOccurrences(string, "\n", string2);
        string = BasicJideOptionPaneUI.replaceOccurrences(string, "\t", "    ");
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.trim();
        while (string.length() > n2) {
            String string3;
            int n3 = n2;
            if (Character.isLetterOrDigit(string.charAt(n2))) {
                char c2 = string.charAt(--n3);
                while (Character.isLetterOrDigit(c2) && n3 > 0) {
                    c2 = string.charAt(--n3);
                }
                n3 = n3 == 0 && Character.isLetterOrDigit(c2) ? n2 : ++n3;
            }
            if ((string3 = string.substring(0, n3)).length() < n2) {
                string3 = string3 + BasicJideOptionPaneUI.blankString(n2 - string3.length(), (byte)32);
            }
            arrayList.add(string3);
            string = string.substring(n3).trim();
        }
        if (string.length() < n2) {
            string = string + BasicJideOptionPaneUI.blankString(n2 - string.length(), (byte)32);
        }
        arrayList.add(string);
        return arrayList.toArray(new String[1]);
    }

    private static String blankString(int n2, byte by) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, by);
        return new String(byArray);
    }

    private static String replaceOccurrences(String string, String string2, String string3) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = 0;
        while ((n2 = BasicJideOptionPaneUI.indexOf(stringBuffer, string2, n3)) >= 0) {
            stringBuffer.replace(n2, n2 + string2.length(), string3);
            n3 = n2 + string3.length();
        }
        return stringBuffer.toString();
    }

    private static int indexOf(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
        if (n6 >= n3) {
            return n5 == 0 ? n3 : -1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 == 0) {
            return n6;
        }
        char c2 = cArray2[n4];
        int n7 = n2 + n6;
        int n8 = n2 + (n3 - n5);
        block0: while (true) {
            if (n7 <= n8 && cArray[n7] != c2) {
                ++n7;
                continue;
            }
            if (n7 > n8) {
                return -1;
            }
            int n9 = n7 + 1;
            int n10 = n9 + n5 - 1;
            int n11 = n4 + 1;
            while (n9 < n10) {
                if (cArray[n9++] == cArray2[n11++]) continue;
                ++n7;
                continue block0;
            }
            break;
        }
        return n7 - n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(StringBuffer stringBuffer, String string, int n2) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n3 = stringBuffer.length();
            char[] cArray = new char[n3];
            stringBuffer.getChars(0, n3, cArray, 0);
            return BasicJideOptionPaneUI.indexOf(cArray, 0, n3, string.toCharArray(), 0, string.length(), n2);
        }
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected static class ButtonFactory {
        private String name;
        private String text;
        private int mnemonic;
        private Icon icon;

        ButtonFactory(String string, String string2, int n2, Icon icon) {
            this.name = string;
            this.text = string2;
            this.mnemonic = n2;
            this.icon = icon;
        }

        JButton createButton() {
            JButton jButton = new JButton(this.text);
            if (this.name != null) {
                jButton.setName(this.name);
            }
            if (this.icon != null) {
                jButton.setIcon(this.icon);
            }
            if (this.mnemonic != 0) {
                jButton.setMnemonic(this.mnemonic);
            }
            return jButton;
        }
    }
}

