/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;

public class EpigeneticsUtils {
    static int step = 25;
    static int span = 25;

    public static void main(String[] args) {
        try {
            String dir = "/Volumes/igv/data/public/epigenetics/WilmsTumor/wig/orig";
            String outputDir = "/Volumes/igv/data/public/epigenetics/WilmsTumor/wig";
            EpigeneticsUtils.createCombinedWigs(new File(dir), new File(outputDir));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void convertToTDF(File inputDir, String outputDir) {
        for (File f2 : inputDir.listFiles()) {
            String ifile = f2.getName();
            if (!ifile.endsWith(".wig")) continue;
            String oFile = outputDir + f2.getName() + ".tdf";
            String logFile = f2.getName() + ".out";
            System.out.println("/xchip/igv/tools/igvtools tile " + ifile + " " + oFile + " hg18 > " + logFile + " &");
        }
    }

    public static void createCombinedWigs(File inputDir, File outputDir) throws IOException {
        Map<String, List<File>> fileMap = EpigeneticsUtils.getFilesBySample(inputDir);
        for (Map.Entry<String, List<File>> entry : fileMap.entrySet()) {
            String sampleName = entry.getKey();
            File oFile = new File(outputDir, sampleName + ".wig");
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(oFile)));
            String cs = EpigeneticsUtils.getColor(sampleName);
            pw.println("#type=" + (Object)((Object)TrackType.CHIP));
            pw.print("track  type=wiggle_0 name=" + sampleName + " viewLimits=0:10");
            if (cs == null) {
                pw.println();
            } else {
                pw.println(" color=" + cs);
            }
            for (File f2 : entry.getValue()) {
                BufferedReader br = ParsingUtils.openBufferedReader(f2.getAbsolutePath());
                String stepLine = br.readLine();
                if (!stepLine.startsWith("fixedStep") || !stepLine.contains("start=1")) {
                    throw new RuntimeException("Unexpected step line: " + stepLine);
                }
                String[] tokens = stepLine.split(" ");
                String chromString = null;
                for (String s : tokens) {
                    if (!s.startsWith("chrom")) continue;
                    chromString = s.trim();
                    break;
                }
                if (chromString == null) {
                    throw new RuntimeException("Missing chrom string: " + stepLine);
                }
                String chr = chromString.split("=")[1];
                String nextLine = br.readLine();
                int value = Integer.parseInt(nextLine.trim());
                int startPos = 0;
                int endPos = step;
                while ((nextLine = br.readLine()) != null) {
                    int v = Integer.parseInt(nextLine.trim());
                    if (v != value && value >= 0) {
                        pw.println(chr + "\t" + startPos + "\t" + endPos + "\t" + value);
                        startPos = endPos;
                    }
                    if (value < 0) {
                        startPos += step;
                    }
                    value = v;
                    endPos += step;
                }
                if (value >= 0) {
                    pw.println(chr + "\t" + startPos + "\t" + endPos + "\t" + value);
                    startPos = endPos;
                }
                br.close();
            }
            pw.close();
        }
    }

    static Map<String, List<File>> getFilesBySample(File directory) {
        HashMap<String, List<File>> fileMap = new HashMap<String, List<File>>();
        for (File f2 : directory.listFiles()) {
            String[] tokens;
            String fn = f2.getName();
            if (!fn.endsWith("wig") && !fn.endsWith("wig.gz") || (tokens = fn.split("_")).length <= 0) continue;
            int sz = tokens.length - 1;
            String s = tokens[0];
            for (int i2 = 1; i2 < sz; ++i2) {
                s = s + "_" + tokens[i2];
            }
            ArrayList<File> files = (ArrayList<File>)fileMap.get(s);
            if (files == null) {
                files = new ArrayList<File>();
                fileMap.put(s, files);
            }
            files.add(f2);
        }
        return fileMap;
    }

    static String getColor(String sampleName) {
        if (sampleName.contains("K4")) {
            return "0,150,0";
        }
        if (sampleName.contains("K9")) {
            return "100,0,0";
        }
        if (sampleName.contains("K27")) {
            return "255,0,0";
        }
        return null;
    }
}

