/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.example;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.Tribble;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.dbsnp.OldDbSNPCodec;
import org.broad.tribble.gelitext.GeliTextCodec;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broad.tribble.source.BasicFeatureSource;
import org.broad.tribble.util.LittleEndianOutputStream;

public class CountRecords {
    private static Logger logger = Logger.getRootLogger();

    public static void main(String[] args) {
        File featureFile;
        BasicConfigurator.configure();
        if (args.length > 2) {
            CountRecords.printUsage();
        }
        if (!(featureFile = new File(args[0])).exists()) {
            System.err.println("File " + featureFile.getAbsolutePath() + " doesnt' exist");
            CountRecords.printUsage();
        }
        int optimizeIndex = args.length == 2 ? Integer.valueOf(args[1]) : -1;
        FeatureCodec codec = CountRecords.getFeatureCodec(featureFile);
        CountRecords.runWithIndex(featureFile, codec, optimizeIndex);
    }

    public static long runWithIndex(File featureInput, FeatureCodec codec, int optimizeThreshold) {
        Index index = CountRecords.loadIndex(featureInput, codec);
        if (optimizeThreshold != -1) {
            ((LinearIndex)index).optimize(optimizeThreshold);
        }
        BasicFeatureSource source = null;
        try {
            source = new BasicFeatureSource(featureInput.getAbsolutePath(), index, codec);
            long recordCount = 0L;
            CloseableTribbleIterator iter = source.iterator();
            while (iter.hasNext()) {
                Feature feat = (Feature)iter.next();
                ++recordCount;
            }
            System.err.println("We saw " + recordCount + " record in file " + featureInput);
            return recordCount;
        }
        catch (IOException e2) {
            throw new RuntimeException("Something went wrong while reading feature file " + featureInput, e2);
        }
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar CountRecords.jar <inputFile>");
        System.err.println("    Where input can be of type: VCF (ends in .vcf or .VCF");
        System.err.println("                                Bed (ends in .bed or .bed");
        System.err.println("                                OldDbSNP (ends in .snp or .rod");
        System.exit(1);
    }

    public static Index loadIndex(File featureFile, FeatureCodec codec) {
        File indexFile = Tribble.indexFile(featureFile);
        Index index = null;
        if (indexFile.canRead()) {
            System.err.println("Loading index from disk for index file -> " + indexFile);
            index = IndexFactory.loadIndex(indexFile.getAbsolutePath());
        } else {
            System.err.println("Creating the index and memory, then writing to disk for index file -> " + indexFile);
            index = CountRecords.createAndWriteNewIndex(featureFile, indexFile, codec);
        }
        return index;
    }

    public static Index createAndWriteNewIndex(File featureFile, File indexFile, FeatureCodec codec) {
        try {
            Index index = IndexFactory.createIndex(featureFile, codec);
            LittleEndianOutputStream stream = new LittleEndianOutputStream(new FileOutputStream(indexFile));
            index.write(stream);
            stream.close();
            return index;
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to create index from file " + featureFile, e2);
        }
    }

    public static FeatureCodec getFeatureCodec(File featureFile) {
        if (featureFile.getName().endsWith(".bed") || featureFile.getName().endsWith(".BED")) {
            return new BEDCodec();
        }
        if (featureFile.getName().endsWith(".snp") || featureFile.getName().endsWith(".rod")) {
            return new OldDbSNPCodec();
        }
        if (featureFile.getName().endsWith(".geli.calls") || featureFile.getName().endsWith(".geli")) {
            return new GeliTextCodec();
        }
        throw new IllegalArgumentException("Unable to determine correct file type based on the file name, for file -> " + featureFile);
    }
}

