/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;

public class GeneListManager {
    private static Logger log = Logger.getLogger(GeneListManager.class);
    public static final String[] DEFAULT_GENE_LISTS = new String[]{"examples.gmt", "reactome_cp.gmt", "kegg_cancer_cp.gmt"};
    public static final String USER_GROUP = "My lists";
    private LinkedHashSet<String> groups = new LinkedHashSet();
    private HashMap<String, File> importedFiles = new HashMap();
    private LinkedHashMap<String, GeneList> geneLists = new LinkedHashMap();
    static GeneListManager theInstance;

    public static GeneListManager getInstance() {
        if (theInstance == null) {
            theInstance = new GeneListManager();
        }
        return theInstance;
    }

    private GeneListManager() {
        this.loadDefaultLists();
        this.loadUserLists();
    }

    public GeneList getGeneList(String listID) {
        return this.geneLists.get(listID);
    }

    public LinkedHashMap<String, GeneList> getGeneLists() {
        return this.geneLists;
    }

    public void addGeneList(GeneList genes) {
        this.geneLists.put(genes.getName(), genes);
        this.groups.add(genes.getGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultLists() {
        for (String geneListFile : DEFAULT_GENE_LISTS) {
            InputStream is = GeneListManager.class.getResourceAsStream(geneListFile);
            if (is == null) {
                log.info("Could not find gene list resource: " + geneListFile);
                return;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is));
                new BufferedReader(new InputStreamReader(is));
                List<GeneList> lists = this.loadGMT(geneListFile, reader);
                for (GeneList gl : lists) {
                    gl.setEditable(false);
                    this.addGeneList(gl);
                }
            }
            catch (IOException e2) {
                log.error("Error loading default gene lists", e2);
                MessageUtils.showMessage("<html>Error encountered loading gene lists (" + e2.toString() + ")" + "<br/>See log for more details");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e3) {}
            }
        }
    }

    private void loadUserLists() {
        File dir = Globals.getGeneListDirectory();
        if (dir.exists()) {
            for (File f2 : dir.listFiles()) {
                try {
                    if (f2.getName().toLowerCase().endsWith(".gmt")) {
                        this.importGMTFile(f2);
                        continue;
                    }
                    GeneList geneList = this.loadGRPFile(f2);
                    geneList.setGroup(USER_GROUP);
                    if (geneList == null) continue;
                    this.addGeneList(geneList);
                }
                catch (IOException e2) {
                    log.error("Error loading user gene lists: ", e2);
                    MessageUtils.showMessage("<html>Error encountered loading user gene lists (" + e2.toString() + ")" + "<br/>See log for more details");
                }
            }
        }
        if (!this.groups.contains(USER_GROUP)) {
            this.groups.add(USER_GROUP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeneList loadGRPFile(File grpFile) throws IOException {
        File f2 = grpFile;
        File dir = Globals.getGeneListDirectory();
        if (!dir.equals(grpFile.getParentFile())) {
            f2 = new File(dir, grpFile.getName());
            FileUtils.copyFile(grpFile, f2);
        }
        String name = f2.getName();
        String group = USER_GROUP;
        String description = null;
        ArrayList<String> genes = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String nextLine;
            reader = new BufferedReader(new FileReader(f2));
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#")) {
                    if (nextLine.startsWith("#name")) {
                        tokens = nextLine.split("=");
                        if (tokens.length <= 1) continue;
                        name = tokens[1];
                        continue;
                    }
                    if (!nextLine.startsWith("#description") || (tokens = nextLine.split("=")).length <= 1) continue;
                    description = tokens[1];
                    continue;
                }
                for (String s : tokens = nextLine.split("\\s+")) {
                    genes.add(s);
                }
            }
            if (genes.size() > 0) {
                if (name == null) {
                    name = f2.getName();
                }
                this.importedFiles.put(name, f2);
                GeneList geneList = new GeneList(name, description, group, genes);
                return geneList;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGMTFile(File gmtFile) throws IOException {
        File f2 = gmtFile;
        File dir = Globals.getGeneListDirectory();
        if (!dir.equals(gmtFile.getParentFile())) {
            f2 = new File(dir, gmtFile.getName());
            FileUtils.copyFile(gmtFile, f2);
        }
        String group = f2.getName().replace(".gmt", "");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f2));
            this.importedFiles.put(group, f2);
            List<GeneList> lists = this.loadGMT(group, reader);
            for (GeneList gl : lists) {
                gl.setEditable(false);
                this.addGeneList(gl);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeneList> importGMTFile(String path) throws IOException {
        BufferedReader reader = null;
        try {
            String group = new File(path).getName();
            reader = ParsingUtils.openBufferedReader(path);
            List<GeneList> lists = this.loadGMT(group, reader);
            for (GeneList gl : lists) {
                gl.setEditable(false);
                this.addGeneList(gl);
            }
            List<GeneList> list = lists;
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private List<GeneList> loadGMT(String group, BufferedReader reader) throws IOException {
        String nextLine;
        ArrayList<GeneList> lists = new ArrayList<GeneList>();
        while ((nextLine = reader.readLine()) != null) {
            String[] tokens;
            if (nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#group") && !nextLine.startsWith("#name") || (tokens = nextLine.split("=")).length <= 1) continue;
                group = tokens[1];
                continue;
            }
            tokens = nextLine.split("\t");
            if (tokens.length <= 2) continue;
            String name = tokens[0];
            String description = tokens[1].replaceFirst(">", "");
            ArrayList<String> genes = new ArrayList<String>();
            for (int i2 = 2; i2 < tokens.length; ++i2) {
                genes.add(tokens[i2]);
            }
            lists.add(new GeneList(name, description, group, genes));
        }
        return lists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGeneList(GeneList geneList) {
        File file = null;
        PrintWriter pw = null;
        try {
            String listName = geneList.getName();
            String description = geneList.getDescription();
            List<String> genes = geneList.getLoci();
            if (listName != null && genes != null) {
                file = new File(Globals.getGeneListDirectory(), GeneListManager.getLegalFilename(listName) + ".grp");
                pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                pw.println("#name=" + listName);
                if (description != null) {
                    pw.println("#description=" + description);
                }
                for (String s : genes) {
                    pw.println(s);
                }
                pw.close();
                this.importedFiles.put(listName, file);
            }
        }
        catch (IOException e2) {
            if (file != null) {
                MessageUtils.showMessage("Error writing gene list file: " + file.getAbsolutePath() + " " + e2.getMessage());
            }
            log.error("Error saving gene list", e2);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static String getLegalFilename(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return s;
        }
    }

    public boolean isImported(String groupName) {
        return this.importedFiles.containsKey(groupName);
    }

    public LinkedHashSet<String> getGroups() {
        return this.groups;
    }

    public void deleteGroup(String selectedGroup) {
        File f2 = this.importedFiles.get(selectedGroup);
        if (f2.exists()) {
            f2.delete();
        }
        this.groups.remove(selectedGroup);
        this.importedFiles.remove(selectedGroup);
        ArrayList<GeneList> tmp = new ArrayList<GeneList>(this.geneLists.values());
        for (GeneList gl : tmp) {
            if (!gl.getGroup().equals(selectedGroup)) continue;
            this.geneLists.remove(gl.getName());
        }
    }

    public boolean deleteList(String listName) {
        File f2 = this.importedFiles.get(listName);
        if (f2.exists()) {
            f2.delete();
        }
        this.importedFiles.remove(listName);
        if (this.geneLists.containsKey(listName)) {
            String group = this.geneLists.get(listName).getGroup();
            this.geneLists.remove(listName);
            if (!group.equals(USER_GROUP)) {
                for (GeneList gl : this.geneLists.values()) {
                    if (!gl.getGroup().equals(group)) continue;
                    return false;
                }
                this.groups.remove(group);
                return true;
            }
        }
        return false;
    }
}

