/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.DistributionFactory;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.distribution.PoissonDistribution;
import org.apache.commons.math.special.Gamma;
import org.apache.commons.math.util.MathUtils;

public class PoissonDistributionImpl
extends AbstractIntegerDistribution
implements PoissonDistribution,
Serializable {
    private static final long serialVersionUID = -3349935121172596109L;
    private double mean;

    public PoissonDistributionImpl(double p2) {
        this.setMean(p2);
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double p2) {
        if (p2 <= 0.0) {
            throw new IllegalArgumentException("The Poisson mean must be positive");
        }
        this.mean = p2;
    }

    public double probability(int x) {
        if (x < 0 || x == Integer.MAX_VALUE) {
            return 0.0;
        }
        return Math.pow(this.getMean(), x) / MathUtils.factorialDouble(x) * Math.exp(-this.mean);
    }

    public double cumulativeProbability(int x) throws MathException {
        if (x < 0) {
            return 0.0;
        }
        if (x == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x + 1.0, this.mean, 1.0E-12, Integer.MAX_VALUE);
    }

    public double normalApproximateProbability(int x) throws MathException {
        NormalDistribution normal = DistributionFactory.newInstance().createNormalDistribution(this.getMean(), Math.sqrt(this.getMean()));
        return normal.cumulativeProbability((double)x + 0.5);
    }

    protected int getDomainLowerBound(double p2) {
        return 0;
    }

    protected int getDomainUpperBound(double p2) {
        return Integer.MAX_VALUE;
    }
}

