/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverImpl;

public class BrentSolver
extends UnivariateRealSolverImpl {
    private static final long serialVersionUID = 3350616277306882875L;

    public BrentSolver(UnivariateRealFunction f2) {
        super(f2, 100, 1.0E-6);
    }

    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(min, max);
    }

    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        double delta;
        this.clearResult();
        this.verifyInterval(min, max);
        double x0 = min;
        double x1 = max;
        double y0 = this.f.value(x0);
        double y1 = this.f.value(x1);
        if (y0 * y1 >= 0.0) {
            throw new IllegalArgumentException("Function values at endpoints do not have different signs.  Endpoints: [" + min + "," + max + "]" + "  Values: [" + y0 + "," + y1 + "]");
        }
        double x2 = x0;
        double y2 = y0;
        double oldDelta = delta = x1 - x0;
        int i2 = 0;
        while (i2 < this.maximalIterationCount) {
            if (Math.abs(y2) < Math.abs(y1)) {
                x0 = x1;
                x1 = x2;
                x2 = x0;
                y0 = y1;
                y1 = y2;
                y2 = y0;
            }
            if (Math.abs(y1) <= this.functionValueAccuracy) {
                this.setResult(x1, i2);
                return this.result;
            }
            double dx = x2 - x1;
            double tolerance = Math.max(this.relativeAccuracy * Math.abs(x1), this.absoluteAccuracy);
            if (Math.abs(dx) <= tolerance) {
                this.setResult(x1, i2);
                return this.result;
            }
            if (Math.abs(oldDelta) < tolerance || Math.abs(y0) <= Math.abs(y1)) {
                oldDelta = delta = 0.5 * dx;
            } else {
                double p1;
                double p2;
                double r3 = y1 / y0;
                if (x0 == x2) {
                    p2 = dx * r3;
                    p1 = 1.0 - r3;
                } else {
                    double r1 = y0 / y2;
                    double r2 = y1 / y2;
                    p2 = r3 * (dx * r1 * (r1 - r2) - (x1 - x0) * (r2 - 1.0));
                    p1 = (r1 - 1.0) * (r2 - 1.0) * (r3 - 1.0);
                }
                if (p2 > 0.0) {
                    p1 = -p1;
                } else {
                    p2 = -p2;
                }
                if (2.0 * p2 >= 1.5 * dx * p1 - Math.abs(tolerance * p1) || p2 >= Math.abs(0.5 * oldDelta * p1)) {
                    oldDelta = delta = 0.5 * dx;
                } else {
                    oldDelta = delta;
                    delta = p2 / p1;
                }
            }
            x0 = x1;
            y0 = y1;
            if (Math.abs(delta) > tolerance) {
                x1 += delta;
            } else if (dx > 0.0) {
                x1 += 0.5 * tolerance;
            } else if (dx <= 0.0) {
                x1 -= 0.5 * tolerance;
            }
            y1 = this.f.value(x1);
            if (y1 > 0.0 == y2 > 0.0) {
                x2 = x0;
                y2 = y0;
                oldDelta = delta = x1 - x0;
            }
            ++i2;
        }
        throw new ConvergenceException("Maximum number of iterations exceeded.");
    }
}

