/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Allele
implements Comparable<Allele> {
    private static final byte[] EMPTY_ALLELE_BASES = new byte[0];
    private boolean isRef = false;
    private boolean isNull = false;
    private boolean isNoCall = false;
    private boolean isSymbolic = false;
    private byte[] bases = null;
    public static final String NULL_ALLELE_STRING = "-";
    public static final String NO_CALL_STRING = ".";
    private static final Allele REF_A = new Allele("A", true);
    private static final Allele ALT_A = new Allele("A", false);
    private static final Allele REF_C = new Allele("C", true);
    private static final Allele ALT_C = new Allele("C", false);
    private static final Allele REF_G = new Allele("G", true);
    private static final Allele ALT_G = new Allele("G", false);
    private static final Allele REF_T = new Allele("T", true);
    private static final Allele ALT_T = new Allele("T", false);
    private static final Allele REF_N = new Allele("N", true);
    private static final Allele ALT_N = new Allele("N", false);
    private static final Allele REF_NULL = new Allele("-", true);
    private static final Allele ALT_NULL = new Allele("-", false);
    public static final Allele NO_CALL = new Allele(".", false);

    private Allele(byte[] bases, boolean isRef) {
        if (Allele.wouldBeNullAllele(bases)) {
            bases = EMPTY_ALLELE_BASES;
            this.isNull = true;
        } else if (Allele.wouldBeNoCallAllele(bases)) {
            bases = EMPTY_ALLELE_BASES;
            this.isNoCall = true;
            if (isRef) {
                throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
            }
        } else if (Allele.wouldBeSymbolicAllele(bases)) {
            this.isSymbolic = true;
            if (isRef) {
                throw new IllegalArgumentException("Cannot tag a symbolic allele as the reference allele");
            }
        }
        this.isRef = isRef;
        this.bases = bases;
        if (!Allele.acceptableAlleleBases(bases)) {
            throw new IllegalArgumentException("Unexpected base in allele bases '" + new String(bases) + "'");
        }
    }

    private Allele(String bases, boolean isRef) {
        this(bases.getBytes(), isRef);
    }

    public static Allele create(byte[] bases, boolean isRef) {
        if (bases == null) {
            throw new IllegalArgumentException("create: the Allele base string cannot be null; use new Allele() or new Allele(\"\") to create a Null allele");
        }
        if (bases.length == 1) {
            switch (bases[0]) {
                case 46: {
                    if (isRef) {
                        throw new IllegalArgumentException("Cannot tag a NoCall allele as the reference allele");
                    }
                    return NO_CALL;
                }
                case 45: {
                    return isRef ? REF_NULL : ALT_NULL;
                }
                case 65: 
                case 97: {
                    return isRef ? REF_A : ALT_A;
                }
                case 67: 
                case 99: {
                    return isRef ? REF_C : ALT_C;
                }
                case 71: 
                case 103: {
                    return isRef ? REF_G : ALT_G;
                }
                case 84: 
                case 116: {
                    return isRef ? REF_T : ALT_T;
                }
                case 78: 
                case 110: {
                    return isRef ? REF_N : ALT_N;
                }
            }
            throw new IllegalArgumentException("Illegal base: " + (char)bases[0]);
        }
        return new Allele(bases, isRef);
    }

    public static Allele create(byte base, boolean isRef) {
        return Allele.create(new byte[]{base}, isRef);
    }

    public static Allele create(byte base) {
        return Allele.create(base, false);
    }

    public static Allele extend(Allele left, byte[] right) {
        if (left.isSymbolic()) {
            throw new IllegalArgumentException("Cannot extend a symbolic allele");
        }
        byte[] bases = null;
        if (left.length() == 0) {
            bases = right;
        } else {
            bases = new byte[left.length() + right.length];
            System.arraycopy(left.getBases(), 0, bases, 0, left.length());
            System.arraycopy(right, 0, bases, left.length(), right.length);
        }
        return Allele.create(bases, left.isReference());
    }

    public static boolean wouldBeNullAllele(byte[] bases) {
        return bases.length == 1 && bases[0] == 45 || bases.length == 0;
    }

    public static boolean wouldBeNoCallAllele(byte[] bases) {
        return bases.length == 1 && bases[0] == 46;
    }

    public static boolean wouldBeSymbolicAllele(byte[] bases) {
        return bases.length > 2 && bases[0] == 60 && bases[bases.length - 1] == 62;
    }

    public static boolean acceptableAlleleBases(String bases) {
        return Allele.acceptableAlleleBases(bases.getBytes());
    }

    public static boolean acceptableAlleleBases(byte[] bases) {
        if (Allele.wouldBeNullAllele(bases) || Allele.wouldBeNoCallAllele(bases) || Allele.wouldBeSymbolicAllele(bases)) {
            return true;
        }
        block3: for (int i2 = 0; i2 < bases.length; ++i2) {
            switch (bases[i2]) {
                case 65: 
                case 67: 
                case 71: 
                case 78: 
                case 84: 
                case 97: 
                case 99: 
                case 103: 
                case 110: 
                case 116: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static Allele create(String bases, boolean isRef) {
        return Allele.create(bases.getBytes(), isRef);
    }

    public static Allele create(String bases) {
        return Allele.create(bases, false);
    }

    public static Allele create(byte[] bases) {
        return Allele.create(bases, false);
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isNonNull() {
        return !this.isNull();
    }

    public boolean isNoCall() {
        return this.isNoCall;
    }

    public boolean isCalled() {
        return !this.isNoCall();
    }

    public boolean isReference() {
        return this.isRef;
    }

    public boolean isNonReference() {
        return !this.isReference();
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    public String toString() {
        return (this.isNull() ? NULL_ALLELE_STRING : (this.isNoCall() ? NO_CALL_STRING : this.getDisplayString())) + (this.isReference() ? "*" : "");
    }

    public byte[] getBases() {
        return this.isSymbolic ? EMPTY_ALLELE_BASES : this.bases;
    }

    public String getBaseString() {
        return new String(this.getBases());
    }

    public String getDisplayString() {
        return new String(this.bases);
    }

    public boolean equals(Object other) {
        return !(other instanceof Allele) ? false : this.equals((Allele)other, false);
    }

    public int hashCode() {
        int hash = 1;
        for (int i2 = 0; i2 < this.bases.length; ++i2) {
            hash += (i2 + 1) * this.bases[i2];
        }
        return hash;
    }

    public boolean equals(Allele other, boolean ignoreRefState) {
        return this == other || (this.isRef == other.isRef || ignoreRefState) && this.isNull == other.isNull && this.isNoCall == other.isNoCall && (this.bases == other.bases || Arrays.equals(this.bases, other.bases));
    }

    public boolean basesMatch(byte[] test) {
        return !this.isSymbolic && (this.bases == test || Arrays.equals(this.bases, test));
    }

    public boolean basesMatch(String test) {
        return this.basesMatch(test.toUpperCase().getBytes());
    }

    public boolean basesMatch(Allele test) {
        return this.basesMatch(test.getBases());
    }

    public int length() {
        return this.isSymbolic ? 0 : this.bases.length;
    }

    public static Allele getMatchingAllele(Collection<Allele> allAlleles, String alleleBases) {
        return Allele.getMatchingAllele(allAlleles, alleleBases.getBytes());
    }

    public static Allele getMatchingAllele(Collection<Allele> allAlleles, byte[] alleleBases) {
        for (Allele a2 : allAlleles) {
            if (!a2.basesMatch(alleleBases)) continue;
            return a2;
        }
        if (Allele.wouldBeNoCallAllele(alleleBases)) {
            return NO_CALL;
        }
        return null;
    }

    public static List<Allele> resolveAlleles(List<Allele> possibleAlleles, List<String> alleleStrings) {
        ArrayList<Allele> myAlleles = new ArrayList<Allele>(alleleStrings.size());
        for (String alleleString : alleleStrings) {
            Allele allele = Allele.getMatchingAllele(possibleAlleles, alleleString);
            if (allele == null) {
                if (Allele.wouldBeNoCallAllele(alleleString.getBytes())) {
                    allele = Allele.create(alleleString);
                } else {
                    throw new IllegalArgumentException("Allele " + alleleString + " not present in the list of alleles " + possibleAlleles);
                }
            }
            myAlleles.add(allele);
        }
        return myAlleles;
    }

    @Override
    public int compareTo(Allele other) {
        if (this.isReference() && other.isNonReference()) {
            return -1;
        }
        if (this.isNonReference() && other.isReference()) {
            return 1;
        }
        return this.getBaseString().compareTo(other.getBaseString());
    }

    public static boolean oneIsPrefixOfOther(Allele a1, Allele a2) {
        if (a1.isNull() || a2.isNull()) {
            return true;
        }
        if (a2.length() >= a1.length()) {
            return Allele.firstIsPrefixOfSecond(a1, a2);
        }
        return Allele.firstIsPrefixOfSecond(a2, a1);
    }

    private static boolean firstIsPrefixOfSecond(Allele a1, Allele a2) {
        String a1String = a1.getBaseString();
        return a2.getBaseString().substring(0, a1String.length()).equals(a1String);
    }
}

