/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.tribble.util.URLHelper;

public class HTTPHelper
implements URLHelper {
    private static Logger log = Logger.getLogger(HTTPHelper.class);
    static Proxy proxy;
    private URL url;

    public HTTPHelper(URL url) {
        this.url = url;
        proxy = null;
    }

    public static synchronized void setProxy(Proxy p2) {
        proxy = p2;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getContentLength() throws IOException {
        HttpURLConnection con = null;
        try {
            con = this.openConnection();
            con.setRequestMethod("HEAD");
            if (con.getResponseCode() != 200) {
                log.error("Error (" + con.getResponseMessage() + " ) fetching content length: " + this.url);
                long l2 = -1L;
                return l2;
            }
            String contentLength = con.getHeaderField("Content-Length");
            long l3 = contentLength == null ? -1L : Long.parseLong(contentLength);
            return l3;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    @Override
    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        HttpURLConnection connection = this.openConnection();
        String byteRange = "bytes=" + start + "-" + end;
        connection.setRequestProperty("Range", byteRange);
        return new WrapperInputStream(connection, connection.getInputStream());
    }

    private HttpURLConnection openConnection() throws IOException {
        HttpURLConnection connection = proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(proxy);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        HttpURLConnection con = null;
        try {
            con = this.openConnection();
            con.setRequestMethod("HEAD");
            boolean bl = con.getResponseCode() == 200;
            return bl;
        }
        catch (Exception e2) {
            log.error("Error connecting to url: " + this.url, e2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    class WrapperInputStream
    extends FilterInputStream {
        HttpURLConnection connection;

        protected WrapperInputStream(HttpURLConnection connection, InputStream inputStream) {
            super(inputStream);
            this.connection = connection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.connection.disconnect();
        }
    }
}

