/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.source.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.source.query.QuerySource;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class IndexFreeAsciiQuerySource
implements QuerySource {
    private final String inputFile;
    private BufferingLineReader lineReader;

    public IndexFreeAsciiQuerySource(String featureFile) throws IOException {
        this.inputFile = featureFile;
    }

    @Override
    public LineReader iterate() throws IOException {
        return this.getLineReader();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark() throws IOException {
        this.getLineReader().mark();
    }

    @Override
    public void reset() throws IOException {
        this.getLineReader().reset();
    }

    @Override
    public LineReader query(String s, int i2, int i1) {
        throw new UnsupportedOperationException("Unable to query from IndexFreeAsciiQuerySource");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<String> getSequenceNames() {
        throw new UnsupportedOperationException("Unable to query sequence names from IndexFreeAsciiQuerySource");
    }

    private BufferingLineReader getLineReader() throws IOException {
        if (this.lineReader == null) {
            SeekableStream is = SeekableStreamFactory.getStreamFor(this.inputFile);
            this.lineReader = new BufferingLineReader(new AsciiLineReader(is));
        }
        return this.lineReader;
    }

    private class BufferingLineReader
    implements LineReader {
        private final LineReader wrappedReader;
        private final LinkedList<String> lineBuffer = new LinkedList();
        private boolean isBuffering = false;

        public BufferingLineReader(LineReader wrappedReader) {
            this.wrappedReader = wrappedReader;
        }

        @Override
        public String readLine() throws IOException {
            String currentLine;
            if (this.isBuffering) {
                currentLine = this.wrappedReader.readLine();
                this.lineBuffer.add(currentLine);
            } else {
                currentLine = !this.lineBuffer.isEmpty() ? this.lineBuffer.remove() : this.wrappedReader.readLine();
            }
            return currentLine;
        }

        @Override
        public void close() {
            this.wrappedReader.close();
            this.lineBuffer.clear();
        }

        public void mark() {
            this.isBuffering = true;
            this.lineBuffer.clear();
        }

        public void reset() {
            if (!this.isBuffering) {
                throw new TribbleException("Reset called on BufferingLineReader without corresponding mark().");
            }
            this.isBuffering = false;
        }
    }
}

