/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import org.broad.igv.hic.ColorScale;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.ContactRecord;
import org.broad.igv.hic.data.MatrixZoomData;

public class HeatmapRenderer {
    ColorScale colorScale;

    public HeatmapRenderer(ColorScale colorScale) {
        this.colorScale = colorScale;
    }

    public void render(int originX, int originY, int width, int height, MatrixZoomData zd, Graphics g2) {
        int chr1 = zd.getChr1();
        int chr2 = zd.getChr2();
        int maxX = originX + width;
        int maxY = originY + height;
        int x = originX;
        int y = originY;
        if (chr1 == chr2) {
            if (x > y) {
                x = originY;
                y = originX;
            }
            if (maxX > maxY) {
                int tmp = maxX;
                maxX = maxY;
                maxY = tmp;
            }
        }
        List<Block> blocks = zd.getBlocksOverlapping(x, y, maxX, maxY);
        boolean isWholeGenome = zd.getChr1() == 0 && zd.getChr2() == 0;
        for (Block b2 : blocks) {
            ContactRecord[] recs = b2.getContactRecords();
            if (recs == null) continue;
            for (int i2 = 0; i2 < recs.length; ++i2) {
                ContactRecord rec = recs[i2];
                Color color = null;
                double binSizeMB = (double)zd.getBinSize() / (isWholeGenome ? 1000.0 : 1000000.0);
                double score = (double)rec.getCounts() / (binSizeMB * binSizeMB);
                color = this.colorScale.getColor(score);
                int px = rec.getX() - originX;
                int py = rec.getY() - originY;
                g2.setColor(color);
                g2.fillRect(px, py, 1, 1);
                if (chr1 != chr2) continue;
                px = rec.getY() - originX;
                py = rec.getX() - originY;
                g2.fillRect(px, py, 1, 1);
            }
        }
    }
}

