/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.lang;

import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.util.TextPattern;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.io.Writer;
import java.util.Arrays;

public class MutableString
implements Serializable,
CharSequence,
Appendable,
Comparable<MutableString>,
Cloneable {
    private static final MutableString NULL = new MutableString("null");
    protected transient char[] array;
    protected transient int hashLength;
    public static final long serialVersionUID = -518929984008928417L;

    public MutableString() {
        this(2);
    }

    public MutableString(int capacity) {
        this.array = capacity != 0 ? new char[capacity] : CharArrays.EMPTY_ARRAY;
    }

    private void makeCompactMutableString(int length) {
        this.array = length != 0 ? new char[length] : CharArrays.EMPTY_ARRAY;
        this.hashLength = -1;
    }

    public MutableString(MutableString s) {
        this.makeCompactMutableString(s.length());
        System.arraycopy(s.array, 0, this.array, 0, this.array.length);
    }

    public MutableString(String s) {
        this.makeCompactMutableString(s.length());
        s.getChars(0, this.array.length, this.array, 0);
    }

    public MutableString(CharSequence s) {
        this.makeCompactMutableString(s.length());
        MutableString.getChars(s, 0, this.array.length, this.array, 0);
    }

    public MutableString(char[] a2) {
        this.makeCompactMutableString(a2.length);
        System.arraycopy(a2, 0, this.array, 0, this.array.length);
    }

    public MutableString(char[] a2, int offset, int len) {
        this.makeCompactMutableString(len);
        System.arraycopy(a2, offset, this.array, 0, len);
    }

    public MutableString copy() {
        return new MutableString(this);
    }

    public Object clone() {
        return new MutableString(this);
    }

    public static void getChars(CharSequence s, int start, int end, char[] dest, int destStart) {
        int j2 = destStart;
        int i2 = start;
        while (i2 < end) {
            dest[j2++] = s.charAt(i2++);
        }
    }

    @Override
    public final int length() {
        return this.hashLength >= 0 ? this.hashLength : this.array.length;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final char[] array() {
        return this.array;
    }

    public final void getChars(int start, int end, char[] dest, int destStart) {
        if (end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.array, start, dest, destStart, end - start);
    }

    public final MutableString ensureCapacity(int minimumCapacity) {
        int length = this.length();
        this.expand(minimumCapacity);
        if (length < minimumCapacity) {
            this.hashLength = length;
        }
        return this;
    }

    private void expand(int minimumCapacity) {
        int c2;
        int n2 = c2 = this.array == null ? 0 : this.array.length;
        if (minimumCapacity <= c2 && this.array != null) {
            return;
        }
        int length = this.hashLength >= 0 ? this.hashLength : c2;
        char[] newArray = new char[this.hashLength >= 0 && c2 * 2 > minimumCapacity ? c2 * 2 : minimumCapacity];
        if (length != 0) {
            System.arraycopy(this.array, 0, newArray, 0, length);
        }
        this.array = newArray;
    }

    private void setCapacity(int capacity) {
        int c2 = this.array.length;
        if (capacity == c2) {
            return;
        }
        int length = this.hashLength >= 0 ? this.hashLength : c2;
        char[] newArray = capacity != 0 ? new char[capacity] : CharArrays.EMPTY_ARRAY;
        System.arraycopy(this.array, 0, newArray, 0, length < capacity ? length : capacity);
        this.array = newArray;
    }

    public final MutableString length(int newLength) {
        if (newLength < 0) {
            throw new IllegalArgumentException("Negative length (" + newLength + ")");
        }
        if (this.hashLength < 0) {
            if (this.array.length == newLength) {
                return this;
            }
            this.hashLength = -1;
            this.setCapacity(newLength);
        } else {
            int length = this.hashLength;
            if (newLength == length) {
                return this;
            }
            if (newLength > this.array.length) {
                this.expand(newLength);
            } else if (newLength > length) {
                Arrays.fill(this.array, length, newLength, '\u0000');
            }
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString setLength(int newLength) {
        return this.length(newLength);
    }

    public final MutableString compact() {
        if (this.hashLength >= 0) {
            this.setCapacity(this.hashLength);
            this.hashLength = -1;
        }
        return this;
    }

    public final MutableString loose() {
        if (this.hashLength < 0) {
            this.hashLength = this.array.length;
        }
        return this;
    }

    public final boolean isCompact() {
        return this.hashLength < 0;
    }

    public final boolean isLoose() {
        return this.hashLength >= 0;
    }

    public final MutableString changed() {
        if (this.hashLength < 0) {
            this.hashLength = -1;
        }
        return this;
    }

    public static MutableString wrap(char[] a2) {
        MutableString s = new MutableString(0);
        s.array = a2;
        s.hashLength = -1;
        return s;
    }

    public static MutableString wrap(char[] a2, int length) {
        MutableString s = new MutableString(0);
        s.array = a2;
        s.hashLength = length;
        return s;
    }

    @Override
    public final char charAt(int index) {
        if (index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.array[index];
    }

    public final MutableString setCharAt(int index, char c2) {
        this.charAt(index, c2);
        return this;
    }

    public final MutableString charAt(int index, char c2) {
        if (index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.array[index] = c2;
        this.changed();
        return this;
    }

    public final char firstChar() {
        if (this.length() == 0) {
            throw new StringIndexOutOfBoundsException(0);
        }
        return this.array[0];
    }

    public final char lastChar() {
        return this.array[this.length() - 1];
    }

    public final char[] toCharArray() {
        return CharArrays.copy(this.array, 0, this.length());
    }

    public final MutableString substring(int start, int end) {
        if (end > this.length()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        return new MutableString(this.array, start, end - start);
    }

    public final MutableString substring(int start) {
        return this.substring(start, this.length());
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (start > end || end > this.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        return new SubSequence(start, end);
    }

    public final MutableString append(MutableString s) {
        int l2;
        if (s == null) {
            s = NULL;
        }
        if ((l2 = s.length()) == 0) {
            return this;
        }
        int newLength = this.length() + l2;
        this.expand(newLength);
        System.arraycopy(s.array, 0, this.array, newLength - l2, l2);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(String s) {
        if (s == null) {
            return this.append(NULL);
        }
        int l2 = s.length();
        if (l2 == 0) {
            return this;
        }
        int newLength = this.length() + l2;
        this.expand(newLength);
        s.getChars(0, l2, this.array, newLength - l2);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    @Override
    public final MutableString append(CharSequence s) {
        if (s == null) {
            return this.append(NULL);
        }
        int l2 = s.length();
        if (l2 == 0) {
            return this;
        }
        int newLength = this.length() + l2;
        this.expand(newLength);
        MutableString.getChars(s, 0, l2, this.array, newLength - l2);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    @Override
    public final MutableString append(CharSequence s, int start, int end) {
        if (s == null) {
            return this.append(NULL, start, end);
        }
        int len = end - start;
        if (len < 0 || start < 0 || end > s.length()) {
            throw new IndexOutOfBoundsException("start: " + start + " end: " + end + " length():" + s.length());
        }
        int newLength = this.length() + len;
        this.expand(newLength);
        try {
            MutableString.getChars(s, start, end, this.array, newLength - len);
        }
        catch (IndexOutOfBoundsException e2) {
            if (this.hashLength < 0) {
                this.setCapacity(newLength - len);
            } else {
                this.hashLength = newLength - len;
            }
            throw e2;
        }
        if (len != 0) {
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        }
        return this;
    }

    public final MutableString append(CharSequence[] a2, int offset, int length, CharSequence separator) {
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        if (length == 0) {
            return this;
        }
        int m2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            m2 += a2[offset + i2].length();
        }
        int separatorLength = separator.length();
        int l2 = this.length();
        this.ensureCapacity(l2 + (m2 += (length - 1) * separatorLength));
        m2 = 0;
        for (int i3 = 0; i3 < length; ++i3) {
            if (i3 != 0) {
                MutableString.getChars(separator, 0, separatorLength, this.array, l2 + m2);
                m2 += separatorLength;
            }
            MutableString.getChars(a2[i3], 0, a2[i3 + offset].length(), this.array, l2 + m2);
            m2 += a2[i3].length();
        }
        this.hashLength = this.hashLength < 0 ? -1 : l2 + m2;
        return this;
    }

    public final MutableString append(CharSequence[] a2, CharSequence separator) {
        return this.append(a2, 0, a2.length, separator);
    }

    public final MutableString append(Object[] a2, int offset, int length, CharSequence separator) {
        CharSequence[] s = new String[a2.length];
        for (int i2 = 0; i2 < length; ++i2) {
            s[i2] = a2[offset + i2].toString();
        }
        return this.append(s, offset, length, separator);
    }

    public final MutableString append(Object[] a2, CharSequence separator) {
        return this.append(a2, 0, a2.length, separator);
    }

    public final MutableString append(char[] a2) {
        int l2 = a2.length;
        if (l2 == 0) {
            return this;
        }
        int newLength = this.length() + l2;
        this.expand(newLength);
        System.arraycopy(a2, 0, this.array, newLength - l2, l2);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(char[] a2, int offset, int len) {
        int newLength = this.length() + len;
        this.expand(newLength);
        try {
            System.arraycopy(a2, offset, this.array, newLength - len, len);
        }
        catch (IndexOutOfBoundsException e2) {
            if (this.hashLength < 0) {
                this.setCapacity(newLength - len);
            } else {
                this.hashLength = newLength - len;
            }
            throw e2;
        }
        if (len != 0) {
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        }
        return this;
    }

    public final MutableString append(CharList list) {
        int l2 = list.size();
        if (l2 == 0) {
            return this;
        }
        int newLength = this.length() + l2;
        this.expand(newLength);
        list.getElements(0, this.array, newLength - l2, l2);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(CharList list, int offset, int len) {
        int newLength = this.length() + len;
        this.expand(newLength);
        try {
            list.getElements(offset, this.array, newLength - len, len);
        }
        catch (IndexOutOfBoundsException e2) {
            if (this.hashLength < 0) {
                this.setCapacity(newLength - len);
            } else {
                this.hashLength = newLength - len;
            }
            throw e2;
        }
        if (len != 0) {
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        }
        return this;
    }

    public final MutableString append(boolean b2) {
        return this.append(String.valueOf(b2));
    }

    @Override
    public final MutableString append(char c2) {
        int newLength = this.length() + 1;
        this.expand(newLength);
        this.array[newLength - 1] = c2;
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(int i2) {
        return this.append(String.valueOf(i2));
    }

    public final MutableString append(long l2) {
        return this.append(String.valueOf(l2));
    }

    public final MutableString append(float f2) {
        return this.append(String.valueOf(f2));
    }

    public final MutableString append(double d2) {
        return this.append(String.valueOf(d2));
    }

    public final MutableString append(Object o2) {
        return this.append(String.valueOf(o2));
    }

    public final MutableString insert(int index, MutableString s) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = s.length();
        if (l2 == 0) {
            return this;
        }
        int newLength = length + l2;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + l2, length - index);
        System.arraycopy(s.array, 0, this.array, index, l2);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, String s) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = s.length();
        if (l2 == 0) {
            return this;
        }
        int newLength = length + l2;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + l2, length - index);
        s.getChars(0, l2, this.array, index);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, CharSequence s) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = s.length();
        if (l2 == 0) {
            return this;
        }
        int newLength = length + l2;
        if (newLength >= this.array.length) {
            this.expand(newLength);
        }
        System.arraycopy(this.array, index, this.array, index + l2, length - index);
        MutableString.getChars(s, 0, l2, this.array, index);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, char[] c2) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = c2.length;
        if (l2 == 0) {
            return this;
        }
        int newLength = length + l2;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + l2, length - index);
        System.arraycopy(c2, 0, this.array, index, l2);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, char[] c2, int offset, int len) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset < 0 || offset + len < 0 || offset + len > c2.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len == 0) {
            return this;
        }
        int newLength = length + len;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + len, length - index);
        System.arraycopy(c2, offset, this.array, index, len);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, boolean b2) {
        return this.insert(index, String.valueOf(b2));
    }

    public final MutableString insert(int index, char c2) {
        return this.insert(index, String.valueOf(c2));
    }

    public final MutableString insert(int index, double d2) {
        return this.insert(index, String.valueOf(d2));
    }

    public final MutableString insert(int index, float f2) {
        return this.insert(index, String.valueOf(f2));
    }

    public final MutableString insert(int index, int x) {
        return this.insert(index, String.valueOf(x));
    }

    public final MutableString insert(int index, long l2) {
        return this.insert(index, String.valueOf(l2));
    }

    public final MutableString insert(int index, Object o2) {
        return this.insert(index, String.valueOf(o2));
    }

    public final MutableString delete(int start, int end) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = end - start;
        if (l2 > 0) {
            System.arraycopy(this.array, start + l2, this.array, start, length - end);
            if (this.hashLength < 0) {
                this.setCapacity(length - l2);
                this.hashLength = -1;
            } else {
                this.hashLength -= l2;
            }
        }
        return this;
    }

    public final MutableString deleteCharAt(int index) {
        int length = this.length();
        if (index >= length) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.array, index + 1, this.array, index, length - index - 1);
        if (this.hashLength < 0) {
            this.setCapacity(length - 1);
            this.hashLength = -1;
        } else {
            --this.hashLength;
        }
        return this;
    }

    public final MutableString delete(char c2) {
        int length = this.length();
        char[] a2 = this.array;
        int l2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (a2[i2] == c2) continue;
            a2[l2++] = a2[i2];
        }
        if (l2 != length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.trim(this.array, l2);
            } else {
                this.hashLength = l2;
            }
        }
        return this;
    }

    public final MutableString delete(CharSet s) {
        int length = this.length();
        char[] a2 = this.array;
        int l2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (s.contains(a2[i2])) continue;
            a2[l2++] = a2[i2];
        }
        if (l2 != length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.trim(this.array, l2);
            } else {
                this.hashLength = l2;
            }
        }
        return this;
    }

    public final MutableString delete(char[] c2) {
        int length;
        int n2 = c2.length;
        if (n2 == 0) {
            return this;
        }
        char[] a2 = this.array;
        int i2 = length = this.length();
        int bloomFilter = 0;
        int k2 = n2;
        while (k2-- != 0) {
            bloomFilter |= 1 << (c2[k2] & 0x1F);
        }
        int l2 = 0;
        for (i2 = 0; i2 < length; ++i2) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) != 0) {
                k2 = n2;
                while (k2-- != 0 && a2[i2] != c2[k2]) {
                }
                if (k2 >= 0) continue;
            }
            a2[l2++] = a2[i2];
        }
        if (l2 != length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.trim(this.array, l2);
            } else {
                this.hashLength = l2;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, MutableString s) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = s.length();
        int newLength = length + l2 - end + start;
        if (l2 == 0 && newLength == length) {
            return this;
        }
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + l2, length - end);
            System.arraycopy(s.array, 0, this.array, start, l2);
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + l2, length - end);
            System.arraycopy(s.array, 0, this.array, start, l2);
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, String s) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = s.length();
        int newLength = length + l2 - end + start;
        if (l2 == 0 && newLength == length) {
            return this;
        }
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + l2, length - end);
            s.getChars(0, l2, this.array, start);
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + l2, length - end);
            s.getChars(0, l2, this.array, start);
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, CharSequence s) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l2 = s.length();
        int newLength = length + l2 - end + start;
        if (l2 == 0 && newLength == length) {
            return this;
        }
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + l2, length - end);
            MutableString.getChars(s, 0, l2, this.array, start);
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + l2, length - end);
            MutableString.getChars(s, 0, l2, this.array, start);
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, char c2) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int newLength = length + 1 - end + start;
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + 1, length - end);
            this.array[start] = c2;
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + 1, length - end);
            this.array[start] = c2;
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(MutableString s) {
        return this.replace(0, Integer.MAX_VALUE, s);
    }

    public final MutableString replace(String s) {
        return this.replace(0, Integer.MAX_VALUE, s);
    }

    public final MutableString replace(CharSequence s) {
        return this.replace(0, Integer.MAX_VALUE, s);
    }

    public final MutableString replace(char c2) {
        return this.replace(0, Integer.MAX_VALUE, c2);
    }

    public final MutableString replace(char[] c2, MutableString[] s) {
        int n2 = c2.length;
        if (n2 == 0) {
            return this;
        }
        int length = this.length();
        char[] a2 = this.array;
        int newLength = length;
        int bloomFilter = 0;
        int k2 = n2;
        while (k2-- != 0) {
            bloomFilter |= 1 << (c2[k2] & 0x1F);
            if (s[k2].length() != 0) continue;
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i2 = length;
        boolean found = false;
        while (i2-- != 0) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) == 0) continue;
            k2 = n2;
            while (k2-- != 0 && a2[i2] != c2[k2]) {
            }
            if (k2 < 0) continue;
            newLength += s[k2].length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a2 = this.array;
        i2 = newLength;
        int j2 = length;
        while (j2-- != 0) {
            if ((bloomFilter & 1 << (a2[j2] & 0x1F)) != 0) {
                k2 = n2;
                while (k2-- != 0 && a2[j2] != c2[k2]) {
                }
                if (k2 >= 0) {
                    int l2 = s[k2].length();
                    System.arraycopy(s[k2].array, 0, this.array, i2 -= l2, l2);
                    continue;
                }
            }
            a2[--i2] = a2[j2];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char[] c2, String[] s) {
        int n2 = c2.length;
        if (n2 == 0) {
            return this;
        }
        int length = this.length();
        char[] a2 = this.array;
        int newLength = length;
        int bloomFilter = 0;
        int k2 = n2;
        while (k2-- != 0) {
            bloomFilter |= 1 << (c2[k2] & 0x1F);
            if (s[k2].length() != 0) continue;
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i2 = length;
        boolean found = false;
        while (i2-- != 0) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) == 0) continue;
            k2 = n2;
            while (k2-- != 0 && a2[i2] != c2[k2]) {
            }
            if (k2 < 0) continue;
            newLength += s[k2].length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a2 = this.array;
        i2 = newLength;
        int j2 = length;
        while (j2-- != 0) {
            if ((bloomFilter & 1 << (a2[j2] & 0x1F)) != 0) {
                k2 = n2;
                while (k2-- != 0 && a2[j2] != c2[k2]) {
                }
                if (k2 >= 0) {
                    int l2 = s[k2].length();
                    MutableString.getChars(s[k2], 0, l2, this.array, i2 -= l2);
                    continue;
                }
            }
            a2[--i2] = a2[j2];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char[] c2, CharSequence[] s) {
        int n2 = c2.length;
        if (n2 == 0) {
            return this;
        }
        int length = this.length();
        char[] a2 = this.array;
        int newLength = length;
        int bloomFilter = 0;
        int k2 = n2;
        while (k2-- != 0) {
            bloomFilter |= 1 << (c2[k2] & 0x1F);
            if (s[k2].length() != 0) continue;
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i2 = length;
        boolean found = false;
        while (i2-- != 0) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) == 0) continue;
            k2 = n2;
            while (k2-- != 0 && a2[i2] != c2[k2]) {
            }
            if (k2 < 0) continue;
            newLength += s[k2].length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a2 = this.array;
        i2 = newLength;
        int j2 = length;
        while (j2-- != 0) {
            if ((bloomFilter & 1 << (a2[j2] & 0x1F)) != 0) {
                k2 = n2;
                while (k2-- != 0 && a2[j2] != c2[k2]) {
                }
                if (k2 >= 0) {
                    int l2 = s[k2].length();
                    MutableString.getChars(s[k2], 0, l2, this.array, i2 -= l2);
                    continue;
                }
            }
            a2[--i2] = a2[j2];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char[] c2, char[] r) {
        int n2 = c2.length;
        if (n2 == 0) {
            return this;
        }
        char[] a2 = this.array;
        int i2 = this.length();
        int bloomFilter = 0;
        int k2 = n2;
        while (k2-- != 0) {
            bloomFilter |= 1 << (c2[k2] & 0x1F);
        }
        while (i2-- != 0) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) == 0) continue;
            k2 = n2;
            while (k2-- != 0 && a2[i2] != c2[k2]) {
            }
            if (k2 < 0) continue;
            a2[i2] = r[k2];
        }
        if (this.hashLength < 0) {
            this.hashLength = -1;
        }
        return this;
    }

    public final MutableString replace(Char2CharMap m2) {
        int length = this.length();
        char[] a2 = this.array;
        boolean found = false;
        for (int i2 = 0; i2 < length; ++i2) {
            if (!m2.containsKey(a2[i2])) continue;
            a2[i2] = m2.get(a2[i2]);
            found = true;
        }
        if (found && this.hashLength < 0) {
            this.hashLength = -1;
        }
        return this;
    }

    public final MutableString replace(char c2, MutableString s) {
        int length = this.length();
        char[] a2 = this.array;
        int newLength = length;
        if (s.length() == 0) {
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i2 = length;
        boolean found = false;
        while (i2-- != 0) {
            if (a2[i2] != c2) continue;
            newLength += s.length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a2 = this.array;
        i2 = newLength;
        int j2 = length;
        while (j2-- != 0) {
            if (a2[j2] == c2) {
                int l2 = s.length();
                System.arraycopy(s.array, 0, a2, i2 -= l2, l2);
                continue;
            }
            a2[--i2] = a2[j2];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char c2, String s) {
        int length = this.length();
        char[] a2 = this.array;
        int newLength = length;
        if (s.length() == 0) {
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i2 = length;
        boolean found = false;
        while (i2-- != 0) {
            if (a2[i2] != c2) continue;
            newLength += s.length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a2 = this.array;
        i2 = newLength;
        int j2 = length;
        while (j2-- != 0) {
            if (a2[j2] == c2) {
                int l2 = s.length();
                s.getChars(0, l2, this.array, i2 -= l2);
                continue;
            }
            a2[--i2] = a2[j2];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char c2, CharSequence s) {
        int length = this.length();
        char[] a2 = this.array;
        int newLength = length;
        if (s.length() == 0) {
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i2 = length;
        boolean found = false;
        while (i2-- != 0) {
            if (a2[i2] != c2) continue;
            newLength += s.length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a2 = this.array;
        i2 = newLength;
        int j2 = length;
        while (j2-- != 0) {
            if (a2[j2] == c2) {
                int l2 = s.length();
                MutableString.getChars(s, 0, l2, this.array, i2 -= l2);
                continue;
            }
            a2[--i2] = a2[j2];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char c2, char r) {
        int i2 = this.length();
        char[] a2 = this.array;
        while (i2-- != 0) {
            if (a2[i2] != c2) continue;
            a2[i2] = r;
        }
        this.changed();
        return this;
    }

    public final MutableString replace(MutableString s, MutableString r) {
        int length = this.length();
        int ns = s.length();
        int nr = r.length();
        if (ns == 0) {
            if (nr == 0) {
                return this;
            }
            throw new IllegalArgumentException("You cannot replace the empty string with a nonempty string");
        }
        char[] ar = r.array;
        char[] as = s.array;
        int bloomFilter = MutableString.buildFilter(s, ns);
        int diff = ns - nr;
        if (diff >= 0) {
            char[] a2 = this.array;
            int i2 = this.indexOf(as, ns, 0, bloomFilter);
            if (i2 != -1) {
                System.arraycopy(ar, 0, a2, i2, nr);
                int j2 = i2 + nr;
                int l2 = diff;
                while ((i2 = this.indexOf(as, ns, i2 + ns, bloomFilter)) != -1) {
                    if (diff != 0) {
                        System.arraycopy(a2, j2 + l2, a2, j2, i2 - j2 - l2);
                    }
                    j2 = i2 + ns - (l2 += diff);
                    System.arraycopy(ar, 0, a2, j2 - nr, nr);
                }
                if (diff != 0) {
                    System.arraycopy(a2, j2 + l2, a2, j2, length - l2 - j2);
                }
                l2 = length - l2;
                if (this.hashLength < 0) {
                    this.hashLength = -1;
                    if (diff != 0) {
                        char[] newArray = new char[l2];
                        System.arraycopy(a2, 0, newArray, 0, l2);
                        this.array = newArray;
                    }
                } else {
                    this.hashLength = l2;
                }
            }
        } else {
            int j3 = 0;
            int i3 = length;
            while ((i3 = this.lastIndexOf(as, ns, i3 - ns, bloomFilter)) != -1) {
                ++j3;
            }
            if (j3 != 0) {
                int l3;
                int m2 = l3 = length + j3 * -diff;
                this.expand(m2);
                char[] a3 = this.array;
                i3 = j3 = length;
                while ((i3 = this.lastIndexOf(as, ns, i3 - ns, bloomFilter)) != -1) {
                    System.arraycopy(a3, i3 + ns, a3, l3 -= j3 - i3 - ns, j3 - i3 - ns);
                    System.arraycopy(ar, 0, a3, l3 -= nr, nr);
                    j3 = i3;
                }
                this.hashLength = this.hashLength < 0 ? -1 : m2;
            }
        }
        return this;
    }

    public final MutableString replace(String s, String r) {
        int length = this.length();
        int ns = s.length();
        int nr = r.length();
        if (ns == 0) {
            if (nr == 0) {
                return this;
            }
            throw new IllegalArgumentException("You cannot replace the empty string with a nonempty string");
        }
        int bloomFilter = MutableString.buildFilter(s, ns);
        int diff = ns - nr;
        if (diff >= 0) {
            char[] a2 = this.array;
            int i2 = this.indexOf(s, ns, 0, bloomFilter);
            if (i2 != -1) {
                r.getChars(0, nr, a2, i2);
                int j2 = i2 + nr;
                int l2 = diff;
                while ((i2 = this.indexOf(s, ns, i2 + ns, bloomFilter)) != -1) {
                    if (diff != 0) {
                        System.arraycopy(a2, j2 + l2, a2, j2, i2 - j2 - l2);
                    }
                    j2 = i2 + ns - (l2 += diff);
                    r.getChars(0, nr, a2, j2 - nr);
                }
                if (diff != 0) {
                    System.arraycopy(a2, j2 + l2, a2, j2, length - l2 - j2);
                }
                l2 = length - l2;
                if (this.hashLength < 0) {
                    this.hashLength = -1;
                    if (diff != 0) {
                        char[] newArray = new char[l2];
                        System.arraycopy(a2, 0, newArray, 0, l2);
                        this.array = newArray;
                    }
                } else {
                    this.hashLength = l2;
                }
            }
        } else {
            int j3 = 0;
            int i3 = length;
            while ((i3 = this.lastIndexOf(s, ns, i3 - ns, bloomFilter)) != -1) {
                ++j3;
            }
            if (j3 != 0) {
                int l3;
                int m2 = l3 = length + j3 * -diff;
                this.expand(m2);
                char[] a3 = this.array;
                i3 = j3 = length;
                while ((i3 = this.lastIndexOf(s, ns, i3 - ns, bloomFilter)) != -1) {
                    System.arraycopy(a3, i3 + ns, a3, l3 -= j3 - i3 - ns, j3 - i3 - ns);
                    r.getChars(0, nr, a3, l3 -= nr);
                    j3 = i3;
                }
                this.hashLength = this.hashLength < 0 ? -1 : m2;
            }
        }
        return this;
    }

    public final MutableString replace(CharSequence s, CharSequence r) {
        int length = this.length();
        int ns = s.length();
        int nr = r.length();
        if (ns == 0) {
            if (nr == 0) {
                return this;
            }
            throw new IllegalArgumentException("You cannot replace the empty string with a nonempty string");
        }
        int bloomFilter = MutableString.buildFilter(s, ns);
        int diff = ns - nr;
        if (diff >= 0) {
            char[] a2 = this.array;
            int i2 = this.indexOf(s, ns, 0, bloomFilter);
            if (i2 != -1) {
                MutableString.getChars(r, 0, nr, a2, i2);
                int j2 = i2 + nr;
                int l2 = diff;
                while ((i2 = this.indexOf(s, ns, i2 + ns, bloomFilter)) != -1) {
                    if (diff != 0) {
                        System.arraycopy(a2, j2 + l2, a2, j2, i2 - j2 - l2);
                    }
                    j2 = i2 + ns - (l2 += diff);
                    MutableString.getChars(r, 0, nr, a2, j2 - nr);
                }
                if (diff != 0) {
                    System.arraycopy(a2, j2 + l2, a2, j2, length - l2 - j2);
                }
                l2 = length - l2;
                if (this.hashLength < 0) {
                    this.hashLength = -1;
                    if (diff != 0) {
                        char[] newArray = new char[l2];
                        System.arraycopy(a2, 0, newArray, 0, l2);
                        this.array = newArray;
                    }
                } else {
                    this.hashLength = l2;
                }
            }
        } else {
            int j3 = 0;
            int i3 = length;
            while ((i3 = this.lastIndexOf(s, ns, i3 - ns, bloomFilter)) != -1) {
                ++j3;
            }
            if (j3 != 0) {
                int l3;
                int m2 = l3 = length + j3 * -diff;
                this.expand(m2);
                char[] a3 = this.array;
                i3 = j3 = length;
                while ((i3 = this.lastIndexOf(s, ns, i3 - ns, bloomFilter)) != -1) {
                    System.arraycopy(a3, i3 + ns, a3, l3 -= j3 - i3 - ns, j3 - i3 - ns);
                    MutableString.getChars(r, 0, nr, a3, l3 -= nr);
                    j3 = i3;
                }
                this.hashLength = this.hashLength < 0 ? -1 : m2;
            }
        }
        return this;
    }

    public final int indexOf(char c2) {
        return this.indexOf(c2, 0);
    }

    public final int indexOf(char c2, int from) {
        int i2;
        int length = this.length();
        char[] a2 = this.array;
        int n2 = i2 = from < 0 ? -1 : from - 1;
        while (++i2 < length) {
            if (a2[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    private static int buildFilter(char[] s, int n2) {
        int i2 = n2;
        int bloomFilter = 0;
        while (i2-- != 0) {
            bloomFilter |= 1 << (s[i2] & 0x1F);
        }
        return bloomFilter;
    }

    private int indexOf(char[] pattern, int n2, int from, int bloomFilter) {
        int j2;
        int m1 = this.length() - 1;
        char[] a2 = this.array;
        char[] p2 = pattern;
        char last = p2[n2 - 1];
        int i2 = (from < 0 ? 0 : from) + n2 - 1;
        while (i2 < m1) {
            if (a2[i2] == last) {
                j2 = n2 - 1;
                int k2 = i2;
                while (j2-- != 0 && a2[--k2] == p2[j2]) {
                }
                if (j2 < 0) {
                    return k2;
                }
            }
            if ((bloomFilter & 1 << (a2[++i2] & 0x1F)) != 0) continue;
            i2 += n2;
        }
        if (i2 == m1) {
            j2 = n2;
            while (j2-- != 0) {
                if (a2[i2--] == p2[j2]) continue;
                return -1;
            }
            return i2 + 1;
        }
        return -1;
    }

    public final int indexOf(MutableString pattern, int from) {
        int n2 = pattern.length();
        if (n2 == 0) {
            return from > this.length() ? this.length() : (from < 0 ? 0 : from);
        }
        if (n2 == 1) {
            return this.indexOf(pattern.array[n2 - 1], from);
        }
        return this.indexOf(pattern.array, n2, from, MutableString.buildFilter(pattern.array, n2));
    }

    public final int indexOf(MutableString pattern) {
        return this.indexOf(pattern, 0);
    }

    private static int buildFilter(CharSequence s, int n2) {
        int i2 = n2;
        int bloomFilter = 0;
        while (i2-- != 0) {
            bloomFilter |= 1 << (s.charAt(i2) & 0x1F);
        }
        return bloomFilter;
    }

    private int indexOf(CharSequence pattern, int n2, int from, int bloomFilter) {
        int j2;
        int m1 = this.length() - 1;
        char[] a2 = this.array;
        char last = pattern.charAt(n2 - 1);
        int i2 = (from < 0 ? 0 : from) + n2 - 1;
        while (i2 < m1) {
            if (a2[i2] == last) {
                j2 = n2 - 1;
                int k2 = i2;
                while (j2-- != 0 && a2[--k2] == pattern.charAt(j2)) {
                }
                if (j2 < 0) {
                    return k2;
                }
            }
            if ((bloomFilter & 1 << (a2[++i2] & 0x1F)) != 0) continue;
            i2 += n2;
        }
        if (i2 == m1) {
            j2 = n2;
            while (j2-- != 0) {
                if (a2[i2--] == pattern.charAt(j2)) continue;
                return -1;
            }
            return i2 + 1;
        }
        return -1;
    }

    public final int indexOf(CharSequence pattern, int from) {
        int n2 = pattern.length();
        if (n2 == 0) {
            return from > this.length() ? this.length() : (from < 0 ? 0 : from);
        }
        if (n2 == 1) {
            return this.indexOf(pattern.charAt(n2 - 1), from);
        }
        return this.indexOf(pattern, n2, from, MutableString.buildFilter(pattern, n2));
    }

    public final int indexOf(CharSequence pattern) {
        return this.indexOf(pattern, 0);
    }

    public int indexOf(TextPattern pattern, int from) {
        return pattern.search(this.array(), from);
    }

    public int indexOf(TextPattern pattern) {
        return this.indexOf(pattern, 0);
    }

    public int indexOfAnyOf(CharSet s, int from) {
        int n2 = s.size();
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return this.indexOf(s.iterator().nextChar(), from);
        }
        char[] a2 = this.array;
        int length = this.length();
        int i2 = (from < 0 ? 0 : from) - 1;
        while (++i2 < length) {
            if (!s.contains(a2[i2])) continue;
            return i2;
        }
        return -1;
    }

    public int indexOfAnyOf(CharSet s) {
        return this.indexOfAnyOf(s, 0);
    }

    private int indexOfAnyOf(char[] c2, int n2, int from, int bloomFilter) {
        int m2 = this.length();
        if (n2 == 0) {
            return -1;
        }
        char[] a2 = this.array;
        int i2 = (from < 0 ? 0 : from) - 1;
        while (++i2 < m2) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) == 0) continue;
            int k2 = n2;
            while (k2-- != 0) {
                if (a2[i2] != c2[k2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public int indexOfAnyOf(char[] c2, int from) {
        int n2 = c2.length;
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return this.indexOf(c2[0], from);
        }
        return this.indexOfAnyOf(c2, n2, from, MutableString.buildFilter(c2, n2));
    }

    public int indexOfAnyOf(char[] c2) {
        return this.indexOfAnyOf(c2, 0);
    }

    public int indexOfAnyBut(CharSet s, int from) {
        char[] a2 = this.array;
        int length = this.length();
        int i2 = (from < 0 ? 0 : from) - 1;
        while (++i2 < length) {
            if (s.contains(a2[i2])) continue;
            return i2;
        }
        return -1;
    }

    public int indexOfAnyBut(CharSet s) {
        return this.indexOfAnyOf(s, 0);
    }

    private int indexOfAnyBut(char[] c2, int n2, int from, int bloomFilter) {
        int m2 = this.length();
        if (n2 == 0) {
            return from < m2 ? from : -1;
        }
        char[] a2 = this.array;
        int i2 = (from < 0 ? 0 : from) - 1;
        while (++i2 < m2) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) != 0) {
                int k2 = n2;
                while (k2-- != 0 && a2[i2] != c2[k2]) {
                }
                if (k2 != -1) continue;
                return i2;
            }
            return i2;
        }
        return -1;
    }

    public int indexOfAnyBut(char[] c2, int from) {
        int n2 = c2.length;
        return this.indexOfAnyBut(c2, n2, from < 0 ? 0 : from, MutableString.buildFilter(c2, n2));
    }

    public int indexOfAnyBut(char[] c2) {
        return this.indexOfAnyOf(c2, 0);
    }

    public final int lastIndexOf(char c2) {
        char[] a2 = this.array;
        int i2 = this.length();
        while (i2-- != 0) {
            if (a2[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public final int lastIndexOf(char c2, int from) {
        char[] a2 = this.array;
        if (from < 0) {
            return -1;
        }
        int i2 = this.length();
        if (from < i2) {
            i2 = from + 1;
        }
        if (i2 < 0) {
            return -1;
        }
        while (i2-- != 0) {
            if (a2[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    private int lastIndexOf(char[] pattern, int n2, int from, int bloomFilter) {
        int j2;
        char[] a2 = this.array;
        char[] p2 = pattern;
        char first = p2[0];
        int i2 = this.length() - n2;
        if (from < i2) {
            i2 = from;
        }
        while (i2 > 0) {
            if (a2[i2] == first) {
                j2 = n2 - 1;
                int k2 = 0;
                while (j2-- != 0 && a2[++i2] == p2[++k2]) {
                }
                if (j2 < 0) {
                    return i2 - k2;
                }
                i2 -= k2;
            }
            if ((bloomFilter & 1 << (a2[--i2] & 0x1F)) != 0) continue;
            i2 -= n2;
        }
        if (i2 == 0) {
            j2 = n2;
            while (j2-- != 0) {
                if (a2[j2] == p2[j2]) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public final int lastIndexOf(MutableString pattern, int from) {
        int n2 = pattern.length();
        if (from < 0) {
            return -1;
        }
        if (n2 == 0) {
            return from > this.length() ? this.length() : from;
        }
        if (n2 == 1) {
            return this.lastIndexOf(pattern.array[0], from);
        }
        return this.lastIndexOf(pattern.array, n2, from, MutableString.buildFilter(pattern.array, n2));
    }

    public final int lastIndexOf(MutableString pattern) {
        return this.lastIndexOf(pattern, this.length());
    }

    private int lastIndexOf(CharSequence pattern, int n2, int from, int bloomFilter) {
        int j2;
        char[] a2 = this.array;
        char first = pattern.charAt(0);
        int i2 = this.length() - n2;
        if (from < i2) {
            i2 = from;
        }
        while (i2 > 0) {
            if (a2[i2] == first) {
                j2 = n2 - 1;
                int k2 = 0;
                while (j2-- != 0 && a2[++i2] == pattern.charAt(++k2)) {
                }
                if (j2 < 0) {
                    return i2 - k2;
                }
                i2 -= k2;
            }
            if ((bloomFilter & 1 << (a2[--i2] & 0x1F)) != 0) continue;
            i2 -= n2;
        }
        if (i2 == 0) {
            j2 = n2;
            while (j2-- != 0) {
                if (a2[j2] == pattern.charAt(j2)) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public final int lastIndexOf(CharSequence pattern, int from) {
        int n2 = pattern.length();
        if (from < 0) {
            return -1;
        }
        if (n2 == 0) {
            return from > this.length() ? this.length() : from;
        }
        if (n2 == 1) {
            return this.lastIndexOf(pattern.charAt(0), from);
        }
        return this.lastIndexOf(pattern, n2, from, MutableString.buildFilter(pattern, n2));
    }

    public final int lastIndexOf(CharSequence pattern) {
        return this.lastIndexOf(pattern, this.length());
    }

    public int lastIndexOfAnyOf(CharSet s, int from) {
        if (from < 0) {
            return -1;
        }
        int n2 = s.size();
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return this.lastIndexOf(s.iterator().nextChar(), from);
        }
        char[] a2 = this.array;
        int i2 = this.length();
        if (from < i2) {
            i2 = from + 1;
        }
        while (i2-- > 0) {
            if (!s.contains(a2[i2])) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOfAnyOf(CharSet s) {
        return this.lastIndexOfAnyOf(s, this.length());
    }

    private int lastIndexOfAnyOf(char[] c2, int n2, int from, int bloomFilter) {
        if (n2 == 0) {
            return -1;
        }
        char[] a2 = this.array;
        int i2 = this.length();
        if (from < i2) {
            i2 = from + 1;
        }
        while (i2-- > 0) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) == 0) continue;
            int k2 = n2;
            while (k2-- != 0) {
                if (a2[i2] != c2[k2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public int lastIndexOfAnyOf(char[] c2, int from) {
        int n2 = c2.length;
        if (from < 0) {
            return -1;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return this.lastIndexOf(c2[0], from);
        }
        return this.lastIndexOfAnyOf(c2, n2, from, MutableString.buildFilter(c2, n2));
    }

    public int lastIndexOfAnyOf(char[] c2) {
        return this.lastIndexOfAnyOf(c2, this.length());
    }

    public int lastIndexOfAnyBut(CharSet s, int from) {
        if (from < 0) {
            return -1;
        }
        char[] a2 = this.array;
        int i2 = this.length();
        if (s.size() == 0) {
            return from < i2 ? from : i2 - 1;
        }
        if (from < i2) {
            i2 = from + 1;
        }
        while (i2-- > 0) {
            if (s.contains(a2[i2])) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOfAnyBut(CharSet s) {
        return this.lastIndexOfAnyBut(s, this.length());
    }

    private int lastIndexOfAnyBut(char[] c2, int n2, int from, int bloomFilter) {
        char[] a2 = this.array;
        int i2 = this.length();
        if (i2 == 0) {
            return -1;
        }
        if (n2 == 0) {
            return from < i2 ? from : i2 - 1;
        }
        if (from < i2) {
            i2 = from + 1;
        }
        while (i2-- != 0) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) != 0) {
                int k2 = n2;
                while (k2-- != 0 && a2[i2] != c2[k2]) {
                }
                if (k2 != -1) continue;
                return i2;
            }
            return i2;
        }
        return -1;
    }

    public int lastIndexOfAnyBut(char[] c2, int from) {
        if (from < 0) {
            return -1;
        }
        int n2 = c2.length;
        return this.lastIndexOfAnyBut(c2, n2, from, MutableString.buildFilter(c2, n2));
    }

    public int lastIndexOfAnyBut(char[] c2) {
        return this.lastIndexOfAnyBut(c2, 0);
    }

    public int span(CharSet s, int from) {
        int length = this.length();
        if (s.size() == 0) {
            return 0;
        }
        char[] a2 = this.array;
        if (from < 0) {
            from = 0;
        }
        int i2 = from - 1;
        while (++i2 < length && s.contains(a2[i2])) {
        }
        return i2 - from;
    }

    public int span(CharSet s) {
        return this.span(s, 0);
    }

    public int span(char[] c2, int from) {
        int length = this.length();
        int n2 = c2.length;
        if (n2 == 0) {
            return 0;
        }
        int bloomFilter = MutableString.buildFilter(c2, n2);
        char[] a2 = this.array;
        if (from < 0) {
            from = 0;
        }
        int i2 = from - 1;
        while (++i2 < length) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) != 0) {
                int k2 = n2;
                while (k2-- != 0 && a2[i2] != c2[k2]) {
                }
                if (k2 != -1) continue;
                return i2 - from;
            }
            return i2 - from;
        }
        return i2 - from;
    }

    public int span(char[] c2) {
        return this.span(c2, 0);
    }

    public int cospan(CharSet s, int from) {
        int length = this.length();
        if (s.size() == 0) {
            return from < 0 ? length : (from < length ? length - from : 0);
        }
        char[] a2 = this.array;
        if (from < 0) {
            from = 0;
        }
        int i2 = from - 1;
        while (++i2 < length && !s.contains(a2[i2])) {
        }
        return i2 - from;
    }

    public int cospan(CharSet s) {
        return this.cospan(s, 0);
    }

    public int cospan(char[] c2, int from) {
        int length = this.length();
        int n2 = c2.length;
        if (n2 == 0) {
            return from < 0 ? length : (from < length ? length - from : 0);
        }
        int bloomFilter = MutableString.buildFilter(c2, n2);
        char[] a2 = this.array;
        if (from < 0) {
            from = 0;
        }
        int i2 = from - 1;
        while (++i2 < length) {
            if ((bloomFilter & 1 << (a2[i2] & 0x1F)) == 0) continue;
            int k2 = n2;
            while (k2-- != 0 && a2[i2] != c2[k2]) {
            }
            if (k2 == -1) continue;
            return i2 - from;
        }
        return i2 - from;
    }

    public int cospan(char[] c2) {
        return this.cospan(c2, 0);
    }

    public final boolean startsWith(MutableString prefix) {
        int l2 = prefix.length();
        if (l2 > this.length()) {
            return false;
        }
        int i2 = l2;
        char[] a1 = prefix.array;
        char[] a2 = this.array;
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWith(String prefix) {
        int l2 = prefix.length();
        if (l2 > this.length()) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            if (prefix.charAt(i2) == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWith(CharSequence prefix) {
        int l2 = prefix.length();
        if (l2 > this.length()) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            if (prefix.charAt(i2) == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWithIgnoreCase(MutableString prefix) {
        int l2 = prefix.length();
        if (l2 > this.length()) {
            return false;
        }
        int i2 = l2;
        char[] a1 = prefix.array;
        char[] a2 = this.array;
        while (i2-- != 0) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(a1[i2]));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(a2[i2])))) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWithIgnoreCase(String prefix) {
        int l2 = prefix.length();
        if (l2 > this.length()) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(a2[i2]));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(prefix.charAt(i2))))) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWithIgnoreCase(CharSequence prefix) {
        int l2 = prefix.length();
        if (l2 > this.length()) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(a2[i2]));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(prefix.charAt(i2))))) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(MutableString suffix) {
        int length;
        int l2 = suffix.length();
        if (l2 > (length = this.length())) {
            return false;
        }
        int i2 = l2;
        char[] a1 = suffix.array;
        char[] a2 = this.array;
        while (i2-- != 0) {
            if (a1[i2] == a2[--length]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(String suffix) {
        int length;
        int l2 = suffix.length();
        if (l2 > (length = this.length())) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            if (suffix.charAt(i2) == a2[--length]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(CharSequence suffix) {
        int length;
        int l2 = suffix.length();
        if (l2 > (length = this.length())) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            if (suffix.charAt(i2) == a2[--length]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWithIgnoreCase(MutableString suffix) {
        int length;
        int l2 = suffix.length();
        if (l2 > (length = this.length())) {
            return false;
        }
        int i2 = l2;
        char[] a1 = suffix.array;
        char[] a2 = this.array;
        while (i2-- != 0) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(a1[i2]));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(a2[--length])))) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWithIgnoreCase(String suffix) {
        int length;
        int l2 = suffix.length();
        if (l2 > (length = this.length())) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(suffix.charAt(i2)));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(a2[--length])))) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWithIgnoreCase(CharSequence suffix) {
        int length;
        int l2 = suffix.length();
        if (l2 > (length = this.length())) {
            return false;
        }
        int i2 = l2;
        char[] a2 = this.array;
        while (i2-- != 0) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(suffix.charAt(i2)));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(a2[--length])))) continue;
            return false;
        }
        return true;
    }

    public final MutableString toLowerCase() {
        int n2 = this.length();
        char[] a2 = this.array;
        while (n2-- != 0) {
            a2[n2] = Character.toLowerCase(a2[n2]);
        }
        this.changed();
        return this;
    }

    public final MutableString toUpperCase() {
        int n2 = this.length();
        char[] a2 = this.array;
        while (n2-- != 0) {
            a2[n2] = Character.toUpperCase(a2[n2]);
        }
        this.changed();
        return this;
    }

    public final MutableString trim() {
        int i2;
        int length = this.length();
        char[] a2 = this.array;
        if (length == 0) {
            return this;
        }
        for (i2 = 0; i2 < length && a2[i2] <= ' '; ++i2) {
        }
        if (i2 == length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.EMPTY_ARRAY;
                return this;
            }
            this.hashLength = 0;
            return this;
        }
        int j2 = length;
        while (a2[--j2] <= ' ') {
        }
        int newLength = j2 - i2 + 1;
        if (length == newLength) {
            return this;
        }
        System.arraycopy(this.array, i2, this.array, 0, newLength);
        if (this.hashLength < 0) {
            this.setCapacity(newLength);
            this.hashLength = -1;
        } else {
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString trimLeft() {
        int newLength;
        int i2;
        int length = this.length();
        char[] a2 = this.array;
        if (length == 0) {
            return this;
        }
        for (i2 = 0; i2 < length && a2[i2] <= ' '; ++i2) {
        }
        if (i2 == length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.EMPTY_ARRAY;
                return this;
            }
            this.hashLength = 0;
        }
        if (length == (newLength = length - i2)) {
            return this;
        }
        System.arraycopy(this.array, i2, this.array, 0, newLength);
        if (this.hashLength < 0) {
            this.setCapacity(newLength);
            this.hashLength = -1;
        } else {
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString trimRight() {
        int length = this.length();
        char[] a2 = this.array;
        if (length == 0) {
            return this;
        }
        int j2 = length;
        while (j2-- != 0 && a2[j2] <= ' ') {
        }
        int newLength = j2 + 1;
        if (length == newLength) {
            return this;
        }
        if (this.hashLength < 0) {
            this.setCapacity(newLength);
            this.hashLength = -1;
        } else {
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString squeezeSpaces(boolean squeezeOnlyWhitespace) {
        int length = this.length();
        char[] a2 = this.array;
        int i2 = 0;
        int j2 = 0;
        while (i2 < length) {
            if (!(!squeezeOnlyWhitespace ? Character.isSpaceChar(a2[i2]) : Character.isWhitespace(a2[i2]))) {
                a2[j2++] = a2[i2++];
                continue;
            }
            a2[j2++] = 32;
            while (i2 < length && (squeezeOnlyWhitespace ? Character.isWhitespace(a2[i2]) : Character.isSpaceChar(a2[i2]))) {
                ++i2;
            }
        }
        if (length == j2) {
            return this;
        }
        if (this.hashLength < 0) {
            this.setCapacity(j2);
            this.hashLength = -1;
        } else {
            this.hashLength = j2;
        }
        return this;
    }

    public final MutableString squeezeWhitespace() {
        return this.squeezeSpaces(true);
    }

    public final MutableString squeezeSpace() {
        return this.squeezeSpaces(false);
    }

    public final MutableString reverse() {
        int k2 = this.length() - 1;
        char[] a2 = this.array;
        int i2 = (k2 - 1) / 2 + 1;
        while (i2-- != 0) {
            char c2 = a2[i2];
            a2[i2] = a2[k2 - i2];
            a2[k2 - i2] = c2;
        }
        this.changed();
        return this;
    }

    public final void write(Writer w) throws IOException {
        if (this.hashLength < 0) {
            w.write(this.array);
        } else {
            w.write(this.array, 0, this.hashLength);
        }
    }

    public final int read(Reader r, int length) throws IOException {
        boolean compact = this.hashLength < 0;
        this.expand(length);
        this.hashLength = 0;
        int result = r.read(this.array, 0, length);
        this.hashLength = result < length ? (result == -1 ? 0 : result) : (compact && length == this.array.length ? -1 : length);
        return result;
    }

    public final void print(PrintWriter w) {
        if (this.hashLength < 0) {
            w.write(this.array);
        } else {
            w.write(this.array, 0, this.hashLength);
        }
    }

    public final void println(PrintWriter w) {
        this.print(w);
        w.println();
    }

    public final void print(PrintStream s) {
        if (this.hashLength < 0) {
            s.print(this.array);
        } else {
            s.print(this.toString());
        }
    }

    public final void println(PrintStream s) {
        this.print(s);
        s.println();
    }

    public final void writeUTF8(DataOutput s) throws IOException {
        this.writeUTF8(s, this.length());
    }

    private void writeUTF8(DataOutput s, int length) throws IOException {
        char[] a2 = this.array;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = a2[i2];
            if (c2 <= '\u007f') {
                s.write(c2);
                continue;
            }
            if (c2 >= '\u0800') {
                s.write((byte)(0xE0 | c2 >> 12 & 0xF));
                s.write((byte)(0x80 | c2 >> 6 & 0x3F));
                s.write((byte)(0x80 | c2 >> 0 & 0x3F));
                continue;
            }
            s.write((byte)(0xC0 | c2 >> 6 & 0x1F));
            s.write((byte)(0x80 | c2 >> 0 & 0x3F));
        }
    }

    public final MutableString readUTF8(DataInput s, int length) throws IOException {
        boolean compact = this.hashLength < 0;
        this.expand(length);
        char[] a2 = this.array;
        block5: for (int i2 = 0; i2 < length; ++i2) {
            int b2 = s.readByte() & 0xFF;
            switch (b2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    a2[i2] = (char)b2;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int c2 = s.readByte() & 0xFF;
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a2[i2] = (char)((b2 & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    int c2 = s.readByte() & 0xFF;
                    int d2 = s.readByte() & 0xFF;
                    if ((c2 & 0xC0) != 128 || (d2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a2[i2] = (char)((b2 & 0xF) << 12 | (c2 & 0x3F) << 6 | (d2 & 0x3F) << 0);
                    continue block5;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        this.hashLength = compact && length == a2.length ? -1 : length;
        return this;
    }

    public final void writeSelfDelimUTF8(DataOutput s) throws IOException {
        int length = this.length();
        if (length < 128) {
            s.writeByte(length);
        } else if (length < 16384) {
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        } else if (length < 0x200000) {
            s.writeByte(length >>> 14 & 0x7F | 0x80);
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        } else if (length < 0x10000000) {
            s.writeByte(length >>> 21 & 0x7F | 0x80);
            s.writeByte(length >>> 14 & 0x7F | 0x80);
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        } else {
            s.writeByte(length >>> 28 & 0x7F | 0x80);
            s.writeByte(length >>> 21 & 0x7F | 0x80);
            s.writeByte(length >>> 14 & 0x7F | 0x80);
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        }
        this.writeUTF8(s, length);
    }

    public final MutableString readSelfDelimUTF8(DataInput s) throws IOException {
        byte b2;
        int length = 0;
        while ((b2 = s.readByte()) < 0) {
            length |= b2 & 0x7F;
            length <<= 7;
        }
        this.readUTF8(s, length |= b2);
        return this;
    }

    public final void writeUTF8(OutputStream s) throws IOException {
        this.writeUTF8(s, this.length());
    }

    private void writeUTF8(OutputStream s, int length) throws IOException {
        char[] a2 = this.array;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = a2[i2];
            if (c2 <= '\u007f') {
                s.write(c2);
                continue;
            }
            if (c2 >= '\u0800') {
                s.write((byte)(0xE0 | c2 >> 12 & 0xF));
                s.write((byte)(0x80 | c2 >> 6 & 0x3F));
                s.write((byte)(0x80 | c2 >> 0 & 0x3F));
                continue;
            }
            s.write((byte)(0xC0 | c2 >> 6 & 0x1F));
            s.write((byte)(0x80 | c2 >> 0 & 0x3F));
        }
    }

    public static int skipSelfDelimUTF8(InputStream s) throws IOException {
        int b2;
        int length = 0;
        while (true) {
            if ((b2 = s.read()) < 0) {
                throw new EOFException();
            }
            if ((b2 & 0x80) == 0) break;
            length |= b2 & 0x7F;
            length <<= 7;
        }
        length |= b2;
        block6: for (int i2 = 0; i2 < length; ++i2) {
            b2 = s.read();
            if (b2 == -1) {
                throw new EOFException();
            }
            switch ((b2 &= 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    continue block6;
                }
                case 12: 
                case 13: {
                    int c2 = s.read();
                    if (c2 == -1) {
                        throw new EOFException();
                    }
                    if (((c2 &= 0xFF) & 0xC0) == 128) continue block6;
                    throw new UTFDataFormatException();
                }
                case 14: {
                    int c2 = s.read();
                    if (c2 == -1) {
                        throw new EOFException();
                    }
                    c2 &= 0xFF;
                    int d2 = s.read();
                    if (d2 == -1) {
                        throw new EOFException();
                    }
                    if ((c2 & 0xC0) == 128 && ((d2 &= 0xFF) & 0xC0) == 128) continue block6;
                    throw new UTFDataFormatException();
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return length;
    }

    public final MutableString readUTF8(InputStream s, int length) throws IOException {
        boolean compact = this.hashLength < 0;
        this.expand(length);
        char[] a2 = this.array;
        block5: for (int i2 = 0; i2 < length; ++i2) {
            int b2 = s.read();
            if (b2 == -1) {
                throw new EOFException();
            }
            switch ((b2 &= 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    a2[i2] = (char)b2;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int c2 = s.read();
                    if (c2 == -1) {
                        throw new EOFException();
                    }
                    if (((c2 &= 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a2[i2] = (char)((b2 & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    int c2 = s.read();
                    if (c2 == -1) {
                        throw new EOFException();
                    }
                    c2 &= 0xFF;
                    int d2 = s.read();
                    if (d2 == -1) {
                        throw new EOFException();
                    }
                    if ((c2 & 0xC0) != 128 || ((d2 &= 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a2[i2] = (char)((b2 & 0xF) << 12 | (c2 & 0x3F) << 6 | (d2 & 0x3F) << 0);
                    continue block5;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        this.hashLength = compact && length == a2.length ? -1 : length;
        return this;
    }

    public final void writeSelfDelimUTF8(OutputStream s) throws IOException {
        int length = this.length();
        if (length < 128) {
            s.write(length);
        } else if (length < 16384) {
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        } else if (length < 0x200000) {
            s.write(length >>> 14 & 0x7F | 0x80);
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        } else if (length < 0x10000000) {
            s.write(length >>> 21 & 0x7F | 0x80);
            s.write(length >>> 14 & 0x7F | 0x80);
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        } else {
            s.write(length >>> 28 & 0x7F | 0x80);
            s.write(length >>> 21 & 0x7F | 0x80);
            s.write(length >>> 14 & 0x7F | 0x80);
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        }
        this.writeUTF8(s, length);
    }

    public final MutableString readSelfDelimUTF8(InputStream s) throws IOException {
        int b2;
        int length = 0;
        while (true) {
            if ((b2 = s.read()) < 0) {
                throw new EOFException();
            }
            if ((b2 & 0x80) == 0) break;
            length |= b2 & 0x7F;
            length <<= 7;
        }
        this.readUTF8(s, length |= b2);
        return this;
    }

    public final boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 instanceof MutableString) {
            return this.equals((MutableString)o2);
        }
        if (o2 instanceof String) {
            return this.equals((String)o2);
        }
        if (o2 instanceof CharSequence) {
            return this.equals((CharSequence)o2);
        }
        return false;
    }

    public final boolean equals(MutableString s) {
        if (s == this) {
            return true;
        }
        int n2 = this.length();
        if (n2 == s.length()) {
            char[] a1 = this.array;
            char[] a2 = s.array;
            while (n2-- != 0) {
                if (a1[n2] == a2[n2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equals(String s) {
        int n2 = this.length();
        if (n2 == s.length()) {
            char[] a2 = this.array;
            while (n2-- != 0) {
                if (a2[n2] == s.charAt(n2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equals(CharSequence s) {
        int n2 = this.length();
        if (n2 == s.length()) {
            char[] a2 = this.array;
            while (n2-- != 0) {
                if (a2[n2] == s.charAt(n2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(MutableString s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        int n2 = this.length();
        if (n2 == s.length()) {
            char[] a1 = this.array;
            char[] a2 = s.array;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a1[i2] == a2[i2] || Character.toLowerCase(a1[i2]) == Character.toLowerCase(a2[i2]) || Character.toUpperCase(a1[i2]) == Character.toUpperCase(a2[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(String s) {
        if (s == null) {
            return false;
        }
        int n2 = this.length();
        if (n2 == s.length()) {
            char[] a2 = this.array;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = s.charAt(i2);
                if (a2[i2] == c2 || Character.toLowerCase(a2[i2]) == Character.toLowerCase(c2) || Character.toUpperCase(a2[i2]) == Character.toUpperCase(c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(CharSequence s) {
        if (s == null) {
            return false;
        }
        int n2 = this.length();
        if (n2 == s.length()) {
            char[] a2 = this.array;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = s.charAt(i2);
                if (a2[i2] == c2 || Character.toLowerCase(a2[i2]) == Character.toLowerCase(c2) || Character.toUpperCase(a2[i2]) == Character.toUpperCase(c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final int compareTo(MutableString s) {
        int l2;
        int l1 = this.length();
        int n2 = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a1 = this.array;
        char[] a2 = s.array;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (a1[i2] == a2[i2]) continue;
            return a1[i2] - a2[i2];
        }
        return l1 - l2;
    }

    @Override
    public final int compareTo(String s) {
        int l2;
        int l1 = this.length();
        int n2 = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a2 = this.array;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (a2[i2] == s.charAt(i2)) continue;
            return a2[i2] - s.charAt(i2);
        }
        return l1 - l2;
    }

    @Override
    public final int compareTo(CharSequence s) {
        int l2;
        int l1 = this.length();
        int n2 = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a2 = this.array;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (a2[i2] == s.charAt(i2)) continue;
            return a2[i2] - s.charAt(i2);
        }
        return l1 - l2;
    }

    public final int compareToIgnoreCase(MutableString s) {
        int l2;
        int l1 = this.length();
        int n2 = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a1 = this.array;
        char[] a2 = s.array;
        for (int i2 = 0; i2 < n2; ++i2) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(a1[i2]));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(a2[i2])))) continue;
            return c2 - d2;
        }
        return l1 - l2;
    }

    public final int compareToIgnoreCase(String s) {
        int l2;
        int l1 = this.length();
        int n2 = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a2 = this.array;
        for (int i2 = 0; i2 < n2; ++i2) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(a2[i2]));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(s.charAt(i2))))) continue;
            return c2 - d2;
        }
        return l1 - l2;
    }

    public final int compareToIgnoreCase(CharSequence s) {
        int l2;
        int l1 = this.length();
        int n2 = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a2 = this.array;
        for (int i2 = 0; i2 < n2; ++i2) {
            char d2;
            char c2 = Character.toLowerCase(Character.toUpperCase(a2[i2]));
            if (c2 == (d2 = Character.toLowerCase(Character.toUpperCase(s.charAt(i2))))) continue;
            return c2 - d2;
        }
        return l1 - l2;
    }

    public final int hashCode() {
        int h2 = this.hashLength;
        if (h2 >= -1) {
            char[] a2 = this.array;
            int l2 = this.length();
            h2 = 0;
            for (int i2 = 0; i2 < l2; ++i2) {
                h2 = 31 * h2 + a2[i2];
            }
            h2 |= Integer.MIN_VALUE;
            if (this.hashLength == -1) {
                this.hashLength = h2;
            }
        }
        return h2;
    }

    @Override
    public final String toString() {
        return new String(this.array, 0, this.length());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int length = this.length();
        char[] a2 = this.array;
        s.writeInt(length);
        for (int i2 = 0; i2 < length; ++i2) {
            s.writeChar(a2[i2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int length = s.readInt();
        this.hashLength = -1;
        this.expand(length);
        char[] a2 = this.array;
        for (int i2 = 0; i2 < length; ++i2) {
            a2[i2] = s.readChar();
        }
    }

    private class SubSequence
    implements CharSequence {
        final int from;
        final int to;

        private SubSequence(int from, int to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public char charAt(int index) {
            return MutableString.this.array[this.from + index];
        }

        @Override
        public int length() {
            return this.to - this.from;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (end < start || end > this.length()) {
                throw new StringIndexOutOfBoundsException(end);
            }
            return new SubSequence(this.from + start, this.from + end);
        }

        public int hashCode() {
            int h2 = 0;
            char[] a2 = MutableString.this.array;
            for (int i2 = this.from; i2 < this.to; ++i2) {
                h2 = 31 * h2 + a2[i2];
            }
            return h2 | Integer.MIN_VALUE;
        }

        public boolean equals(Object o2) {
            if (o2 instanceof CharSequence) {
                CharSequence s = (CharSequence)o2;
                int n2 = this.length();
                if (n2 == s.length()) {
                    while (n2-- != 0) {
                        if (this.charAt(n2) == s.charAt(n2)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return new String(MutableString.this.array, this.from, this.to - this.from);
        }
    }
}

