/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOpenHashSet<K>
extends AbstractObjectSet<K>
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;

    public ObjectOpenHashSet(int expected, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.n = HashCommon.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new Object[this.n];
        this.used = new boolean[this.n];
    }

    public ObjectOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    public ObjectOpenHashSet() {
        this(16, 0.75f);
    }

    public ObjectOpenHashSet(Collection<? extends K> c2, float f2) {
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public ObjectOpenHashSet(Collection<? extends K> c2) {
        this(c2, 0.75f);
    }

    public ObjectOpenHashSet(ObjectCollection<? extends K> c2, float f2) {
        this(c2.size(), f2);
        this.addAll(c2);
    }

    public ObjectOpenHashSet(ObjectCollection<? extends K> c2) {
        this(c2, 0.75f);
    }

    public ObjectOpenHashSet(ObjectIterator<K> i2, float f2) {
        this(16, f2);
        while (i2.hasNext()) {
            this.add((K)i2.next());
        }
    }

    public ObjectOpenHashSet(ObjectIterator<K> i2) {
        this(i2, 0.75f);
    }

    public ObjectOpenHashSet(K[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0 : length, f2);
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2[offset + i2]);
        }
    }

    public ObjectOpenHashSet(K[] a2, int offset, int length) {
        this(a2, offset, length, 0.75f);
    }

    public ObjectOpenHashSet(K[] a2, float f2) {
        this(a2, 0, a2.length, f2);
    }

    public ObjectOpenHashSet(K[] a2) {
        this(a2, 0.75f);
    }

    @Override
    public boolean add(K k2) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k2 == null ? this.key[pos] == null : k2.equals(this.key[pos])) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k2;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(this.key[pos].hashCode())) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
        }
        this.used[last] = false;
        this.key[last] = null;
    }

    @Override
    public boolean remove(Object k2) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k2 == null ? this.key[pos] == null : k2.equals(this.key[pos])) {
                --this.size;
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean contains(Object k2) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode())) & this.mask;
        while (this.used[pos]) {
            if (k2 == null ? this.key[pos] == null : k2.equals(this.key[pos])) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return this.used[pos];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    @Override
    public ObjectIterator<K> iterator() {
        return new SetIterator();
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l2 = HashCommon.arraySize(this.size, this.f);
        if (l2 >= this.n) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n2) {
        int l2 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (this.n <= l2) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i2 = 0;
        boolean[] used = this.used;
        K[] key = this.key;
        int newMask = newN - 1;
        Object[] newKey = new Object[newN];
        boolean[] newUsed = new boolean[newN];
        int j2 = this.size;
        while (j2-- != 0) {
            while (!used[i2]) {
                ++i2;
            }
            K k2 = key[i2];
            int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode())) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k2;
            ++i2;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.used = newUsed;
    }

    public ObjectOpenHashSet<K> clone() {
        ObjectOpenHashSet c2;
        try {
            c2 = (ObjectOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.key = (Object[])this.key.clone();
        c2.used = (boolean[])this.used.clone();
        return c2;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int i2 = 0;
        int j2 = this.size;
        while (j2-- != 0) {
            while (!this.used[i2]) {
                ++i2;
            }
            if (this != this.key[i2]) {
                h2 += this.key[i2] == null ? 0 : this.key[i2].hashCode();
            }
            ++i2;
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator i2 = this.iterator();
        s.defaultWriteObject();
        int j2 = this.size;
        while (j2-- != 0) {
            s.writeObject(i2.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i2 = this.size;
        int pos = 0;
        while (i2-- != 0) {
            Object k2 = s.readObject();
            pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode())) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k2;
        }
    }

    private void checkTable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetIterator
    extends AbstractObjectIterator<K> {
        int pos;
        int last;
        int c;

        private SetIterator() {
            this.pos = ObjectOpenHashSet.this.n;
            this.last = -1;
            this.c = ObjectOpenHashSet.this.size;
            boolean[] used = ObjectOpenHashSet.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            Object retVal = ObjectOpenHashSet.this.key[this.last];
            if (--this.c != 0) {
                boolean[] used = ObjectOpenHashSet.this.used;
                while (!used[this.pos = this.pos - 1 & ObjectOpenHashSet.this.mask]) {
                }
            }
            return retVal;
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --ObjectOpenHashSet.this.size;
            ObjectOpenHashSet.this.shiftKeys(this.last);
            this.last = -1;
        }
    }
}

