/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;

public class ByteArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 1;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private ByteArrays() {
    }

    public static byte[] ensureCapacity(byte[] array, int length) {
        if (length > array.length) {
            byte[] t = new byte[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static byte[] ensureCapacity(byte[] array, int length, int preserve) {
        if (length > array.length) {
            byte[] t = new byte[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static byte[] trim(byte[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        byte[] t = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static byte[] setLength(byte[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ByteArrays.trim(array, length);
        }
        return ByteArrays.ensureCapacity(array, length);
    }

    public static byte[] copy(byte[] array, int offset, int length) {
        ByteArrays.ensureOffsetLength(array, offset, length);
        byte[] a2 = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static byte[] copy(byte[] array) {
        return (byte[])array.clone();
    }

    public static void fill(byte[] array, byte value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(byte[] array, int from, int to, byte value) {
        ByteArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(byte[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(byte[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(byte[] x, int a2, int b2) {
        byte t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    private static void vecSwap(byte[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            ByteArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(byte[] x, int a2, int b2, int c2, ByteComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(byte[] a2, int from, int to, ByteComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (comp.compare(a2[j2], a2[m2]) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            byte u = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u;
        }
    }

    private static void insertionSort(byte[] a2, int from, int to, ByteComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            byte t = a2[i2];
            int j2 = i2;
            byte u = a2[j2 - 1];
            while (comp.compare(t, u) < 0) {
                a2[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = a2[--j2 - 1];
            }
            a2[j2] = t;
        }
    }

    private static void selectionSort(byte[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2]) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            byte u = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u;
        }
    }

    private static void insertionSort(byte[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            byte t = a2[i2];
            int j2 = i2;
            byte u = a2[j2 - 1];
            while (t < u) {
                a2[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = a2[--j2 - 1];
            }
            a2[j2] = t;
        }
    }

    public static void quickSort(byte[] x, int from, int to, ByteComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            ByteArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s = len / 8;
                l2 = ByteArrays.med3(x, l2, l2 + s, l2 + 2 * s, comp);
                m2 = ByteArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = ByteArrays.med3(x, n2 - 2 * s, n2 - s, n2, comp);
            }
            m2 = ByteArrays.med3(x, l2, m2, n2, comp);
        }
        byte v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ByteArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ByteArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ByteArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ByteArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1) {
            ByteArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    public static void quickSort(byte[] x, ByteComparator comp) {
        ByteArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(byte[] x, int a2, int b2, int c2) {
        int bc;
        int ac;
        int ab;
        int n2 = x[a2] < x[b2] ? -1 : (ab = x[a2] == x[b2] ? 0 : 1);
        int n3 = x[a2] < x[c2] ? -1 : (ac = x[a2] == x[c2] ? 0 : 1);
        int n4 = x[b2] < x[c2] ? -1 : (bc = x[b2] == x[c2] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(byte[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            ByteArrays.selectionSort(x, from, to);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s = len / 8;
                l2 = ByteArrays.med3(x, l2, l2 + s, l2 + 2 * s);
                m2 = ByteArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = ByteArrays.med3(x, n2 - 2 * s, n2 - s, n2);
            }
            m2 = ByteArrays.med3(x, l2, m2, n2);
        }
        byte v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (x[b2] < v ? -1 : (comparison = x[b2] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (x[c2] < v ? -1 : (comparison = x[c2] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ByteArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ByteArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ByteArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ByteArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            ByteArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(byte[] x) {
        ByteArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(byte[] a2, int from, int to, byte[] supp) {
        int len = to - from;
        if (len < 7) {
            ByteArrays.insertionSort(a2, from, to);
            return;
        }
        int mid = from + to >>> 1;
        ByteArrays.mergeSort(supp, from, mid, a2);
        ByteArrays.mergeSort(supp, mid, to, a2);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q >= to || p2 < mid && supp[p2] <= supp[q] ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(byte[] a2, int from, int to) {
        ByteArrays.mergeSort(a2, from, to, (byte[])a2.clone());
    }

    public static void mergeSort(byte[] a2) {
        ByteArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(byte[] a2, int from, int to, ByteComparator comp, byte[] supp) {
        int len = to - from;
        if (len < 7) {
            ByteArrays.insertionSort(a2, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        ByteArrays.mergeSort(supp, from, mid, comp, a2);
        ByteArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q >= to || p2 < mid && comp.compare(supp[p2], supp[q]) <= 0 ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(byte[] a2, int from, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a2, from, to, comp, (byte[])a2.clone());
    }

    public static void mergeSort(byte[] a2, ByteComparator comp) {
        ByteArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(byte[] a2, int from, int to, byte key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            byte midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(byte[] a2, byte key) {
        return ByteArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(byte[] a2, int from, int to, byte key, ByteComparator c2) {
        while (from <= to) {
            int mid = from + to >>> 1;
            byte midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(byte[] a2, byte key, ByteComparator c2) {
        return ByteArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    public static void radixSort(byte[] a2) {
        ByteArrays.radixSort(a2, 0, a2.length);
    }

    public static void radixSort(byte[] a2, int from, int to) {
        boolean maxLevel = false;
        boolean stackSize = true;
        int[] offsetStack = new int[1];
        int offsetPos = 0;
        int[] lengthStack = new int[1];
        int lengthPos = 0;
        int[] levelStack = new int[1];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2.length];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 1 == 0 ? 128 : 0;
            if (length < 50) {
                ByteArrays.selectionSort(a2, first, first + length);
                continue;
            }
            int shift = (0 - level % 1) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(a2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[first + i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 0 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                byte t = a2[i4];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    byte z = t;
                    int zz = c2;
                    t = a2[d2];
                    c2 = digit[d2] & 0xFF;
                    a2[d2] = z;
                    digit[d2] = (byte)zz;
                }
                a2[i4] = t;
                count[c2] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, byte[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j2 = i2;
            int u = perm[j2 - 1];
            while (a2[t] < a2[u]) {
                perm[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = perm[--j2 - 1];
            }
            perm[j2] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, byte[] a2, boolean stable) {
        ByteArrays.radixSortIndirect(perm, a2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, byte[] a2, int from, int to, boolean stable) {
        boolean maxLevel = false;
        boolean stackSize = true;
        int[] offsetStack = new int[1];
        int offsetPos = 0;
        int[] lengthStack = new int[1];
        int lengthPos = 0;
        int[] levelStack = new int[1];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[perm.length];
        while (offsetPos > 0) {
            int i2;
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 1 == 0 ? 128 : 0;
            if (length < 50) {
                ByteArrays.insertionSortIndirect(perm, a2, first, first + length);
                continue;
            }
            int shift = (0 - level % 1) * 8;
            int i3 = length;
            while (i3-- != 0) {
                digit[i3] = (byte)(a2[perm[first + i3]] >>> shift & 0xFF ^ signMask);
            }
            i3 = length;
            while (i3-- != 0) {
                int n3 = digit[i3] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 0 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i2] = p2 += count[i2];
                    continue;
                }
                pos[i2] = p2 += count[i2];
            }
            if (stable) {
                i2 = length;
                while (i2-- != 0) {
                    int n4 = digit[i2] & 0xFF;
                    int n5 = count[n4] - 1;
                    count[n4] = n5;
                    support[n5] = perm[first + i2];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t = perm[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n6 = c2;
                    int n7 = pos[n6] - 1;
                    pos[n6] = n7;
                    int d2 = n7;
                    if (n7 <= i4) break;
                    int z = t;
                    int zz = c2;
                    t = perm[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    perm[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                perm[i4 + first] = t;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(byte[] a2, byte[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2] && (a2[j2] != a2[m2] || b2[j2] >= b2[m2])) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            byte t = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = t;
            t = b2[i2];
            b2[i2] = b2[m2];
            b2[m2] = t;
        }
    }

    public static void radixSort(byte[] a2, byte[] b2) {
        ByteArrays.radixSort(a2, b2, 0, a2.length);
    }

    public static void radixSort(byte[] a2, byte[] b2, int from, int to) {
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        boolean maxLevel = true;
        int stackSize = 256;
        int[] offsetStack = new int[256];
        int offsetPos = 0;
        int[] lengthStack = new int[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2.length];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 1 == 0 ? 128 : 0;
            if (length < 50) {
                ByteArrays.selectionSort(a2, b2, first, first + length);
                continue;
            }
            byte[] k2 = level < 1 ? a2 : b2;
            int shift = (0 - level % 1) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[first + i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 1 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                byte t = a2[i4];
                byte u = b2[i4];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    byte z = t;
                    int zz = c2;
                    t = a2[d2];
                    a2[d2] = z;
                    z = u;
                    u = b2[d2];
                    b2[d2] = z;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                a2[i4] = t;
                b2[i4] = u;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(byte[][] a2, int from, int to, int level) {
        int layers = a2.length;
        int firstLayer = level / 1;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            block1: for (int j2 = i2 + 1; j2 < to; ++j2) {
                for (int p2 = firstLayer; p2 < layers; ++p2) {
                    if (a2[p2][j2] < a2[p2][m2]) {
                        m2 = j2;
                        continue block1;
                    }
                    if (a2[p2][j2] > a2[p2][m2]) continue block1;
                }
            }
            if (m2 == i2) continue;
            int p3 = layers;
            while (p3-- != 0) {
                byte u = a2[p3][i2];
                a2[p3][i2] = a2[p3][m2];
                a2[p3][m2] = u;
            }
        }
    }

    public static void radixSort(byte[][] a2) {
        ByteArrays.radixSort(a2, 0, a2[0].length);
    }

    public static void radixSort(byte[][] a2, int from, int to) {
        int layers = a2.length;
        int maxLevel = 1 * layers - 1;
        int p2 = layers;
        int l2 = a2[0].length;
        while (p2-- != 0) {
            if (a2[p2].length == l2) continue;
            throw new IllegalArgumentException("The array of index " + p2 + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 1 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2[0].length];
        byte[] t = new byte[layers];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 1 == 0 ? 128 : 0;
            if (length < 50) {
                ByteArrays.selectionSort(a2, first, first + length, level);
                continue;
            }
            byte[] k2 = a2[level / 1];
            int shift = (0 - level % 1) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[first + i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p3 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < maxLevel && count[i3] > 1) {
                        offsetStack[offsetPos++] = p3;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p3 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                int p4 = layers;
                while (p4-- != 0) {
                    t[p4] = a2[p4][i4];
                }
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    p4 = layers;
                    while (p4-- != 0) {
                        byte u = t[p4];
                        t[p4] = a2[p4][d2];
                        a2[p4][d2] = u;
                    }
                    int zz = c2;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                p4 = layers;
                while (p4-- != 0) {
                    a2[p4][i4] = t[p4];
                }
                count[c2] = 0;
            }
        }
    }

    public static byte[] shuffle(byte[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            byte t = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t;
        }
        return a2;
    }

    public static byte[] shuffle(byte[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            byte t = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t;
        }
        return a2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<byte[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(byte[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(byte[] a2, byte[] b2) {
            return ByteArrays.equals(a2, b2);
        }
    }
}

