/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.modes;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import edu.cornell.med.icb.goby.modes.AbstractCommandLineMode;
import edu.cornell.med.icb.io.ResourceFinder;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericToolsDriver
extends AbstractCommandLineMode {
    private static final Log LOG = LogFactory.getLog(GenericToolsDriver.class);
    private String mode;
    private JSAP jsap;
    private String[] args;
    private final Map<String, Class> MODES_MAP = this.loadModeMap();
    protected final Map<String, String> HELP_VALUES = new HashMap<String, String>();

    @Override
    public String getModeName() {
        return null;
    }

    @Override
    public String getModeDescription() {
        return null;
    }

    public GenericToolsDriver(String jarFilename) {
        super(jarFilename);
        StringBuilder modesList = new StringBuilder();
        ArrayList<String> modes = new ArrayList<String>(this.MODES_MAP.keySet());
        Collections.sort(modes);
        for (String mode : modes) {
            modesList.append("* ").append(mode).append('\n');
        }
        this.HELP_VALUES.put("[MODES_LIST]", modesList.toString());
    }

    @Override
    public void printUsage(JSAP jsapVal) {
        try {
            System.err.println("java -jar " + this.getJarFilename() + " " + jsapVal.getUsage());
            System.err.println();
            System.err.println(jsapVal.getHelp());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public GenericToolsDriver configure(String[] argsVal) throws IOException, JSAPException {
        this.jsap = this.loadJsapFromResource(this.HELP_VALUES);
        this.args = argsVal;
        JSAPResult jsapResult = this.parseJsap(this.jsap, this.args);
        this.mode = jsapResult.getString("mode");
        if (this.mode == null) {
            this.unregisterFormattedHelp(this.jsap);
            this.printUsage(this.jsap);
            System.exit(1);
        }
        return this;
    }

    private void unregisterFormattedHelp(JSAP jsapVal) {
        Parameter wikiHelpId;
        Parameter htmlHelpId = jsapVal.getByID("htmlhelp");
        if (htmlHelpId != null) {
            jsapVal.unregisterParameter(htmlHelpId);
        }
        if ((wikiHelpId = jsapVal.getByID("wikihelp")) != null) {
            jsapVal.unregisterParameter(wikiHelpId);
        }
    }

    @Override
    public void execute() throws IOException {
        Class modeClass = this.MODES_MAP.get(this.mode);
        Exception caught = null;
        try {
            if (modeClass != null) {
                AbstractCommandLineMode modeObject = (AbstractCommandLineMode)modeClass.newInstance();
                modeObject.configure(this.args);
                modeObject.execute();
            }
        }
        catch (JSAPException e2) {
            caught = e2;
        }
        catch (IllegalAccessException e3) {
            caught = e3;
        }
        catch (InstantiationException e4) {
            caught = e4;
        }
        catch (OutOfMemoryError e5) {
            e5.printStackTrace();
            System.err.println("\n!!\n!! An out of memory exception was thrown.!! Try running with more memory such as -Xmx1200m -XX:PermSize=384m\n!!\n");
            throw e5;
        }
        if (modeClass == null || caught != null) {
            if (modeClass == null) {
                System.err.println("Unrecognized mode: '" + this.mode + "'");
                this.unregisterFormattedHelp(this.jsap);
            }
            this.printUsage(this.jsap);
            if (caught != null) {
                System.err.println();
                System.err.println("Exception caught type=" + caught.getClass().toString());
                System.err.println("   Message=" + caught.getMessage());
                caught.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private Map<String, Class> loadModeMap() {
        HashMap<String, Class> modeMap = new HashMap<String, Class>();
        for (String modeClassName : this.modesClassNamesList()) {
            try {
                String modeName;
                Object modeInstance;
                LOG.debug("About to process modeClassName: " + modeClassName);
                Class<?> modeClass = Class.forName(modeClassName);
                if (Modifier.isAbstract(modeClass.getModifiers()) || !((modeInstance = modeClass.newInstance()) instanceof AbstractCommandLineMode) || (modeName = ((AbstractCommandLineMode)modeInstance).getModeName()) == null) continue;
                modeMap.put(modeName, modeClass);
            }
            catch (ClassNotFoundException e2) {
                System.err.println("Could find a class for " + modeClassName + " ClassNotFoundException: " + e2.getMessage());
            }
            catch (IllegalAccessException e3) {
                System.err.println("Could not find MODE_NAME for class " + modeClassName + " IllegalAccessException: " + e3.getMessage());
            }
            catch (InstantiationException e4) {
                System.err.println("Could not find MODE_NAME for class " + modeClassName + " InstantiationException: " + e4.getMessage());
            }
        }
        return modeMap;
    }

    private List<String> modesClassNamesList() {
        LinkedList<String> modesList = new LinkedList<String>();
        try {
            String[] files;
            String modesPackage = ClassUtils.getPackageName(this.getClass());
            for (String file : files = new ResourceFinder().getResourceListing(this.getClass())) {
                if (!file.endsWith("Mode.class")) continue;
                String modeClassName = modesPackage + "." + file.substring(0, file.length() - 6);
                modesList.add(modeClassName);
            }
        }
        catch (URISyntaxException e2) {
            System.err.println("Could not list mode class names URISyntaxException: " + e2.getMessage());
            e2.printStackTrace();
        }
        catch (IOException e3) {
            System.err.println("Could not list mode class names IOException: " + e3.getMessage());
            e3.printStackTrace();
        }
        return modesList;
    }
}

