/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class RangeSlider
extends JSlider {
    private static final String uiClassID = "RangeSliderUI";

    public RangeSlider() {
    }

    public RangeSlider(int n2) {
        super(n2);
    }

    public RangeSlider(int n2, int n3) {
        super(n2, n3);
    }

    public RangeSlider(int n2, int n3, int n4, int n5) {
        super(new DefaultBoundedRangeModel(n4, n5 - n4, n2, n3));
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getLowValue() {
        return this.getModel().getValue();
    }

    public int getHighValue() {
        return this.getModel().getValue() + this.getModel().getExtent();
    }

    public boolean contains(int n2) {
        return n2 >= this.getLowValue() && n2 <= this.getHighValue();
    }

    public void setLowValue(int n2) {
        int n3 = n2 + this.getModel().getExtent() > this.getMaximum() ? this.getMaximum() : this.getHighValue();
        int n4 = n3 - n2;
        this.getModel().setRangeProperties(n2, n4, this.getMinimum(), this.getMaximum(), true);
    }

    public void setHighValue(int n2) {
        this.getModel().setExtent(n2 - this.getLowValue());
    }
}

