/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractDistribution;
import org.apache.commons.math.distribution.IntegerDistribution;

public abstract class AbstractIntegerDistribution
extends AbstractDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = -1146319659338487221L;

    protected AbstractIntegerDistribution() {
    }

    public double cumulativeProbability(double x) throws MathException {
        return this.cumulativeProbability((int)Math.floor(x));
    }

    public abstract double cumulativeProbability(int var1) throws MathException;

    public double probability(double x) {
        double fl = Math.floor(x);
        if (fl == x) {
            return this.probability((int)x);
        }
        return 0.0;
    }

    public double cumulativeProbability(int x0, int x1) throws MathException {
        if (x0 > x1) {
            throw new IllegalArgumentException("lower endpoint must be less than or equal to upper endpoint");
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0 - 1);
    }

    public int inverseCumulativeProbability(double p2) throws MathException {
        double pm;
        if (p2 < 0.0 || p2 > 1.0) {
            throw new IllegalArgumentException("p must be between 0 and 1.0 (inclusive)");
        }
        int x0 = this.getDomainLowerBound(p2);
        int x1 = this.getDomainUpperBound(p2);
        while (x0 < x1) {
            int xm = x0 + (x1 - x0) / 2;
            pm = this.cumulativeProbability(xm);
            if (pm > p2) {
                if (xm == x1) {
                    --x1;
                    continue;
                }
                x1 = xm;
                continue;
            }
            if (xm == x0) {
                ++x0;
                continue;
            }
            x0 = xm;
        }
        pm = this.cumulativeProbability(x0);
        while (pm > p2) {
            pm = this.cumulativeProbability(--x0);
        }
        return x0;
    }

    protected abstract int getDomainLowerBound(double var1);

    protected abstract int getDomainUpperBound(double var1);

    public abstract double probability(int var1);
}

