/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;

public class VariantMenu
extends IGVPopupMenu {
    private static Logger log = Logger.getLogger(VariantMenu.class);
    private VariantTrack track;
    static boolean depthSortingDirection;
    static boolean genotypeSortingDirection;
    static boolean sampleSortingDirection;
    static boolean qualitySortingDirection;

    public VariantMenu(VariantTrack variantTrack, Variant variant) {
        JMenuItem item2;
        this.track = variantTrack;
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.close();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.close();
            }

            private void close() {
                VariantMenu.this.track.clearSelectedVariant();
            }
        });
        JLabel popupTitle = new JLabel("<html><b>" + this.track.getName(), 2);
        Font newFont = this.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        this.add(popupTitle);
        this.addSeparator();
        List<Track> selectedTracks = Arrays.asList(variantTrack);
        this.add(TrackMenuUtils.getTrackRenameItem(selectedTracks));
        this.add(TrackMenuUtils.getChangeFontSizeItem(selectedTracks));
        this.addSeparator();
        JLabel colorByItem = new JLabel("<html>&nbsp;&nbsp;<b>Color By", 2);
        this.add(colorByItem);
        this.add(this.getColorByGenotype());
        this.add(this.getColorByAllele());
        if (this.track.isEnableMethylationRateSupport()) {
            this.add(this.getColorByMethylationRate());
        }
        this.addSeparator();
        for (JMenuItem item2 : this.getSortMenuItems(variant)) {
            this.add(item2);
            if (variant != null) continue;
            item2.setEnabled(false);
        }
        this.addSeparator();
        JLabel displayHeading = new JLabel("Display Mode", 2);
        this.add(displayHeading);
        for (JMenuItem item3 : this.getDisplayModeItems()) {
            this.add(item3);
        }
        this.addSeparator();
        item2 = new JMenuItem("Change Squished Row Height...");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int currentValue = VariantMenu.this.track.getSquishedHeight();
                int newValue = TrackMenuUtils.getIntValue("Squished row height", currentValue);
                if (newValue != Integer.MIN_VALUE) {
                    VariantMenu.this.track.setSquishedHeight(newValue);
                    IGV.getInstance().getContentPane().repaint();
                }
            }
        });
        this.add(item2);
        this.add(this.getHideFilteredItem());
        this.add(this.getFeatureVisibilityItem());
        this.addSeparator();
        this.add(TrackMenuUtils.getRemoveMenuItem(Arrays.asList(this.track)));
    }

    private JMenuItem getFeatureVisibilityItem() {
        JMenuItem item = new JMenuItem("Set Feature Visibility Window...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.changeVisibilityWindow();
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getColorByGenotype() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Genotype", this.track.getColorMode() == VariantTrack.ColorMode.GENOTYPE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setColorMode(VariantTrack.ColorMode.GENOTYPE);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getColorByAllele() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Allele", this.track.getColorMode() == VariantTrack.ColorMode.ALLELE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setColorMode(VariantTrack.ColorMode.ALLELE);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getColorByMethylationRate() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Methylation Rate", this.track.getColorMode() == VariantTrack.ColorMode.METHYLATION_RATE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setColorMode(VariantTrack.ColorMode.METHYLATION_RATE);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    private JMenuItem getHideFilteredItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Suppress Filtered Sites", this.track.getHideFiltered());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setHideFiltered(!VariantMenu.this.track.getHideFiltered());
                IGV.getInstance().getContentPane().repaint();
            }
        });
        return item;
    }

    public JMenuItem getGenotypeSortItem(final Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Genotype");
        if (variant != null) {
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GenotypeComparator compare = new GenotypeComparator(variant);
                    genotypeSortingDirection = !genotypeSortingDirection;
                    VariantMenu.this.track.sortSamples(compare);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
        }
        return item;
    }

    public JMenuItem getSampleNameSortItem(Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Sample Name");
        if (variant != null) {
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Comparator<String> compare = new Comparator<String>(){

                        @Override
                        public int compare(String o2, String o1) {
                            if (sampleSortingDirection) {
                                return o2.compareTo(o1);
                            }
                            return o1.compareTo(o2);
                        }
                    };
                    sampleSortingDirection = !sampleSortingDirection;
                    VariantMenu.this.track.sortSamples(compare);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
        }
        return item;
    }

    public JMenuItem getDepthSortItem(final Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Depth");
        if (variant != null) {
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DepthComparator compare = new DepthComparator(variant);
                    depthSortingDirection = !depthSortingDirection;
                    VariantMenu.this.track.sortSamples(compare);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
        }
        return item;
    }

    public JMenuItem getQualitySortItem(final Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Quality");
        if (variant != null) {
            double quality = variant.getPhredScaledQual();
            if (quality > -1.0) {
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        QualityComparator compare = new QualityComparator(variant);
                        qualitySortingDirection = !qualitySortingDirection;
                        VariantMenu.this.track.sortSamples(compare);
                        IGV.getInstance().getContentPane().repaint();
                    }
                });
            } else {
                item.setEnabled(false);
            }
        }
        return item;
    }

    public void changeVisibilityWindow() {
        int value = VariantMenu.getIntValue("Visibility Window", this.track.getVisibilityWindow());
        if (value > 0) {
            this.track.setVisibilityWindow(value);
        }
    }

    private static int getIntValue(String parameter, int value) {
        String height;
        while ((height = JOptionPane.showInputDialog(IGV.getMainFrame(), parameter + ": ", String.valueOf(value))) != null && !height.trim().equals("")) {
            try {
                value = Integer.parseInt(height);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), parameter + " must be an integer number.");
                continue;
            }
            break;
        }
        return Integer.MIN_VALUE;
    }

    public Collection<JMenuItem> getSortMenuItems(Variant variant) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        items.add(this.getGenotypeSortItem(variant));
        items.add(this.getSampleNameSortItem(variant));
        items.add(this.getDepthSortItem(variant));
        items.add(this.getQualitySortItem(variant));
        return items;
    }

    public List<JMenuItem> getDisplayModeItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ButtonGroup group = new ButtonGroup();
        Track.DisplayMode displayMode = this.track.getDisplayMode();
        JRadioButtonMenuItem m1 = new JRadioButtonMenuItem("Collapsed");
        m1.setSelected(displayMode == Track.DisplayMode.COLLAPSED);
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setDisplayMode(Track.DisplayMode.COLLAPSED);
                IGV.getInstance().doRefresh();
            }
        });
        JRadioButtonMenuItem m2 = new JRadioButtonMenuItem("Squished");
        m2.setSelected(displayMode == Track.DisplayMode.SQUISHED);
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setDisplayMode(Track.DisplayMode.SQUISHED);
                IGV.getInstance().doRefresh();
            }
        });
        JRadioButtonMenuItem m3 = new JRadioButtonMenuItem("Expanded");
        m3.setSelected(displayMode == Track.DisplayMode.EXPANDED);
        m3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setDisplayMode(Track.DisplayMode.EXPANDED);
                IGV.getInstance().doRefresh();
            }
        });
        items.add(m1);
        items.add(m2);
        items.add(m3);
        group.add(m1);
        group.add(m2);
        group.add(m3);
        return items;
    }

    static class QualityComparator
    implements Comparator<String> {
        Variant variant;

        QualityComparator(Variant variant) {
            this.variant = variant;
        }

        @Override
        public int compare(String s1, String s2) {
            double qual1 = this.variant.getGenotype(s1).getPhredScaledQual();
            double qual2 = this.variant.getGenotype(s2).getPhredScaledQual();
            if (qual2 == qual1) {
                return 0;
            }
            if (qual2 < qual1) {
                return qualitySortingDirection ? -1 : 1;
            }
            return qualitySortingDirection ? 1 : 1;
        }
    }

    static class DepthComparator
    implements Comparator<String> {
        Variant variant;

        DepthComparator(Variant variant) {
            this.variant = variant;
        }

        @Override
        public int compare(String s1, String s2) {
            double depth2;
            Double readDepth1 = this.variant.getGenotype(s1).getAttributeAsDouble("DP");
            Double readDepth2 = this.variant.getGenotype(s2).getAttributeAsDouble("DP");
            double depth1 = readDepth1 == null ? -1.0 : readDepth1;
            double d2 = depth2 = readDepth2 == null ? -1.0 : readDepth2;
            if (depth2 == depth1) {
                return 0;
            }
            if (depth2 < depth1) {
                return depthSortingDirection ? -1 : 1;
            }
            return depthSortingDirection ? 1 : 1;
        }
    }

    static class GenotypeComparator
    implements Comparator<String> {
        Variant variant;

        GenotypeComparator(Variant variant) {
            this.variant = variant;
        }

        @Override
        public int compare(String e1, String e2) {
            int genotype1 = this.classifyGenotype(this.variant.getGenotype(e1));
            int genotype2 = this.classifyGenotype(this.variant.getGenotype(e2));
            if (genotype2 == genotype1) {
                return 0;
            }
            if (genotype2 > genotype1) {
                return genotypeSortingDirection ? 1 : -1;
            }
            return genotypeSortingDirection ? -1 : 1;
        }

        private int classifyGenotype(Genotype genotype) {
            if (genotype.isNoCall()) {
                return genotypeSortingDirection ? 1 : 10;
            }
            if (genotype.isHomVar()) {
                return 4;
            }
            if (genotype.isHet()) {
                return 3;
            }
            if (genotype.isHomRef()) {
                return genotypeSortingDirection ? 2 : 9;
            }
            return -1;
        }
    }
}

