/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.broad.igv.PreferenceManager;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.legend.LegendPanel;
import org.broad.igv.ui.util.ColorTable;
import org.broad.igv.ui.util.PropertyDialog;
import org.broad.igv.ui.util.PropertyManager;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ColorUtilities;

public class MutationLegendPanel
extends LegendPanel {
    ColorTable colorTable;

    public MutationLegendPanel() {
        this.init();
    }

    private void init() {
        ColorTable prefTable = PreferenceManager.getInstance().getMutationColorScheme();
        this.colorTable = new ColorTable();
        for (String key : prefTable.getKeys()) {
            this.colorTable.put(key, prefTable.get(key));
        }
    }

    @Override
    protected void persistResetPreferences() {
        PreferenceManager.getInstance().setMutationColorScheme(this.colorTable);
    }

    @Override
    protected void reloadPreferences() {
        this.init();
        this.repaint();
    }

    protected ColorScale getColorScale() {
        return null;
    }

    @Override
    protected void resetPreferencesToDefault() {
        this.persistResetPreferences();
        this.showResetDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUserPreferences() {
        IGV.getInstance().setStatusBarMessage("Setting view properties...");
        LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey = this.addPreferences();
        Window window = SwingUtilities.getWindowAncestor(this);
        PropertyDialog dialog = new PropertyDialog((PropertyManager)PreferenceManager.getInstance(), labelTextToKey, (Dialog)window, true);
        Frame parent = IGV.getMainFrame();
        dialog.setLocationRelativeTo(parent);
        dialog.setTitle("Color Preferences");
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            IGV.getInstance().resetStatusMessage();
            return;
        }
        try {
            this.reloadPreferences();
        }
        catch (Throwable throwable) {
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.getWindowAncestor(MutationLegendPanel.this).toFront();
                }
            });
            IGV.getInstance().resetStatusMessage();
            throw throwable;
        }
        UIUtilities.invokeOnEventThread(new /* invalid duplicate definition of identical inner class */);
        IGV.getInstance().resetStatusMessage();
    }

    protected LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> addPreferences() {
        LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey = new LinkedHashMap<String, PropertyDialog.PreferenceDescriptor>();
        this.addIndelColorPreference(labelTextToKey);
        this.addMissenseColorPreference(labelTextToKey);
        this.addNonsenseColorPreference(labelTextToKey);
        this.addSpliceSiteColorPreference(labelTextToKey);
        this.addSynonymousColorPreference(labelTextToKey);
        this.addTargetRegionColorPreference(labelTextToKey);
        this.addUnknownColorPreference(labelTextToKey);
        return labelTextToKey;
    }

    protected void addNonsenseColorPreference(LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey) {
        Color color = this.colorTable.get("Nonsense");
        String labelText = "Nonsense Color: ";
        labelTextToKey.put(labelText, new PropertyDialog.PreferenceDescriptor("MUTATION_NONSENSE_COLOR_KEY", PropertyDialog.PreferenceType.COLOR, ColorUtilities.colorToString(color)));
    }

    protected void addIndelColorPreference(LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey) {
        Color color = this.colorTable.get("Indel");
        String labelText = "Indel Color: ";
        labelTextToKey.put(labelText, new PropertyDialog.PreferenceDescriptor("MUTATION_INDEL_COLOR_KEY", PropertyDialog.PreferenceType.COLOR, ColorUtilities.colorToString(color)));
    }

    protected void addTargetRegionColorPreference(LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey) {
        Color color = this.colorTable.get("Targeted_Region");
        String labelText = "Target Region Color: ";
        labelTextToKey.put(labelText, new PropertyDialog.PreferenceDescriptor("MUTATION_TARGETED_REGION_COLOR_KEY", PropertyDialog.PreferenceType.COLOR, ColorUtilities.colorToString(color)));
    }

    protected void addMissenseColorPreference(LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey) {
        Color color = this.colorTable.get("Missense");
        String labelText = "Missense Color: ";
        labelTextToKey.put(labelText, new PropertyDialog.PreferenceDescriptor("MUTATION_MISSENSE_COLOR_KEY", PropertyDialog.PreferenceType.COLOR, ColorUtilities.colorToString(color)));
    }

    protected void addSpliceSiteColorPreference(LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey) {
        Color color = this.colorTable.get("Splice_site");
        String labelText = "Splice Site Color: ";
        labelTextToKey.put(labelText, new PropertyDialog.PreferenceDescriptor("MUTATION_SPLICE_SITE_COLOR_KEY", PropertyDialog.PreferenceType.COLOR, ColorUtilities.colorToString(color)));
    }

    protected void addSynonymousColorPreference(LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey) {
        Color color = this.colorTable.get("Synonymous");
        String labelText = "Synonymous Color: ";
        labelTextToKey.put(labelText, new PropertyDialog.PreferenceDescriptor("MUTATION_SYNONYMOUS_COLOR_KEY", PropertyDialog.PreferenceType.COLOR, ColorUtilities.colorToString(color)));
    }

    protected void addUnknownColorPreference(LinkedHashMap<String, PropertyDialog.PreferenceDescriptor> labelTextToKey) {
        Color color = this.colorTable.get("Unknown");
        String labelText = "Unknown Color: ";
        labelTextToKey.put(labelText, new PropertyDialog.PreferenceDescriptor("MUTATION_UNKNOWN_COLOR_KEY", PropertyDialog.PreferenceType.COLOR, ColorUtilities.colorToString(color)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintLegend(Graphics g2) {
        if (this.colorTable == null) {
            return;
        }
        Graphics2D g2D = null;
        try {
            int lineHeight;
            g2D = (Graphics2D)g2.create();
            g2D.setFont(FontManager.getFont(10));
            FontMetrics fm = g2D.getFontMetrics();
            int dh = fm.getHeight() / 2 + 3;
            int x = 0;
            int y = lineHeight = 12;
            int colCount = 0;
            for (Map.Entry<String, Color> entry : this.colorTable.entrySet()) {
                String mutType = entry.getKey();
                String label = mutType.replace("_", " ");
                int labelWidth = (int)fm.getStringBounds(label, g2D).getWidth();
                g2D.setColor(entry.getValue());
                g2D.fillRect(x, y, 10, 10);
                g2D.setColor(Color.BLACK);
                g2D.drawRect(x, y, 10, 10);
                g2D.drawString(label, x + 20, y + dh);
                x += labelWidth + 40;
                if (++colCount % 5 != 0) continue;
                y += lineHeight + 5;
                x = 0;
            }
        }
        finally {
            g2D.dispose();
        }
    }
}

