/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import org.broad.igv.feature.Locus;

public class FeatureFileUtils {
    public static void main(String[] args) throws IOException {
        FeatureFileUtils.covertProbeMapToBedFile("/Users/jrobinso/IGV/TestData/expression/HG-U133_PLUS_2.mapping.txt", "/Users/jrobinso/IGV/TestData/expression/HG-U133_PLUS_2.mapping.bed");
    }

    static void covertProbeMapToBedFile(String probeMapFile, String bedFile) throws FileNotFoundException, IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(probeMapFile));
        PrintWriter pw = new PrintWriter(new FileWriter(bedFile));
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            Locus locus = new Locus(tokens[1].trim());
            pw.println(locus.getChr() + "\t" + locus.getStart() + "\t" + locus.getEnd() + "\t" + tokens[0].trim());
        }
        br.close();
        pw.close();
    }

    static void splitEmblFileByType(String emblFile, String outputDirectory) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(emblFile));
        HashSet<String> codes = new HashSet<String>();
        while ((nextLine = br.readLine()) != null) {
            String code;
            if (!nextLine.startsWith("FT") || nextLine.length() <= 19 || (code = nextLine.substring(5, 19).trim()).length() <= 0) continue;
            codes.add(code);
        }
        br.close();
        HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
        for (String code : codes) {
            writers.put(code, new PrintWriter(new FileWriter(new File(outputDirectory, code + ".embl"))));
        }
        br = new BufferedReader(new FileReader(emblFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.startsWith("ID")) {
                for (PrintWriter pw : writers.values()) {
                    pw.println(nextLine);
                }
                continue;
            }
            if (nextLine.startsWith("FT")) {
                String code;
                code = nextLine.substring(5, 19).trim();
                if (code.length() > 0) {
                    currentWriter = (PrintWriter)writers.get(code);
                }
                if (currentWriter == null) continue;
                currentWriter.println(nextLine);
                continue;
            }
            currentWriter = null;
        }
        br.close();
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
    }
}

