/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

public class Segment
implements LocusScore {
    private int extendedStart = -1;
    private int extendedEnd = -1;
    private int start;
    private int end;
    private float score;
    private String description;

    public Segment(int start, int end, float score) {
        this.start = start;
        this.end = end;
        if (this.extendedStart < 0) {
            this.extendedStart = start;
        }
        if (this.extendedEnd < 0) {
            this.extendedEnd = end;
        }
        this.score = score;
    }

    public Segment(int start, int origStart, int end, int origEnd, float value, String description) {
        this.start = start;
        this.end = end;
        this.extendedStart = origStart;
        this.extendedEnd = origEnd;
        this.score = value;
        this.description = description;
    }

    @Override
    public Segment copy() {
        return new Segment(this.start, this.extendedStart, this.end, this.extendedEnd, this.score, this.description);
    }

    @Override
    public String getChr() {
        return null;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public String getValueString(double position, WindowFunction ignored) {
        String valueString = "Value: " + this.getScore();
        if (this.description != null) {
            valueString = valueString + this.description;
        }
        return valueString;
    }

    public String getDescription() {
        return this.description;
    }
}

