/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.analysis.PolynomialFunction;
import org.apache.commons.math.analysis.PolynomialSplineFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealInterpolator;

public class SplineInterpolator
implements UnivariateRealInterpolator {
    public UnivariateRealFunction interpolate(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Dataset arrays must have same length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("At least 3 datapoints are required to compute a spline interpolant");
        }
        int n2 = x.length - 1;
        int i2 = 0;
        while (i2 < n2) {
            if (x[i2] >= x[i2 + 1]) {
                throw new IllegalArgumentException("Dataset x values must be strictly increasing.");
            }
            ++i2;
        }
        double[] h2 = new double[n2];
        int i3 = 0;
        while (i3 < n2) {
            h2[i3] = x[i3 + 1] - x[i3];
            ++i3;
        }
        double[] mu = new double[n2];
        double[] z = new double[n2 + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        double g2 = 0.0;
        int i4 = 1;
        while (i4 < n2) {
            g2 = 2.0 * (x[i4 + 1] - x[i4 - 1]) - h2[i4 - 1] * mu[i4 - 1];
            mu[i4] = h2[i4] / g2;
            z[i4] = (3.0 * (y[i4 + 1] * h2[i4 - 1] - y[i4] * (x[i4 + 1] - x[i4 - 1]) + y[i4 - 1] * h2[i4]) / (h2[i4 - 1] * h2[i4]) - h2[i4 - 1] * z[i4 - 1]) / g2;
            ++i4;
        }
        double[] b2 = new double[n2];
        double[] c2 = new double[n2 + 1];
        double[] d2 = new double[n2];
        z[n2] = 0.0;
        c2[n2] = 0.0;
        int j2 = n2 - 1;
        while (j2 >= 0) {
            c2[j2] = z[j2] - mu[j2] * c2[j2 + 1];
            b2[j2] = (y[j2 + 1] - y[j2]) / h2[j2] - h2[j2] * (c2[j2 + 1] + 2.0 * c2[j2]) / 3.0;
            d2[j2] = (c2[j2 + 1] - c2[j2]) / (3.0 * h2[j2]);
            --j2;
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n2];
        double[] coefficients = new double[4];
        int i5 = 0;
        while (i5 < n2) {
            coefficients[0] = y[i5];
            coefficients[1] = b2[i5];
            coefficients[2] = c2[i5];
            coefficients[3] = d2[i5];
            polynomials[i5] = new PolynomialFunction(coefficients);
            ++i5;
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

