/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.Connection;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SingleByteCharsetConverter {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes;
    private static final Map CONVERTER_MAP;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static byte[] unknownCharsMap;
    private char[] byteToChars = new char[256];
    private byte[] charToByteMap = new byte[65536];

    public static synchronized SingleByteCharsetConverter getInstance(String encodingName, Connection conn) throws UnsupportedEncodingException, SQLException {
        SingleByteCharsetConverter instance = (SingleByteCharsetConverter)CONVERTER_MAP.get(encodingName);
        if (instance == null) {
            instance = SingleByteCharsetConverter.initCharset(encodingName);
        }
        return instance;
    }

    public static SingleByteCharsetConverter initCharset(String javaEncodingName) throws UnsupportedEncodingException, SQLException {
        if (CharsetMapping.isMultibyteCharset(javaEncodingName)) {
            return null;
        }
        SingleByteCharsetConverter converter = new SingleByteCharsetConverter(javaEncodingName);
        CONVERTER_MAP.put(javaEncodingName, converter);
        return converter;
    }

    public static String toStringDefaultEncoding(byte[] buffer, int startPos, int length) {
        return new String(buffer, startPos, length);
    }

    private SingleByteCharsetConverter(String encodingName) throws UnsupportedEncodingException {
        String allBytesString = new String(allBytes, 0, 256, encodingName);
        int allBytesLen = allBytesString.length();
        System.arraycopy(unknownCharsMap, 0, this.charToByteMap, 0, this.charToByteMap.length);
        for (int i2 = 0; i2 < 256 && i2 < allBytesLen; ++i2) {
            char c2;
            this.byteToChars[i2] = c2 = allBytesString.charAt(i2);
            this.charToByteMap[c2] = allBytes[i2];
        }
    }

    public final byte[] toBytes(char[] c2) {
        if (c2 == null) {
            return null;
        }
        int length = c2.length;
        byte[] bytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bytes[i2] = this.charToByteMap[c2[i2]];
        }
        return bytes;
    }

    public final byte[] toBytes(char[] chars, int offset, int length) {
        if (chars == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bytes[i2] = this.charToByteMap[chars[i2 + offset]];
        }
        return bytes;
    }

    public final byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        byte[] bytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bytes[i2] = this.charToByteMap[s.charAt(i2)];
        }
        return bytes;
    }

    public final byte[] toBytes(String s, int offset, int length) {
        if (s == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s.charAt(i2 + offset);
            bytes[i2] = this.charToByteMap[c2];
        }
        return bytes;
    }

    public final String toString(byte[] buffer) {
        return this.toString(buffer, 0, buffer.length);
    }

    public final String toString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        for (int i2 = 0; i2 < length; ++i2) {
            charArray[i2] = this.byteToChars[buffer[readpoint] - -128];
            ++readpoint;
        }
        return new String(charArray);
    }

    static {
        int i2;
        allBytes = new byte[256];
        CONVERTER_MAP = new HashMap();
        EMPTY_BYTE_ARRAY = new byte[0];
        unknownCharsMap = new byte[65536];
        for (i2 = -128; i2 <= 127; ++i2) {
            SingleByteCharsetConverter.allBytes[i2 - -128] = (byte)i2;
        }
        for (i2 = 0; i2 < unknownCharsMap.length; ++i2) {
            SingleByteCharsetConverter.unknownCharsMap[i2] = 63;
        }
    }
}

