/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.ReorderableJList;

public class ReorderPanelsDialog
extends JDialog {
    private boolean canceled = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private ReorderableJList list;
    private JLabel label1;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public ReorderPanelsDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.init();
    }

    public void init() {
        List<TrackPanel> panes = IGV.getInstance().getMainPanel().getTrackPanels();
        ArrayList<Wrapper> wrappers = new ArrayList<Wrapper>(panes.size());
        for (TrackPanel pane : panes) {
            wrappers.add(new Wrapper(pane));
        }
        this.list.setElements(wrappers);
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        ArrayList<String> orderedNames = new ArrayList<String>();
        for (Object obj : this.list.getElements()) {
            Wrapper w = (Wrapper)obj;
            orderedNames.add(w.panelName);
        }
        IGV.getInstance().getMainPanel().reorderPanels(orderedNames);
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.list = new ReorderableJList();
        this.label1 = new JLabel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Reorder Panels");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.scrollPane1.setViewportView(this.list);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.label1.setText("To reorder panels drag and drop entries in the list below.");
        this.contentPanel.add((Component)this.label1, "North");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ReorderPanelsDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ReorderPanelsDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    static class Wrapper {
        String panelName;
        String printName;

        Wrapper(TrackPanel panel) {
            this.panelName = panel.getName();
            StringBuffer buffer = new StringBuffer(50);
            int nChars = 0;
            for (Track track : panel.getTracks()) {
                if (nChars > 0) {
                    buffer.append(", ");
                }
                nChars += track.getName().length();
                buffer.append(track.getName());
            }
            this.printName = buffer.toString();
        }

        public String toString() {
            return this.printName;
        }
    }
}

