/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Collection;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.panel.RegionNavigatorDialog;
import org.broad.igv.ui.util.FileChooser;
import org.broad.igv.ui.util.MessageUtils;

public class RegionsBaseMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(RegionsBaseMenuAction.class);
    IGV mainFrame;

    public RegionsBaseMenuAction(String name, Icon icon, int mnemonic) {
        super(name, icon, mnemonic);
    }

    public final void importExportRegionsOfInterest(Direction direction) {
        File exportRegionDirectory;
        RegionNavigatorDialog navDialog = RegionNavigatorDialog.getActiveInstance();
        if (navDialog != null) {
            navDialog.updateROIsFromRegionTable();
        }
        if ((exportRegionDirectory = PreferenceManager.getInstance().getLastExportedRegionDirectory()) == null) {
            exportRegionDirectory = Globals.getUserDirectory();
        }
        FileChooser exportedRegionFileChooser = new FileChooser(exportRegionDirectory);
        String title = null;
        title = direction == Direction.EXPORT ? "Export Regions of Interest ..." : "Import Regions of Interest ...";
        exportedRegionFileChooser.setDialogTitle(title);
        File file = this.selectExportedRegionsFile(exportedRegionFileChooser, new File("regions.bed"), direction == Direction.EXPORT);
        if (file == null) {
            return;
        }
        if (direction == Direction.EXPORT) {
            this.writeRegionsOfInterestFile(file);
        } else {
            this.readRegionsOfInterestFile(file);
        }
    }

    private void readRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            log.info("A blank Region of Interest import file was supplied!");
            return;
        }
        if (!roiFile.exists()) {
            MessageUtils.showMessage("Region of Interest export file not found!");
            return;
        }
        try {
            BufferedReader reader = null;
            int coordConvention = 0;
            try {
                reader = new BufferedReader(new FileReader(roiFile));
                while (true) {
                    String[] data;
                    String[] tmp;
                    String dataRecord;
                    if ((dataRecord = reader.readLine()) == null) {
                        return;
                    }
                    if (dataRecord.startsWith("track")) continue;
                    if (dataRecord.startsWith("#coords") && (tmp = dataRecord.split("=")).length > 1) {
                        try {
                            coordConvention = Integer.parseInt(tmp[1]);
                        }
                        catch (NumberFormatException e2) {
                            log.error("Error parsing coordinate convention direction for file: " + roiFile);
                        }
                    }
                    if ((data = dataRecord.split("\t")).length < 3) continue;
                    try {
                        String name = data.length > 3 ? data[3] : null;
                        int start = Integer.parseInt(data[1]) - coordConvention;
                        int end = Integer.parseInt(data[2]);
                        RegionOfInterest regionOfInterest = new RegionOfInterest(data[0], start, end, name);
                        this.mainFrame.addRegionOfInterest(regionOfInterest);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                this.mainFrame.doRefresh();
            }
        }
        catch (Exception e3) {
            log.error("Failed to write Region of Interest export file!", e3);
            return;
        }
    }

    private File selectExportedRegionsFile(FileChooser exportedRegionFileChooser, File currentFile, boolean isSave) {
        File directory;
        exportedRegionFileChooser.setSelectedFile(currentFile);
        if (isSave) {
            RegionsBaseMenuAction regionsBaseMenuAction = this;
            exportedRegionFileChooser.showSaveDialog(regionsBaseMenuAction.mainFrame.getMainFrame());
        } else {
            RegionsBaseMenuAction regionsBaseMenuAction = this;
            exportedRegionFileChooser.showOpenDialog(regionsBaseMenuAction.mainFrame.getMainFrame());
        }
        this.mainFrame.resetStatusMessage();
        File file = exportedRegionFileChooser.getSelectedFile();
        if (file != null && (directory = exportedRegionFileChooser.getCurrentDirectory()) != null) {
            PreferenceManager.getInstance().setLastExportedRegionDirectory(directory);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            log.info("A blank Region of Interest export file was supplied!");
            return;
        }
        try {
            Collection<RegionOfInterest> regions = IGV.getInstance().getSession().getAllRegionsOfInterest();
            if (regions == null || regions.isEmpty()) {
                return;
            }
            roiFile.createNewFile();
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(roiFile);
                for (RegionOfInterest regionOfInterest : regions) {
                    Integer regionStart = regionOfInterest.getStart();
                    if (regionStart == null) continue;
                    Integer regionEnd = regionOfInterest.getEnd();
                    if (regionEnd == null) {
                        regionEnd = regionStart;
                    }
                    writer.print(regionOfInterest.getChr());
                    writer.print("\t");
                    writer.print(regionStart);
                    writer.print("\t");
                    writer.print(regionEnd);
                    if (regionOfInterest.getDescription() != null) {
                        writer.print("\t");
                        writer.println(regionOfInterest.getDescription());
                        continue;
                    }
                    writer.println();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e2) {
            log.error("Failed to write Region of Interest export file!", e2);
        }
    }

    protected static enum Direction {
        IMPORT,
        EXPORT;

    }
}

