/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    public static final String LOAD_FROM_DAS = "Load from DAS...";
    public static final String LOAD_FROM_URL = "Load from URL...";
    private IGV mainFrame;

    public LoadFromURLMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load data, features or sample information");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String url;
        JPanel ta = new JPanel();
        ta.setPreferredSize(new Dimension(600, 20));
        if (e2.getActionCommand().equalsIgnoreCase(LOAD_FROM_URL)) {
            String url2 = JOptionPane.showInputDialog(IGV.getMainFrame(), ta, "Enter URL (http or ftp)", 3);
            if (url2 != null && url2.trim().length() > 0) {
                if (url2.endsWith(".xml")) {
                    try {
                        this.mainFrame.doRestoreSession(new URL(url2), null);
                    }
                    catch (Exception ex) {
                        MessageUtils.showMessage("Error loading url: " + url2 + " (" + ex.toString() + ")");
                    }
                } else {
                    ResourceLocator rl = new ResourceLocator(url2.trim());
                    this.mainFrame.loadTracks(Arrays.asList(rl));
                }
            }
        } else if (e2.getActionCommand().equalsIgnoreCase(LOAD_FROM_DAS) && (url = JOptionPane.showInputDialog(IGV.getMainFrame(), ta, "Enter DAS feature source URL", 3)) != null && url.trim().length() > 0) {
            ResourceLocator rl = new ResourceLocator(url.trim());
            rl.setType("das");
            this.mainFrame.loadTracks(Arrays.asList(rl));
        }
    }
}

