/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.PackedFeaturesSpliceJunctions;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.tribble.Feature;

public class PackedFeaturesSpliceJunctions<T extends Feature>
extends PackedFeatures {
    private static Logger log = Logger.getLogger(PackedFeaturesSpliceJunctions.class);

    public PackedFeaturesSpliceJunctions(String chr, int start, int end, Iterator<T> iter, String trackName) {
        super(chr, start, end, iter, trackName);
    }

    @Override
    protected int getFeatureStartForPacking(Feature feature) {
        return ((SpliceJunctionFeature)feature).getJunctionStart();
    }

    @Override
    protected int getFeatureEndForPacking(Feature feature) {
        return ((SpliceJunctionFeature)feature).getJunctionEnd();
    }

    @Override
    int getRowCount() {
        return this.getRows().size();
    }

    @Override
    List<PackedFeatures.FeatureRow> packFeatures(Iterator iter) {
        IteratorSplitterByCharge iterSplitter = new IteratorSplitterByCharge(iter);
        List<PackedFeatures.FeatureRow> posRows = this.packFeaturesOneStrand(iterSplitter.getPosIter());
        List<PackedFeatures.FeatureRow> negativeRows = this.packFeaturesOneStrand(iterSplitter.getNegIter());
        Comparator<Feature> startComparator = new Comparator<Feature>(){

            @Override
            public int compare(Feature row1, Feature row2) {
                return row1.getStart() - row2.getStart();
            }
        };
        int numRows = Math.max(posRows.size(), negativeRows.size());
        ArrayList<PackedFeatures.FeatureRow> result = new ArrayList<PackedFeatures.FeatureRow>(numRows);
        this.features.clear();
        for (int i2 = 0; i2 < numRows; ++i2) {
            ArrayList posAndNegFeatures = new ArrayList();
            if (negativeRows.size() > i2) {
                posAndNegFeatures.addAll(negativeRows.get(i2).getFeatures());
            }
            if (posRows.size() > i2) {
                posAndNegFeatures.addAll(posRows.get(i2).getFeatures());
            }
            if (posAndNegFeatures.isEmpty()) continue;
            Collections.sort(posAndNegFeatures, startComparator);
            PackedFeatures.FeatureRow resultRow = new PackedFeatures.FeatureRow();
            for (Feature feature : posAndNegFeatures) {
                resultRow.addFeature(feature);
            }
            result.add(resultRow);
            this.features.addAll(posAndNegFeatures);
        }
        Collections.sort(this.features, startComparator);
        return result;
    }

    List<PackedFeatures.FeatureRow> packFeaturesOneStrand(Iterator iter) {
        ArrayList<PackedFeatures.FeatureRow> rows = new ArrayList<PackedFeatures.FeatureRow>(10);
        if (iter == null || !iter.hasNext()) {
            return rows;
        }
        this.maxFeatureLength = 0;
        int totalCount = 0;
        LinkedHashMap<Integer, PriorityQueue<BasicFeature>> bucketArray = new LinkedHashMap<Integer, PriorityQueue<BasicFeature>>();
        Comparator<BasicFeature> pqComparator = new Comparator<BasicFeature>(){

            @Override
            public int compare(BasicFeature row1, BasicFeature row2) {
                return (int)(row2.getScore() - row1.getScore());
            }
        };
        while (iter.hasNext()) {
            Feature feature = (Feature)iter.next();
            this.maxFeatureLength = Math.max(this.maxFeatureLength, this.getFeatureEndForPacking(feature) - this.getFeatureStartForPacking(feature));
            this.features.add(feature);
            int bucketNumber = this.getFeatureStartForPacking(feature);
            PriorityQueue<BasicFeature> bucket = (PriorityQueue<BasicFeature>)bucketArray.get(bucketNumber);
            if (bucket == null) {
                bucket = new PriorityQueue<BasicFeature>(5, pqComparator);
                bucketArray.put(bucketNumber, bucket);
            }
            bucket.add((BasicFeature)feature);
            ++totalCount;
        }
        PackedFeatures.FeatureRow currentRow = new PackedFeatures.FeatureRow();
        int allocatedCount = 0;
        int nextStart = currentRow.end + 5;
        int lastKey = 0;
        int lastAllocatedCount = -1;
        while (allocatedCount < totalCount && rows.size() < maxLevels) {
            if (lastAllocatedCount == allocatedCount) {
                String msg = "Infinite loop detected while packing features for track: " + this.getTrackName() + ".<br>Not all features will be shown." + "<br>Please contact igv-help@broadinstitute.org";
                log.error(msg);
                MessageUtils.showMessage(msg);
                break;
            }
            lastAllocatedCount = allocatedCount;
            PriorityQueue bucket = null;
            ArrayList<Integer> emptyBucketKeys = new ArrayList<Integer>();
            for (Integer key : bucketArray.keySet()) {
                lastKey = key;
                if (key < nextStart) continue;
                bucket = (PriorityQueue)bucketArray.get(key);
                Feature feature = (Feature)bucket.poll();
                if (bucket.isEmpty()) {
                    emptyBucketKeys.add(key);
                }
                currentRow.addFeature(feature);
                nextStart = currentRow.end + 5;
                ++allocatedCount;
            }
            for (Integer key : emptyBucketKeys) {
                bucketArray.remove(key);
            }
            if (currentRow.features.size() > 0) {
                rows.add(currentRow);
                lastAllocatedCount = -1;
            }
            currentRow = new PackedFeatures.FeatureRow();
            nextStart = 0;
            lastKey = 0;
        }
        if (currentRow.features.size() > 0) {
            rows.add(currentRow);
        }
        return rows;
    }

    protected class IteratorSplitterByCharge {
        Iterator origIter;
        List<Feature> posBuffer = new ArrayList<Feature>();
        List<Feature> negBuffer = new ArrayList<Feature>();
        org.broad.igv.track.PackedFeaturesSpliceJunctions$IteratorSplitterByCharge.PerStrandIter posIter;
        org.broad.igv.track.PackedFeaturesSpliceJunctions$IteratorSplitterByCharge.PerStrandIter negIter;

        public IteratorSplitterByCharge(Iterator origIter) {
            this.origIter = origIter;
            this.posIter = new PerStrandIter(this.posBuffer, this.negBuffer, Strand.POSITIVE);
            this.negIter = new PerStrandIter(this.negBuffer, this.posBuffer, Strand.NEGATIVE);
        }

        public org.broad.igv.track.PackedFeaturesSpliceJunctions$IteratorSplitterByCharge.PerStrandIter getPosIter() {
            return this.posIter;
        }

        public org.broad.igv.track.PackedFeaturesSpliceJunctions$IteratorSplitterByCharge.PerStrandIter getNegIter() {
            return this.negIter;
        }

        protected class PerStrandIter
        implements Iterator<Feature> {
            List<Feature> buffer;
            List<Feature> otherBuffer;
            Strand strand;

            public PerStrandIter(List<Feature> buffer, List<Feature> otherBuffer, Strand strand) {
                this.buffer = buffer;
                this.otherBuffer = otherBuffer;
                this.strand = strand;
            }

            @Override
            public boolean hasNext() {
                while (this.buffer.isEmpty() && IteratorSplitterByCharge.this.origIter.hasNext()) {
                    BasicFeature feature = (BasicFeature)IteratorSplitterByCharge.this.origIter.next();
                    if (feature.getStrand() == this.strand) {
                        this.buffer.add(feature);
                        continue;
                    }
                    this.otherBuffer.add(feature);
                }
                return !this.buffer.isEmpty();
            }

            @Override
            public Feature next() {
                while (this.buffer.isEmpty() && IteratorSplitterByCharge.this.origIter.hasNext()) {
                    BasicFeature feature = (BasicFeature)IteratorSplitterByCharge.this.origIter.next();
                    if (feature.getStrand() == this.strand) {
                        this.buffer.add(feature);
                        continue;
                    }
                    this.otherBuffer.add(feature);
                }
                if (this.buffer.isEmpty()) {
                    return null;
                }
                Feature result = this.buffer.get(0);
                this.buffer.remove(0);
                return result;
            }

            @Override
            public void remove() {
            }
        }
    }
}

