/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.SamAlignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.IndexNotFoundException;
import org.broad.igv.sam.reader.SamUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class SamQueryTextReader
implements AlignmentQueryReader {
    static Logger log = Logger.getLogger(SamQueryTextReader.class);
    String samFile;
    FeatureIndex featureIndex;
    SAMFileHeader header;

    public SamQueryTextReader(String samFile) throws IOException {
        this(samFile, true);
    }

    public SamQueryTextReader(String samFile, boolean requireIndex) throws IOException {
        this.samFile = samFile;
        this.loadHeader();
        if (requireIndex) {
            this.featureIndex = SamUtils.getIndexFor(samFile);
            if (this.featureIndex == null) {
                throw new IndexNotFoundException(samFile);
            }
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() {
        InputStream is = null;
        SAMFileReader reader = null;
        try {
            is = ParsingUtils.openInputStream(new ResourceLocator(this.samFile));
            BufferedInputStream bis = new BufferedInputStream(is);
            reader = new SAMFileReader(bis);
            this.header = reader.getFileHeader();
        }
        catch (IOException e2) {
            log.error("Error loading header", e2);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        if (this.featureIndex == null) {
            throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
        }
        if (!this.featureIndex.containsChromosome(sequence)) {
            return EmptyAlignmentIterator.getInstance();
        }
        int startAdjustment = contained ? 0 : this.featureIndex.getLongestFeature(sequence);
        int startTileNumber = Math.max(0, start - startAdjustment) / this.featureIndex.getTileWidth();
        FeatureIndex.TileDef seekPos = this.featureIndex.getTileDef(sequence, startTileNumber);
        if (seekPos != null) {
            SeekableStream stream = null;
            try {
                stream = SeekableStreamFactory.getStreamFor(this.samFile);
                stream.seek(seekPos.getStartPosition());
                SAMFileReader reader = new SAMFileReader(stream);
                reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
                SAMRecordIterator iter = reader.iterator();
                return new SAMQueryIterator(sequence, start, end, contained, iter);
            }
            catch (IOException ex) {
                log.error("Error opening sam file", ex);
                throw new RuntimeException("Error opening: " + this.samFile, ex);
            }
        }
        return EmptyAlignmentIterator.getInstance();
    }

    @Override
    public boolean hasIndex() {
        if (this.featureIndex == null) {
            this.getIndex();
        }
        return this.featureIndex != null;
    }

    @Override
    public void close() throws IOException {
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        return this.featureIndex;
    }

    @Override
    public Set<String> getSequenceNames() {
        FeatureIndex idx = this.getIndex();
        if (idx == null) {
            return null;
        }
        return idx.getIndexedChromosomes();
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        try {
            SeekableStream stream = SeekableStreamFactory.getStreamFor(this.samFile);
            SAMFileReader reader = new SAMFileReader(stream);
            reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            SAMRecordIterator iter = reader.iterator();
            return new SAMQueryIterator(iter);
        }
        catch (IOException e2) {
            log.error("Error opening stream: " + this.samFile);
            throw new RuntimeException("Error creating stream for: " + this.samFile, e2);
        }
    }

    class SAMQueryIterator
    implements CloseableIterator<Alignment> {
        String chr;
        int start;
        int end;
        boolean contained;
        SAMRecord currentRecord;
        CloseableIterator<SAMRecord> wrappedIterator;

        public SAMQueryIterator(CloseableIterator<SAMRecord> wrappedIterator) {
            this.chr = null;
            this.wrappedIterator = wrappedIterator;
            this.currentRecord = (SAMRecord)wrappedIterator.next();
        }

        public SAMQueryIterator(String sequence, int start, int end, boolean contained, CloseableIterator<SAMRecord> wrappedIterator) {
            this.chr = sequence;
            this.start = start;
            this.end = end;
            this.contained = contained;
            this.wrappedIterator = wrappedIterator;
            this.advanceToFirstRecord();
        }

        private void advanceToFirstRecord() {
            while (this.wrappedIterator.hasNext()) {
                this.currentRecord = (SAMRecord)this.wrappedIterator.next();
                if (this.currentRecord.getReferenceName().equals(this.chr) && (!this.contained || this.currentRecord.getAlignmentStart() < this.start) && (this.contained || this.currentRecord.getAlignmentEnd() < this.start)) continue;
                break;
            }
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            if (this.chr == null && this.currentRecord != null) {
                return true;
            }
            if (this.currentRecord == null || this.chr != null && !this.chr.equals(this.currentRecord.getReferenceName())) {
                return false;
            }
            return this.contained ? this.currentRecord.getAlignmentEnd() <= this.end : this.currentRecord.getAlignmentStart() <= this.end;
        }

        @Override
        public SamAlignment next() {
            SAMRecord ret = this.currentRecord;
            this.currentRecord = this.wrappedIterator.hasNext() ? (SAMRecord)this.wrappedIterator.next() : null;
            return new SamAlignment(ret);
        }

        @Override
        public void remove() {
        }
    }
}

