/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;

public class SnpFileParser
extends AbstractFeatureParser {
    public SnpFileParser(Genome genome) {
        super(genome);
    }

    @Override
    protected IGVFeature parseLine(String line) throws NumberFormatException {
        String[] tokens = line.replaceAll("\"", "").split("\t");
        int tokenCount = tokens.length;
        int i2 = 0;
        String chr = tokens[i2++];
        int start = Integer.parseInt(tokens[i2++]);
        int end = Integer.parseInt(tokens[i2++]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            String name = tokens[i2++].replaceAll("\"", "");
            feature.setName(name);
        }
        if (tokenCount > 4) {
            float score = Float.parseFloat(tokens[i2++]);
            feature.setScore(score);
        }
        if (tokenCount > 5) {
            String strandString;
            int strand;
            int n2 = strand = (strandString = tokens[i2++].trim()).length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        return feature;
    }
}

