/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.parser.DefaultNumberListHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsHandler;

public class FloatArrayProducer
extends DefaultNumberListHandler
implements PointsHandler {
    protected LinkedList as;
    protected float[] a;
    protected int index;
    protected int count;

    public float[] getFloatArray() {
        return this.a;
    }

    public void startNumberList() throws ParseException {
        this.as = new LinkedList();
        this.a = new float[11];
        this.count = 0;
        this.index = 0;
    }

    public void numberValue(float v) throws ParseException {
        if (this.index == this.a.length) {
            this.as.add(this.a);
            this.a = new float[this.a.length * 2 + 1];
            this.index = 0;
        }
        this.a[this.index++] = v;
        ++this.count;
    }

    public void endNumberList() throws ParseException {
        float[] all = new float[this.count];
        int pos = 0;
        Iterator it = this.as.iterator();
        while (it.hasNext()) {
            float[] b2 = (float[])it.next();
            System.arraycopy(b2, 0, all, pos, b2.length);
            pos += b2.length;
        }
        System.arraycopy(this.a, 0, all, pos, this.index);
        this.as.clear();
        this.a = all;
    }

    public void startPoints() throws ParseException {
        this.startNumberList();
    }

    public void point(float x, float y) throws ParseException {
        this.numberValue(x);
        this.numberValue(y);
    }

    public void endPoints() throws ParseException {
        this.endNumberList();
    }
}

