/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SAMFileReader reader) {
        if (reader.hasBrowseableIndex()) {
            CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.getBrowseableIndex();
            int n_ref = existingIndex.getNumberOfReferences();
            int chunkCount = 0;
            int indexCount = 0;
            for (int i2 = 0; i2 < n_ref; ++i2) {
                BAMIndexContent content = existingIndex.getQueryResults(i2);
                for (Chunk c2 : content.getAllChunks()) {
                    SAMRecordIterator iter = reader.iterator(new BAMFileSpan(c2));
                    ++chunkCount;
                    BAMRecord b2 = null;
                    try {
                        b2 = (BAMRecord)iter.next();
                        iter.close();
                    }
                    catch (Exception e2) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + b2 + " in chunk " + c2 + " chunkCount=" + chunkCount, e2);
                    }
                }
                LinearIndex linearIndex = content.getLinearIndex();
                for (long l2 : linearIndex.getIndexEntries()) {
                    try {
                        if (l2 == 0L) continue;
                        SAMRecordIterator iter = reader.iterator(new BAMFileSpan(new Chunk(l2, l2 + 1L)));
                        BAMRecord b3 = (BAMRecord)iter.next();
                        ++indexCount;
                        iter.close();
                    }
                    catch (Exception e3) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l2 + " indexCount=" + indexCount, e3);
                    }
                }
            }
            return chunkCount;
        }
        return 0;
    }
}

