/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.util.Random;

public class CharArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final char[] EMPTY_ARRAY = new char[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 2;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private CharArrays() {
    }

    public static char[] ensureCapacity(char[] array, int length) {
        if (length > array.length) {
            char[] t = new char[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static char[] ensureCapacity(char[] array, int length, int preserve) {
        if (length > array.length) {
            char[] t = new char[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static char[] grow(char[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            char[] t = new char[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static char[] grow(char[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            char[] t = new char[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static char[] trim(char[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        char[] t = length == 0 ? EMPTY_ARRAY : new char[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static char[] setLength(char[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return CharArrays.trim(array, length);
        }
        return CharArrays.ensureCapacity(array, length);
    }

    public static char[] copy(char[] array, int offset, int length) {
        CharArrays.ensureOffsetLength(array, offset, length);
        char[] a2 = length == 0 ? EMPTY_ARRAY : new char[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static char[] copy(char[] array) {
        return (char[])array.clone();
    }

    public static void fill(char[] array, char value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(char[] array, int from, int to, char value) {
        CharArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static boolean equals(char[] a1, char[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(char[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(char[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(char[] x, int a2, int b2) {
        char t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    private static void vecSwap(char[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            CharArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(char[] x, int a2, int b2, int c2, CharComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(char[] a2, int from, int to, CharComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (comp.compare(a2[j2], a2[m2]) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            char u = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u;
        }
    }

    private static void insertionSort(char[] a2, int from, int to, CharComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            char t = a2[i2];
            int j2 = i2;
            char u = a2[j2 - 1];
            while (comp.compare(t, u) < 0) {
                a2[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = a2[--j2 - 1];
            }
            a2[j2] = t;
        }
    }

    private static void selectionSort(char[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2]) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            char u = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u;
        }
    }

    private static void insertionSort(char[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            char t = a2[i2];
            int j2 = i2;
            char u = a2[j2 - 1];
            while (t < u) {
                a2[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = a2[--j2 - 1];
            }
            a2[j2] = t;
        }
    }

    public static void quickSort(char[] x, int from, int to, CharComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            CharArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s = len / 8;
                l2 = CharArrays.med3(x, l2, l2 + s, l2 + 2 * s, comp);
                m2 = CharArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = CharArrays.med3(x, n2 - 2 * s, n2 - s, n2, comp);
            }
            m2 = CharArrays.med3(x, l2, m2, n2, comp);
        }
        char v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            CharArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        CharArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        CharArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            CharArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1) {
            CharArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    public static void quickSort(char[] x, CharComparator comp) {
        CharArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(char[] x, int a2, int b2, int c2) {
        int bc;
        int ac;
        int ab;
        int n2 = x[a2] < x[b2] ? -1 : (ab = x[a2] == x[b2] ? 0 : 1);
        int n3 = x[a2] < x[c2] ? -1 : (ac = x[a2] == x[c2] ? 0 : 1);
        int n4 = x[b2] < x[c2] ? -1 : (bc = x[b2] == x[c2] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(char[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            CharArrays.selectionSort(x, from, to);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s = len / 8;
                l2 = CharArrays.med3(x, l2, l2 + s, l2 + 2 * s);
                m2 = CharArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = CharArrays.med3(x, n2 - 2 * s, n2 - s, n2);
            }
            m2 = CharArrays.med3(x, l2, m2, n2);
        }
        char v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (x[b2] < v ? -1 : (comparison = x[b2] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (x[c2] < v ? -1 : (comparison = x[c2] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    CharArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            CharArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        CharArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        CharArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            CharArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            CharArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(char[] x) {
        CharArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(char[] a2, int from, int to, char[] supp) {
        int len = to - from;
        if (len < 7) {
            CharArrays.insertionSort(a2, from, to);
            return;
        }
        int mid = from + to >>> 1;
        CharArrays.mergeSort(supp, from, mid, a2);
        CharArrays.mergeSort(supp, mid, to, a2);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q >= to || p2 < mid && supp[p2] <= supp[q] ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(char[] a2, int from, int to) {
        CharArrays.mergeSort(a2, from, to, (char[])a2.clone());
    }

    public static void mergeSort(char[] a2) {
        CharArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(char[] a2, int from, int to, CharComparator comp, char[] supp) {
        int len = to - from;
        if (len < 7) {
            CharArrays.insertionSort(a2, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        CharArrays.mergeSort(supp, from, mid, comp, a2);
        CharArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q >= to || p2 < mid && comp.compare(supp[p2], supp[q]) <= 0 ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(char[] a2, int from, int to, CharComparator comp) {
        CharArrays.mergeSort(a2, from, to, comp, (char[])a2.clone());
    }

    public static void mergeSort(char[] a2, CharComparator comp) {
        CharArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(char[] a2, int from, int to, char key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            char midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(char[] a2, char key) {
        return CharArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(char[] a2, int from, int to, char key, CharComparator c2) {
        while (from <= to) {
            int mid = from + to >>> 1;
            char midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(char[] a2, char key, CharComparator c2) {
        return CharArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    public static void radixSort(char[] a2) {
        CharArrays.radixSort(a2, 0, a2.length);
    }

    public static void radixSort(char[] a2, int from, int to) {
        boolean maxLevel = true;
        int stackSize = 256;
        int[] offsetStack = new int[256];
        int offsetPos = 0;
        int[] lengthStack = new int[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2.length];
        while (offsetPos > 0) {
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.selectionSort(a2, first, first + length);
                continue;
            }
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(a2[first + i2] >>> shift & 0xFF ^ 0);
            }
            i2 = length;
            while (i2-- != 0) {
                int n2 = digit[first + i2] & 0xFF;
                count[n2] = count[n2] + 1;
            }
            int lastUsed = -1;
            int p2 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 1 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                char t = a2[i4];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n3 = c2;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d2 = n4;
                    if (n4 <= i4) break;
                    char z = t;
                    int zz = c2;
                    t = a2[d2];
                    c2 = digit[d2] & 0xFF;
                    a2[d2] = z;
                    digit[d2] = (byte)zz;
                }
                a2[i4] = t;
                count[c2] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, char[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j2 = i2;
            int u = perm[j2 - 1];
            while (a2[t] < a2[u]) {
                perm[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = perm[--j2 - 1];
            }
            perm[j2] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, char[] a2, boolean stable) {
        CharArrays.radixSortIndirect(perm, a2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, char[] a2, int from, int to, boolean stable) {
        boolean maxLevel = true;
        int stackSize = 256;
        int[] offsetStack = new int[256];
        int offsetPos = 0;
        int[] lengthStack = new int[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[perm.length];
        while (offsetPos > 0) {
            int i2;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.insertionSortIndirect(perm, a2, first, first + length);
                continue;
            }
            int shift = (1 - level % 2) * 8;
            int i3 = length;
            while (i3-- != 0) {
                digit[i3] = (byte)(a2[perm[first + i3]] >>> shift & 0xFF ^ 0);
            }
            i3 = length;
            while (i3-- != 0) {
                int n2 = digit[i3] & 0xFF;
                count[n2] = count[n2] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 1 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i2] = p2 += count[i2];
                    continue;
                }
                pos[i2] = p2 += count[i2];
            }
            if (stable) {
                i2 = length;
                while (i2-- != 0) {
                    int n3 = digit[i2] & 0xFF;
                    int n4 = count[n3] - 1;
                    count[n3] = n4;
                    support[n4] = perm[first + i2];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t = perm[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n5 = c2;
                    int n6 = pos[n5] - 1;
                    pos[n5] = n6;
                    int d2 = n6;
                    if (n6 <= i4) break;
                    int z = t;
                    int zz = c2;
                    t = perm[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    perm[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                perm[i4 + first] = t;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(char[] a2, char[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2] && (a2[j2] != a2[m2] || b2[j2] >= b2[m2])) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            char t = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = t;
            t = b2[i2];
            b2[i2] = b2[m2];
            b2[m2] = t;
        }
    }

    public static void radixSort(char[] a2, char[] b2) {
        CharArrays.radixSort(a2, b2, 0, a2.length);
    }

    public static void radixSort(char[] a2, char[] b2, int from, int to) {
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2.length];
        while (offsetPos > 0) {
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.selectionSort(a2, b2, first, first + length);
                continue;
            }
            char[] k2 = level < 2 ? a2 : b2;
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ 0);
            }
            i2 = length;
            while (i2-- != 0) {
                int n2 = digit[first + i2] & 0xFF;
                count[n2] = count[n2] + 1;
            }
            int lastUsed = -1;
            int p2 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 3 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                char t = a2[i4];
                char u = b2[i4];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n3 = c2;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d2 = n4;
                    if (n4 <= i4) break;
                    char z = t;
                    int zz = c2;
                    t = a2[d2];
                    a2[d2] = z;
                    z = u;
                    u = b2[d2];
                    b2[d2] = z;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                a2[i4] = t;
                b2[i4] = u;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(char[][] a2, int from, int to, int level) {
        int layers = a2.length;
        int firstLayer = level / 2;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            block1: for (int j2 = i2 + 1; j2 < to; ++j2) {
                for (int p2 = firstLayer; p2 < layers; ++p2) {
                    if (a2[p2][j2] < a2[p2][m2]) {
                        m2 = j2;
                        continue block1;
                    }
                    if (a2[p2][j2] > a2[p2][m2]) continue block1;
                }
            }
            if (m2 == i2) continue;
            int p3 = layers;
            while (p3-- != 0) {
                char u = a2[p3][i2];
                a2[p3][i2] = a2[p3][m2];
                a2[p3][m2] = u;
            }
        }
    }

    public static void radixSort(char[][] a2) {
        CharArrays.radixSort(a2, 0, a2[0].length);
    }

    public static void radixSort(char[][] a2, int from, int to) {
        int layers = a2.length;
        int maxLevel = 2 * layers - 1;
        int p2 = layers;
        int l2 = a2[0].length;
        while (p2-- != 0) {
            if (a2[p2].length == l2) continue;
            throw new IllegalArgumentException("The array of index " + p2 + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 2 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2[0].length];
        char[] t = new char[layers];
        while (offsetPos > 0) {
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int level = levelStack[--levelPos];
            boolean signMask = false;
            if (length < 50) {
                CharArrays.selectionSort(a2, first, first + length, level);
                continue;
            }
            char[] k2 = a2[level / 2];
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ 0);
            }
            i2 = length;
            while (i2-- != 0) {
                int n2 = digit[first + i2] & 0xFF;
                count[n2] = count[n2] + 1;
            }
            int lastUsed = -1;
            int p3 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < maxLevel && count[i3] > 1) {
                        offsetStack[offsetPos++] = p3;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p3 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                int p4 = layers;
                while (p4-- != 0) {
                    t[p4] = a2[p4][i4];
                }
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n3 = c2;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d2 = n4;
                    if (n4 <= i4) break;
                    p4 = layers;
                    while (p4-- != 0) {
                        char u = t[p4];
                        t[p4] = a2[p4][d2];
                        a2[p4][d2] = u;
                    }
                    int zz = c2;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                p4 = layers;
                while (p4-- != 0) {
                    a2[p4][i4] = t[p4];
                }
                count[c2] = 0;
            }
        }
    }

    public static char[] shuffle(char[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            char t = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t;
        }
        return a2;
    }

    public static char[] shuffle(char[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            char t = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t;
        }
        return a2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<char[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(char[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(char[] a2, char[] b2) {
            return CharArrays.equals(a2, b2);
        }
    }
}

