/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentRunner<T>
extends Runner
implements Filterable,
Sortable {
    private final TestClass fTestClass;
    private Filter fFilter = null;
    private Sorter fSorter = Sorter.NULL;

    protected ParentRunner(Class<?> testClass) throws InitializationError {
        this.fTestClass = new TestClass(testClass);
        this.validate();
    }

    protected abstract List<T> getChildren();

    protected abstract Description describeChild(T var1);

    protected abstract void runChild(T var1, RunNotifier var2);

    protected void collectInitializationErrors(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, errors);
        this.validatePublicVoidNoArgMethods(AfterClass.class, true, errors);
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List<FrameworkMethod> methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoidNoArg(isStatic, errors);
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = this.childrenInvoker(notifier);
        statement = this.withBeforeClasses(statement);
        statement = this.withAfterClasses(statement);
        return statement;
    }

    protected Statement withBeforeClasses(Statement statement) {
        List<FrameworkMethod> befores = this.fTestClass.getAnnotatedMethods(BeforeClass.class);
        statement = new RunBefores(statement, befores, null);
        return statement;
    }

    protected Statement withAfterClasses(Statement statement) {
        List<FrameworkMethod> afters = this.fTestClass.getAnnotatedMethods(AfterClass.class);
        statement = new RunAfters(statement, afters, null);
        return statement;
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                ParentRunner.this.runChildren(notifier);
            }
        };
    }

    private void runChildren(RunNotifier notifier) {
        for (T each : this.getFilteredChildren()) {
            this.runChild(each, notifier);
        }
    }

    protected String getName() {
        return this.fTestClass.getName();
    }

    protected final TestClass getTestClass() {
        return this.fTestClass;
    }

    @Override
    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.getName(), this.fTestClass.getAnnotations());
        for (T child : this.getFilteredChildren()) {
            description.addChild(this.describeChild(child));
        }
        return description;
    }

    @Override
    public void run(RunNotifier notifier) {
        EachTestNotifier testNotifier = new EachTestNotifier(notifier, this.getDescription());
        try {
            Statement statement = this.classBlock(notifier);
            statement.evaluate();
        }
        catch (AssumptionViolatedException e2) {
            testNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException e3) {
            throw e3;
        }
        catch (Throwable e4) {
            testNotifier.addFailure(e4);
        }
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        this.fFilter = filter;
        for (T each : this.getChildren()) {
            if (!this.shouldRun(each)) continue;
            return;
        }
        throw new NoTestsRemainException();
    }

    @Override
    public void sort(Sorter sorter) {
        this.fSorter = sorter;
    }

    private void validate() throws InitializationError {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.collectInitializationErrors(errors);
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private List<T> getFilteredChildren() {
        ArrayList<T> filtered = new ArrayList<T>();
        for (T each : this.getChildren()) {
            if (!this.shouldRun(each)) continue;
            try {
                this.filterChild(each);
                this.sortChild(each);
                filtered.add(each);
            }
            catch (NoTestsRemainException e2) {}
        }
        Collections.sort(filtered, this.comparator());
        return filtered;
    }

    private void sortChild(T child) {
        this.fSorter.apply(child);
    }

    private void filterChild(T child) throws NoTestsRemainException {
        if (this.fFilter != null) {
            this.fFilter.apply(child);
        }
    }

    private boolean shouldRun(T each) {
        return this.fFilter == null || this.fFilter.shouldRun(this.describeChild(each));
    }

    private Comparator<? super T> comparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ParentRunner.this.fSorter.compare(ParentRunner.this.describeChild(o1), ParentRunner.this.describeChild(o2));
            }
        };
    }
}

