/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util.variantcontext;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.Genotype;
import org.broad.tribble.util.variantcontext.VariantContext;

public class MutableVariantContext
extends VariantContext {
    public MutableVariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Collection<Genotype> genotypes, double negLog10PError, Set<String> filters, Map<String, ?> attributes) {
        super(source, contig, start, stop, alleles, genotypes, negLog10PError, filters, attributes);
    }

    public MutableVariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Map<String, Genotype> genotypes, double negLog10PError, Set<String> filters, Map<String, ?> attributes) {
        super(source, contig, start, stop, alleles, genotypes, negLog10PError, filters, attributes);
    }

    public MutableVariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles) {
        this(source, contig, start, stop, alleles, NO_GENOTYPES, -1.0, null, null);
    }

    public MutableVariantContext(String source, String contig, long start, long stop, Collection<Allele> alleles, Collection<Genotype> genotypes) {
        this(source, contig, start, stop, alleles, genotypes, -1.0, null, null);
    }

    public MutableVariantContext(VariantContext parent) {
        this(parent.getSource(), parent.contig, parent.start, parent.stop, parent.getAlleles(), parent.getGenotypes(), parent.getNegLog10PError(), parent.getFilters(), parent.getAttributes());
    }

    public void setAlleles(Collection<Allele> alleles) {
        this.alleles.clear();
        for (Allele a2 : alleles) {
            this.addAllele(a2);
        }
    }

    public void addAllele(Allele allele) {
        boolean allowDuplicates = false;
        this.type = null;
        for (Allele a2 : this.alleles) {
            if (!a2.basesMatch(allele)) continue;
            throw new IllegalArgumentException("Duplicate allele added to VariantContext" + this);
        }
        this.alleles.add(allele);
    }

    public void clearGenotypes() {
        this.genotypes = new TreeMap();
    }

    public void addGenotypes(Genotype genotype) {
        this.putGenotype(genotype.getSampleName(), genotype, false);
    }

    public void addGenotypes(Collection<Genotype> genotypes) {
        for (Genotype g2 : genotypes) {
            this.addGenotype(g2);
        }
    }

    public void addGenotypes(Map<String, Genotype> genotypes) {
        for (Map.Entry<String, Genotype> elt : genotypes.entrySet()) {
            this.addGenotype(elt.getValue());
        }
    }

    public void putGenotypes(Map<String, Genotype> genotypes) {
        for (Map.Entry<String, Genotype> g2 : genotypes.entrySet()) {
            this.putGenotype(g2.getKey(), g2.getValue());
        }
    }

    public void putGenotypes(Collection<Genotype> genotypes) {
        for (Genotype g2 : genotypes) {
            this.putGenotype(g2);
        }
    }

    public void addGenotype(Genotype genotype) {
        this.addGenotype(genotype.getSampleName(), genotype);
    }

    public void addGenotype(String sampleName, Genotype genotype) {
        this.putGenotype(sampleName, genotype, false);
    }

    public void putGenotype(Genotype genotype) {
        this.putGenotype(genotype.getSampleName(), genotype);
    }

    public void putGenotype(String sampleName, Genotype genotype) {
        this.putGenotype(sampleName, genotype, true);
    }

    private void putGenotype(String sampleName, Genotype genotype, boolean allowOverwrites) {
        if (this.hasGenotype(sampleName) && !allowOverwrites) {
            throw new IllegalStateException("Attempting to overwrite sample->genotype binding: " + sampleName + " this=" + this);
        }
        if (!sampleName.equals(genotype.getSampleName())) {
            throw new IllegalStateException("Sample name doesn't equal genotype.getSample(): " + sampleName + " genotype=" + genotype);
        }
        this.genotypes.put(sampleName, genotype);
    }

    public void removeGenotype(String sampleName) {
        if (!this.genotypes.containsKey(sampleName)) {
            throw new IllegalArgumentException("Sample name isn't contained in genotypes " + sampleName + " genotypes =" + this.genotypes);
        }
        this.genotypes.remove(sampleName);
    }

    public void removeGenotype(Genotype genotype) {
        this.removeGenotype(genotype.getSampleName());
    }

    public void setSource(String source) {
        this.commonInfo.setName(source);
    }

    public void addFilter(String filter) {
        this.commonInfo.addFilter(filter);
    }

    public void addFilters(Collection<String> filters) {
        this.commonInfo.addFilters(filters);
    }

    public void clearFilters() {
        this.commonInfo.clearFilters();
    }

    public void setFilters(Collection<String> filters) {
        this.commonInfo.setFilters(filters);
    }

    public void setAttributes(Map<String, ?> map) {
        this.commonInfo.setAttributes(map);
    }

    public void clearAttributes() {
        this.commonInfo.clearAttributes();
    }

    public void putAttribute(String key, Object value) {
        this.commonInfo.putAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this.commonInfo.removeAttribute(key);
    }

    public void putAttributes(Map<String, ?> map) {
        this.commonInfo.putAttributes(map);
    }

    public void setNegLog10PError(double negLog10PError) {
        this.commonInfo.setNegLog10PError(negLog10PError);
    }

    public void putAttribute(String key, Object value, boolean allowOverwrites) {
        this.commonInfo.putAttribute(key, value, allowOverwrites);
    }

    public void setID(String id) {
        this.putAttribute("ID", id, true);
    }
}

