/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import org.broad.igv.util.CompressionUtils;
import org.junit.Assert;
import org.junit.Test;

public class CompressionUtilsTest {
    @Test
    public void testCompression() {
        int sz = 1000000;
        byte[] uncompressedBytes = new byte[sz];
        for (int i2 = 0; i2 < sz; ++i2) {
            uncompressedBytes[i2] = (byte)(Math.sin(i2) * 100.0);
        }
        byte[] compressedBytes = CompressionUtils.compress(uncompressedBytes);
        byte[] result = CompressionUtils.decompress(compressedBytes);
        Assert.assertEquals(uncompressedBytes.length, result.length);
        for (int i3 = 0; i3 < result.length; ++i3) {
            Assert.assertEquals(uncompressedBytes[i3], result[i3]);
        }
    }

    @Test
    public void testCompressionChunked() {
        int i2;
        int sz = 1000000;
        byte[] uncompressedBytes = new byte[sz];
        for (int i3 = 0; i3 < sz; ++i3) {
            uncompressedBytes[i3] = (byte)(Math.sin(i3) * 100.0);
        }
        int chunkSize = 32000;
        byte[] compressedBytes = CompressionUtils.compress(uncompressedBytes, chunkSize);
        byte[] result = CompressionUtils.decompress(compressedBytes, chunkSize - 1000);
        Assert.assertEquals(uncompressedBytes.length, result.length);
        for (i2 = 0; i2 < result.length; ++i2) {
            Assert.assertEquals(uncompressedBytes[i2], result[i2]);
        }
        result = CompressionUtils.decompress(compressedBytes, chunkSize + 1000);
        Assert.assertEquals(uncompressedBytes.length, result.length);
        for (i2 = 0; i2 < result.length; ++i2) {
            Assert.assertEquals(uncompressedBytes[i2], result[i2]);
        }
    }
}

