/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.util.ChromosomeColors;

public class ChromosomeColorLegend
extends JPanel {
    public ChromosomeColorLegend() {
        this.setSize(480, 24);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 24);
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.paintLegend(g2);
    }

    public void paintLegend(Graphics g2) {
        Graphics textGraphics = g2.create();
        textGraphics.setColor(Color.black);
        textGraphics.setFont(FontManager.getFont(10));
        int w = this.getWidth() / 24;
        int h2 = this.getHeight() / 2;
        int x = 0;
        for (int i2 = 1; i2 <= 24; ++i2) {
            String chr = i2 < 23 ? "chr" + i2 : (i2 == 23 ? "chrX" : "chrY");
            Color c2 = ChromosomeColors.getColor(chr);
            g2.setColor(c2);
            g2.fillRect(x, 0, w, h2);
            String tmp = i2 < 23 ? String.valueOf(i2) : (i2 == 23 ? "X" : "Y");
            GraphicUtils.drawCenteredText(tmp, x, h2, w, h2, textGraphics);
            x += w;
        }
    }
}

