/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.BEDFileParser;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.SamUtils;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.tribble.Feature;

public class IndexedBEDFeatureSource
implements FeatureSource {
    static Logger log = Logger.getLogger(IndexedBEDFeatureSource.class);
    File bedFile;
    FeatureIndex featureIndex;
    BEDFileParser parser;
    HashMap<String, String> chrMappings = new HashMap();

    public IndexedBEDFeatureSource(File samFile, File indexFile, Genome genome) {
        this.bedFile = samFile;
        if (indexFile.exists()) {
            this.featureIndex = new FeatureIndex(indexFile);
        }
        this.parser = new BEDFileParser(genome);
        this.initChrMap();
    }

    private void initChrMap() {
        Set<String> seqNames;
        Genome genome;
        if (this.featureIndex != null && (genome = IGV.getInstance().getGenomeManager().getCurrentGenome()) != null && (seqNames = this.featureIndex.getIndexedChromosomes()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    @Override
    public Class getFeatureClass() {
        return IGVFeature.class;
    }

    public Iterator<Feature> getFeatures(String chr, int start, int end) {
        return this.loadFeatures(chr, start, end).iterator();
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int i2, int i1, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return 0;
    }

    @Override
    public void setFeatureWindowSize(int size) {
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.bedFile.getAbsolutePath());
        }
        return this.featureIndex;
    }

    public Set<String> getSequenceNames() {
        FeatureIndex idx = this.getIndex();
        if (idx == null) {
            return null;
        }
        return idx.getIndexedChromosomes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Feature> loadFeatures(String chr, int start, int end) {
        ArrayList<Feature> features;
        block20: {
            String chrAlias;
            features = new ArrayList<Feature>();
            if (this.featureIndex == null) {
                this.featureIndex = SamUtils.getIndexFor(this.bedFile.getAbsolutePath());
            }
            if (this.featureIndex == null) {
                throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
            }
            String string = chrAlias = this.chrMappings.containsKey(chr) ? this.chrMappings.get(chr) : chr;
            if (!this.featureIndex.containsChromosome(chrAlias)) {
                return features;
            }
            WaitCursorManager.CursorToken ct = WaitCursorManager.showWaitCursor();
            try {
                int startAdjustment = this.featureIndex.getLongestFeature(chrAlias);
                int startTileNumber = Math.max(0, start - startAdjustment) / this.featureIndex.getTileWidth();
                FeatureIndex.TileDef seekPos = this.featureIndex.getTileDef(chrAlias, startTileNumber);
                if (seekPos == null) break block20;
                FileInputStream is = null;
                try {
                    String[] tokens;
                    BasicFeature f2;
                    is = new FileInputStream(this.bedFile);
                    is.getChannel().position(seekPos.getStartPosition());
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String nextLine = "";
                    while ((nextLine = br.readLine()) != null && (f2 = this.parser.parseLine(tokens = nextLine.split("\t"), tokens.length)).getStart() <= end) {
                        if (!f2.getChr().equals(chrAlias)) {
                            break;
                        }
                        if (f2.getEnd() < start) continue;
                        features.add(f2);
                    }
                }
                catch (IOException ex) {
                    log.error("Error opening sam file", ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {}
                    }
                }
            }
            finally {
                WaitCursorManager.removeWaitCursor(ct);
            }
        }
        return features;
    }

    public boolean hasIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.bedFile.getAbsolutePath());
        }
        return this.featureIndex != null;
    }
}

