/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.broad.igv.util.IGVHttpUtils;

public class HTTPConnectionTests {
    public static void main(String[] args) throws IOException {
        HTTPConnectionTests.getContentLength();
    }

    public static int getContentLength() throws IOException {
        URL url = new URL("http://www.broadinstitute.org/igv/resources/dataServerRegistry.txt");
        HttpURLConnection connection = IGVHttpUtils.openConnection(url);
        connection.setRequestMethod("HEAD");
        connection.connect();
        int len = connection.getContentLength();
        connection.disconnect();
        return len;
    }

    public static void dumpHeaderFields() throws IOException {
        URL url = new URL("http://www.broadinstitute.org/igv/resources/dataServerRegistry.txt");
        HttpURLConnection connection = IGVHttpUtils.openConnection(url);
        connection.setRequestMethod("HEAD");
        connection.connect();
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.print(entry.getKey() + ":\t");
            for (String v : entry.getValue()) {
                System.out.print(v + " ");
            }
            System.out.println();
        }
        connection.disconnect();
    }

    public static void getByteRange() throws IOException {
        char b2;
        int len = HTTPConnectionTests.getContentLength();
        URL url = new URL("http://www.broadinstitute.org/igv/resources/dataServerRegistry.txt");
        HttpURLConnection connection = IGVHttpUtils.openConnection(url);
        connection.setRequestMethod("POST");
        String byteRange = "bytes=" + (len - 10) + "-" + (len - 1);
        System.out.println(byteRange);
        connection.setRequestProperty("Range", byteRange);
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.print(entry.getKey() + ":\t");
            for (String v : entry.getValue()) {
                System.out.print(v + " ");
            }
            System.out.println();
        }
        InputStream is = connection.getInputStream();
        for (int n2 = 0; (b2 = (char)is.read()) >= '\u0000' && n2 < 9; ++n2) {
            System.out.print(b2);
        }
        connection.disconnect();
    }
}

