/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MAFAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MAFIO;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import edu.mit.broad.prodinfo.sequence.Sequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReadTest {
    public static void main(String[] args) throws Exception {
        String in = "/Users/jrobinso/IGV/MAF/chr21.maf";
        ReadTest.nullRegionTest(in);
    }

    static void nullRegionTest(String in) throws Exception {
        int start = 4491000;
        int end = 4491101;
        List<String> species = Arrays.asList("hg18", "gorGor1");
        MAFAlignment maf = new MAFIO().load(in, species, start, end);
        System.out.println(maf.getAlignedSequences().size());
        for (String s : maf.getAlignedSequenceIds()) {
            System.out.println(s);
        }
    }

    static void gapTest(String in) throws IOException, ParseException {
        int start = 21578359;
        int end = 21578365;
        List<String> species = Arrays.asList("hg18", "gorGor1");
        MAFAlignment maf = new MAFIO().load(in, species, start, end);
        MultipleAlignment.AlignedSequence refSeq = maf.getAlignedSequence("hg18");
        MultipleAlignment.AlignedSequence gorSeq = maf.getAlignedSequence("gorGor1");
        System.out.println(refSeq.getSequenceBases());
        System.out.println(gorSeq.getSequenceBases());
        for (int pos = start; pos < end; ++pos) {
            int refIdx = pos - start;
            int refGapAdjustedCoord = refSeq.getGapAdjustedCoordinate(refIdx);
            char refBase = refSeq.getSequenceBases().charAt(refGapAdjustedCoord);
            char alignedBase = gorSeq.getSequenceBases().charAt(refGapAdjustedCoord);
            System.out.println(pos + "\t" + refGapAdjustedCoord + "\t" + refBase + "\t" + alignedBase);
        }
        System.out.println();
    }

    private static void loadRockHyrax(String in) throws IOException, ParseException {
        MAFIO mafio = new MAFIO();
        List<String> seqToLoad = Arrays.asList("hg18", "proCap1");
        int start = 33844862;
        int end = 33844908;
        MAFAlignment maf = mafio.load(in, seqToLoad, start, end);
        MultipleAlignment.AlignedSequence refSeq = maf.getAlignedSequence("hg18");
        MultipleAlignment.AlignedSequence seq = maf.getAlignedSequence("proCap1");
        System.out.println(seq.getSequenceBases());
        for (int pos = start; pos < end; ++pos) {
            int refIdx = pos - start;
            int gapAdjustedCoordinate = seq.getGapAdjustedCoordinate(refIdx);
            char refBase = refSeq.getSequenceBases().charAt(refIdx);
            char alignedBase = seq.getSequenceBases().charAt(gapAdjustedCoordinate);
            System.out.println(pos + " " + refBase + " " + alignedBase);
        }
        System.out.println();
    }

    private static void load(String in) throws ParseException, IOException {
        int i2;
        int start = 39511925;
        int end = 39511940;
        MAFIO mafio = new MAFIO();
        ArrayList<String> seqToLoad = new ArrayList<String>();
        seqToLoad.add("hg18");
        seqToLoad.add("anoCar1");
        MAFAlignment maf = mafio.load(in, seqToLoad, start, end);
        maf.load(in, 39511950, 39511999);
        List<MultipleAlignment.AlignedSequence> sequences = maf.getAlignedSequences();
        System.out.println("Ref start = " + maf.getReferenceStart());
        MultipleAlignment.AlignedSequence seq0 = sequences.get(0);
        for (Integer i3 : seq0.getGapSizes()) {
            System.out.print(i3 + " ");
        }
        System.out.println();
        System.out.println("Ungapped length = " + seq0.getUngappedLength());
        System.out.println("Seq length = " + seq0.getLength());
        System.out.println("Seq size =" + seq0.getSequenceBases().length());
        System.out.println("Gap=" + seq0.getGapsSize() + "\t");
        for (i2 = 0; i2 < seq0.getLength(); ++i2) {
            System.out.print(seq0.getGapAdjustedCoordinate(i2) + " ");
        }
        System.out.println();
        for (i2 = 0; i2 < seq0.getLength(); ++i2) {
            System.out.print(seq0.getSequencePosition(i2) + " ");
        }
        System.out.println();
        for (MultipleAlignment.AlignedSequence sequence : sequences) {
            Sequence seq = sequence.getSequence();
            System.out.println("Start = " + sequence.getStart());
            for (int i4 = 0; i4 < seq.getSequenceBases().length(); ++i4) {
                System.out.print(seq0.getGapAdjustedCoordinate(i4) + " ");
            }
            System.out.println();
            System.out.print(sequence.getId() + "\t");
            System.out.println(seq.getSequenceBases());
        }
    }
}

