/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.remote.SequenceServletWrapper;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ObjectCache;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;
import org.broad.tribble.util.SeekableStream;

public class SequenceManager {
    private static Logger log = Logger.getLogger(SequenceManager.class);
    private static boolean cacheSequences = true;
    private static int chunkSize = 30000;
    private static ObjectCache<String, SequenceChunk> sequenceCache = new ObjectCache(50);
    private static Map<String, String> chrFileNameCache = new HashMap<String, String>();
    private static Hashtable<String, String> sequenceUrlCache = new Hashtable();

    public static byte[] readCSSequence(String genome, String chr, int start, int end) {
        int i2;
        int c1;
        int csStart = start == 0 ? 0 : start - 1;
        byte[] baseSequence = SequenceManager.readSequence(genome, chr, csStart, end);
        if (baseSequence == null || baseSequence.length == 0) {
            return baseSequence;
        }
        byte[] csSequence = new byte[end - start];
        int n2 = c1 = start == 0 ? 0 : SequenceManager.baseToCS(baseSequence[i2++]);
        for (i2 = 0; i2 < baseSequence.length; ++i2) {
            int c2 = SequenceManager.baseToCS(baseSequence[i2]);
            csSequence[i2] = (byte)(c1 ^ c2);
        }
        return csSequence;
    }

    private static int baseToCS(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 0;
            }
            case 67: 
            case 99: {
                return 1;
            }
            case 84: 
            case 116: {
                return 2;
            }
            case 71: 
            case 103: {
                return 3;
            }
        }
        return -1;
    }

    public static byte[] readSequence(String genome, String chr, int start, int end) {
        Object rootDirectory = null;
        try {
            String location;
            GenomeDescriptor descriptor = IGV.getInstance().getGenomeManager().getGenomeDescriptor(genome);
            if (descriptor != null && (location = descriptor.getSequenceLocation()) != null) {
                location = SequenceManager.convertSequenceURL(location, genome);
                return SequenceManager.getSequence(descriptor, chr, start, end, location);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
        }
        return new byte[0];
    }

    private static byte[] getSequence(GenomeDescriptor genome, String chr, int start, int end, String location) {
        if (cacheSequences) {
            byte[] sequence = new byte[end - start];
            int startTile = start / chunkSize;
            int endTile = end / chunkSize;
            SequenceChunk chunk = SequenceManager.getSequenceChunk(genome, chr, startTile, location);
            int offset = start - chunk.getStart();
            byte[] seqBytes = chunk.getBytes();
            if (seqBytes == null) {
                return null;
            }
            int nBytes = Math.min(seqBytes.length - offset, sequence.length);
            System.arraycopy(chunk.getBytes(), offset, sequence, 0, nBytes);
            for (int tile = startTile + 1; tile <= endTile; ++tile) {
                chunk = SequenceManager.getSequenceChunk(genome, chr, tile, location);
                int nNext = Math.min(sequence.length - nBytes, chunk.getSize());
                System.arraycopy(chunk.getBytes(), 0, sequence, nBytes, nNext);
                nBytes += nNext;
            }
            return sequence;
        }
        return SequenceManager.readSequence(genome, chr, start, end, location);
    }

    private static SequenceChunk getSequenceChunk(GenomeDescriptor genome, String chr, int tileNo, String location) {
        String key = SequenceManager.getKey(genome.getId(), chr, tileNo);
        SequenceChunk chunk = sequenceCache.get(key);
        if (chunk == null) {
            int start = tileNo * chunkSize;
            int end = start + chunkSize;
            byte[] seq = SequenceManager.readSequence(genome, chr, start, end, location);
            chunk = new SequenceChunk(start, seq);
            sequenceCache.put(key, chunk);
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readSequence(GenomeDescriptor genome, String chr, int start, int end, String path) {
        if (path.startsWith("http://www.broadinstitute.org/igv/SequenceServlet") || path.startsWith("http://www.broadinstitute.org/igv/sequence")) {
            return SequenceServletWrapper.readBytes(path, chr, start, end);
        }
        InputStream is = null;
        try {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            String fn = chr + ".txt";
            if (genome.isChrNamesAltered()) {
                fn = SequenceManager.getChrFileName(fn);
            }
            String seqFile = path + fn;
            is = IGVSeekableStreamFactory.getStreamFor(seqFile);
            byte[] bytes = new byte[end - start];
            ((SeekableStream)is).seek(start);
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception ex) {
            log.error("Error reading genome sequence from: " + path, ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.error("Error closing sequence file.", ex);
                }
            }
        }
    }

    private static String getChrFileName(String fn) {
        String chrFN = chrFileNameCache.get(fn);
        if (chrFN == null) {
            chrFN = FileUtils.legalFileName(fn);
            chrFileNameCache.put(fn, chrFN);
        }
        return chrFN;
    }

    static String getKey(String genome, String chr, int tileNo) {
        return genome + chr + tileNo;
    }

    static void setChunkSize(int aChunkSize) {
        chunkSize = aChunkSize;
    }

    static void setCacheSequences(boolean aCacheSequences) {
        cacheSequences = aCacheSequences;
    }

    public static void clearCache() {
        sequenceCache.clear();
    }

    public static String convertSequenceURL(String url, String genome) {
        boolean useByteRange = IGVHttpUtils.useByteRange();
        String key = url + useByteRange;
        String convertedURL = sequenceUrlCache.get(key);
        if (convertedURL == null) {
            convertedURL = url;
            convertedURL = convertedURL.replace("broad.mit.edu", "broadinstitute.org");
            convertedURL = convertedURL.replace("http://www.broadinstitute.org/igv/SequenceServlet", "http://igvdata.broadinstitute.org/genomes/seq");
            if (!useByteRange) {
                convertedURL = convertedURL.replace("http://www.broadinstitute.org/igvdata/annotations/seq", "http://www.broadinstitute.org/igv/sequence");
                convertedURL = convertedURL.replace("http://igvdata.broadinstitute.org/genomes/seq", "http://www.broadinstitute.org/igv/sequence");
                convertedURL = convertedURL.replace("http://igv.broadinstitute.org/genomes/seq", "http://www.broadinstitute.org/igv/sequence");
            }
            if (!url.equals(convertedURL)) {
                log.info("Converting sequence URL: " + url + " -> " + convertedURL);
            }
            sequenceUrlCache.put(key, convertedURL);
        }
        return convertedURL;
    }

    static class SequenceChunk {
        private int start;
        private byte[] bytes;

        SequenceChunk(int start, byte[] bytes) {
            this.start = start;
            this.bytes = bytes;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.bytes.length;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

