/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.HDFDataManager;
import org.broad.igv.data.SummaryScore;
import org.broad.igv.data.SummaryTile2D;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

public class HDFDataSource
implements DataSource {
    private String name;
    private int trackNumber;
    HDFDataManager dataManager;
    private static String lastTileListKey = null;
    private static List<SummaryTile2D> lastTileList = null;

    public HDFDataSource(HDFDataManager dataManager, String name, int trackNumber) {
        this.dataManager = dataManager;
        this.name = name;
        this.trackNumber = trackNumber;
    }

    public boolean isCopyNumber() {
        TrackType tt = this.dataManager.getTrackType();
        return tt == TrackType.COPY_NUMBER || tt == TrackType.ALLELE_SPECIFIC_COPY_NUMBER;
    }

    String getName() {
        return this.name;
    }

    @Override
    public TrackType getTrackType() {
        return this.dataManager.getTrackType();
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.dataManager.setWindowFunction(statType);
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataManager.isNormalized();
    }

    public int getChrLength(String chr) {
        return this.dataManager.getChrLength(chr);
    }

    @Override
    public double getDataMax() {
        return this.dataManager.getDataMax(this.trackNumber, "All");
    }

    @Override
    public double getDataMin() {
        return this.dataManager.getDataMin(this.trackNumber, "All");
    }

    public void refresh() {
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        List<SummaryTile2D> tiles = null;
        String key = this.dataManager.getResourceLocator().toString() + "_" + chr + " " + startLocation + "_" + endLocation + "_" + zoom + this.getWindowFunction().toString();
        if (lastTileListKey != null && lastTileListKey.equals(key)) {
            tiles = lastTileList;
        } else {
            tiles = this.dataManager.getSummaryTilesForRange(chr, startLocation, endLocation, zoom);
            lastTileListKey = key;
            lastTileList = tiles;
        }
        ArrayList<LocusScore> summaryScores = new ArrayList<LocusScore>(tiles.size() * 700);
        for (SummaryTile2D tile : tiles) {
            List<LocusScore> scores;
            if (tile.isEmpty() || (scores = tile.getScores(this.trackNumber)) == null) continue;
            summaryScores.addAll(tile.getScores(this.trackNumber));
        }
        return summaryScores;
    }

    private List<LocusScore> aggregateScores(int trackNumber, List<SummaryTile2D> tiles) {
        ArrayList<LocusScore> joinedScores = new ArrayList<LocusScore>(tiles.size() * 700);
        LocusScore previousScore = null;
        for (SummaryTile2D tile : tiles) {
            if (tile.getScores(trackNumber) == null) continue;
            for (LocusScore score : tile.getScores(trackNumber)) {
                if (Float.isNaN(score.getScore())) continue;
                if (previousScore == null) {
                    previousScore = new SummaryScore(score);
                    joinedScores.add(previousScore);
                    continue;
                }
                if (score.getScore() == previousScore.getScore()) {
                    previousScore.setEnd(score.getEnd());
                    continue;
                }
                SummaryScore newScore = new SummaryScore(score);
                int delta = newScore.getStart() - previousScore.getEnd();
                previousScore.setEnd(previousScore.getEnd() + delta / 2);
                newScore.setStart(previousScore.getEnd());
                joinedScores.add(newScore);
                previousScore = newScore;
            }
        }
        return joinedScores;
    }

    @Override
    public void refreshData(long timestamp) {
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.dataManager.getWindowFunction();
    }
}

