/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractCharacterData;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractText
extends AbstractCharacterData
implements Text {
    public Text splitText(int offset) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String v = this.getNodeValue();
        if (offset < 0 || offset >= v.length()) {
            throw this.createDOMException((short)1, "offset", new Object[]{new Integer(offset)});
        }
        Node n2 = this.getParentNode();
        if (n2 == null) {
            throw this.createDOMException((short)1, "need.parent", new Object[0]);
        }
        String t1 = v.substring(offset);
        Text t = this.createTextNode(t1);
        Node ns = this.getNextSibling();
        if (ns != null) {
            n2.insertBefore(t, ns);
        } else {
            n2.appendChild(t);
        }
        this.setNodeValue(v.substring(0, offset));
        return t;
    }

    protected Node getPreviousLogicallyAdjacentTextNode(Node n2) {
        Node p2 = n2.getPreviousSibling();
        Node parent = n2.getParentNode();
        while (p2 == null && parent != null && parent.getNodeType() == 5) {
            p2 = parent;
            parent = p2.getParentNode();
            p2 = p2.getPreviousSibling();
        }
        while (p2 != null && p2.getNodeType() == 5) {
            p2 = p2.getLastChild();
        }
        if (p2 == null) {
            return null;
        }
        short nt = p2.getNodeType();
        if (nt == 3 || nt == 4) {
            return p2;
        }
        return null;
    }

    protected Node getNextLogicallyAdjacentTextNode(Node n2) {
        Node p2 = n2.getNextSibling();
        Node parent = n2.getParentNode();
        while (p2 == null && parent != null && parent.getNodeType() == 5) {
            p2 = parent;
            parent = p2.getParentNode();
            p2 = p2.getNextSibling();
        }
        while (p2 != null && p2.getNodeType() == 5) {
            p2 = p2.getFirstChild();
        }
        if (p2 == null) {
            return null;
        }
        short nt = p2.getNodeType();
        if (nt == 3 || nt == 4) {
            return p2;
        }
        return null;
    }

    public String getWholeText() {
        StringBuffer sb = new StringBuffer();
        Node n2 = this;
        while (n2 != null) {
            sb.insert(0, n2.getNodeValue());
            n2 = this.getPreviousLogicallyAdjacentTextNode(n2);
        }
        Node n3 = this.getNextLogicallyAdjacentTextNode(this);
        while (n3 != null) {
            sb.append(n3.getNodeValue());
            n3 = this.getNextLogicallyAdjacentTextNode(n3);
        }
        return sb.toString();
    }

    public boolean isElementContentWhitespace() {
        int len = this.nodeValue.length();
        int i2 = 0;
        while (i2 < len) {
            if (!XMLUtilities.isXMLSpace(this.nodeValue.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        Node p2 = this.getParentNode();
        if (p2.getNodeType() == 1) {
            String sp = XMLSupport.getXMLSpace((Element)p2);
            return !sp.equals("preserve");
        }
        return true;
    }

    public Text replaceWholeText(String s) throws DOMException {
        Node n2 = this.getPreviousLogicallyAdjacentTextNode(this);
        while (n2 != null) {
            AbstractNode an = (AbstractNode)n2;
            if (an.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(n2.getNodeType()), n2.getNodeName()});
            }
            n2 = this.getPreviousLogicallyAdjacentTextNode(n2);
        }
        Node n3 = this.getNextLogicallyAdjacentTextNode(this);
        while (n3 != null) {
            AbstractNode an = (AbstractNode)n3;
            if (an.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(n3.getNodeType()), n3.getNodeName()});
            }
            n3 = this.getNextLogicallyAdjacentTextNode(n3);
        }
        Node parent = this.getParentNode();
        Node n4 = this.getPreviousLogicallyAdjacentTextNode(this);
        while (n4 != null) {
            parent.removeChild(n4);
            n4 = this.getPreviousLogicallyAdjacentTextNode(n4);
        }
        Node n5 = this.getNextLogicallyAdjacentTextNode(this);
        while (n5 != null) {
            parent.removeChild(n5);
            n5 = this.getNextLogicallyAdjacentTextNode(n5);
        }
        if (this.isReadonly()) {
            Text t = this.createTextNode(s);
            parent.replaceChild(t, this);
            return t;
        }
        this.setNodeValue(s);
        return this;
    }

    public String getTextContent() {
        if (this.isElementContentWhitespace()) {
            return "";
        }
        return this.getNodeValue();
    }

    protected abstract Text createTextNode(String var1);
}

