/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import Jama.util.Maths;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class Matrix
implements Cloneable,
Serializable {
    private double[][] A;
    private int m;
    private int n;

    public Matrix(int n2, int n3) {
        this.m = n2;
        this.n = n3;
        this.A = new double[n2][n3];
    }

    public Matrix(int n2, int n3, double d2) {
        this.m = n2;
        this.n = n3;
        this.A = new double[n2][n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.A[i2][i3] = d2;
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        for (int i2 = 0; i2 < this.m; ++i2) {
            if (dArray[i2].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = dArray;
    }

    public Matrix(double[][] dArray, int n2, int n3) {
        this.A = dArray;
        this.m = n2;
        this.n = n3;
    }

    public Matrix(double[] dArray, int n2) {
        this.m = n2;
        int n3 = this.n = n2 != 0 ? dArray.length / n2 : 0;
        if (n2 * this.n != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[n2][this.n];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = dArray[i2 + i3 * n2];
            }
        }
    }

    public static Matrix constructWithCopy(double[][] dArray) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        Matrix matrix = new Matrix(n2, n3);
        double[][] dArray2 = matrix.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (dArray[i2].length != n3) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                dArray2[i2][i3] = dArray[i2][i3];
            }
        }
        return matrix;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.A[i2][i3];
            }
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.A[i2][i3];
            }
        }
        return dArray;
    }

    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2 + i3 * this.m] = this.A[i2][i3];
            }
        }
        return dArray;
    }

    public double[] getRowPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2 * this.n + i3] = this.A[i2][i3];
            }
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n2, int n3) {
        return this.A[n2][n3];
    }

    public Matrix getMatrix(int n2, int n3, int n4, int n5) {
        Matrix matrix = new Matrix(n3 - n2 + 1, n5 - n4 + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                for (int i3 = n4; i3 <= n5; ++i3) {
                    dArray[i2 - n2][i3 - n4] = this.A[i2][i3];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    dArray[i2][i3] = this.A[nArray[i2]][nArray2[i3]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int n2, int n3, int[] nArray) {
        Matrix matrix = new Matrix(n3 - n2 + 1, nArray.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    dArray[i2 - n2][i3] = this.A[i2][nArray[i3]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n2, int n3) {
        Matrix matrix = new Matrix(nArray.length, n3 - n2 + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = n2; i3 <= n3; ++i3) {
                    dArray[i2][i3 - n2] = this.A[nArray[i2]][i3];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public void set(int n2, int n3, double d2) {
        this.A[n2][n3] = d2;
    }

    public void setMatrix(int n2, int n3, int n4, int n5, Matrix matrix) {
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                for (int i3 = n4; i3 <= n5; ++i3) {
                    this.A[i2][i3] = matrix.get(i2 - n2, i3 - n4);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, Matrix matrix) {
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    this.A[nArray[i2]][nArray2[i3]] = matrix.get(i2, i3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n2, int n3, Matrix matrix) {
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = n2; i3 <= n3; ++i3) {
                    this.A[nArray[i2]][i3] = matrix.get(i2, i3 - n2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int n2, int n3, int[] nArray, Matrix matrix) {
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    this.A[i2][nArray[i3]] = matrix.get(i2 - n2, i3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i3][i2] = this.A[i2][i3];
            }
        }
        return matrix;
    }

    public double norm1() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            double d3 = 0.0;
            for (int i3 = 0; i3 < this.m; ++i3) {
                d3 += Math.abs(this.A[i3][i2]);
            }
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    public double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            double d3 = 0.0;
            for (int i3 = 0; i3 < this.n; ++i3) {
                d3 += Math.abs(this.A[i2][i3]);
            }
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    public double normF() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                d2 = Maths.hypot(d2, this.A[i2][i3]);
            }
        }
        return d2;
    }

    public Matrix uminus() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = -this.A[i2][i3];
            }
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.A[i2][i3] + matrix.A[i2][i3];
            }
        }
        return matrix2;
    }

    public Matrix plusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] + matrix.A[i2][i3];
            }
        }
        return this;
    }

    public Matrix minus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.A[i2][i3] - matrix.A[i2][i3];
            }
        }
        return matrix2;
    }

    public Matrix minusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] - matrix.A[i2][i3];
            }
        }
        return this;
    }

    public Matrix arrayTimes(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.A[i2][i3] * matrix.A[i2][i3];
            }
        }
        return matrix2;
    }

    public Matrix arrayTimesEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] * matrix.A[i2][i3];
            }
        }
        return this;
    }

    public Matrix arrayRightDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.A[i2][i3] / matrix.A[i2][i3];
            }
        }
        return matrix2;
    }

    public Matrix arrayRightDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = this.A[i2][i3] / matrix.A[i2][i3];
            }
        }
        return this;
    }

    public Matrix arrayLeftDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = matrix.A[i2][i3] / this.A[i2][i3];
            }
        }
        return matrix2;
    }

    public Matrix arrayLeftDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = matrix.A[i2][i3] / this.A[i2][i3];
            }
        }
        return this;
    }

    public Matrix times(double d2) {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = d2 * this.A[i2][i3];
            }
        }
        return matrix;
    }

    public Matrix timesEquals(double d2) {
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.A[i2][i3] = d2 * this.A[i2][i3];
            }
        }
        return this;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this.m, matrix.n);
        double[][] dArray = matrix2.getArray();
        double[] dArray2 = new double[this.n];
        for (int i2 = 0; i2 < matrix.n; ++i2) {
            int n2;
            for (n2 = 0; n2 < this.n; ++n2) {
                dArray2[n2] = matrix.A[n2][i2];
            }
            for (n2 = 0; n2 < this.m; ++n2) {
                double[] dArray3 = this.A[n2];
                double d2 = 0.0;
                for (int i3 = 0; i3 < this.n; ++i3) {
                    d2 += dArray3[i3] * dArray2[i3];
                }
                dArray[n2][i2] = d2;
            }
        }
        return matrix2;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public Matrix solve(Matrix matrix) {
        return this.m == this.n ? new LUDecomposition(this).solve(matrix) : new QRDecomposition(this).solve(matrix);
    }

    public Matrix solveTranspose(Matrix matrix) {
        return this.transpose().solve(matrix.transpose());
    }

    public Matrix inverse() {
        return this.solve(Matrix.identity(this.m, this.m));
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public double trace() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < Math.min(this.m, this.n); ++i2) {
            d2 += this.A[i2][i2];
        }
        return d2;
    }

    public static Matrix random(int n2, int n3) {
        Matrix matrix = new Matrix(n2, n3);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                dArray[i2][i3] = Math.random();
            }
        }
        return matrix;
    }

    public static Matrix identity(int n2, int n3) {
        Matrix matrix = new Matrix(n2, n3);
        double[][] dArray = matrix.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                dArray[i2][i3] = i2 == i3 ? 1.0 : 0.0;
            }
        }
        return matrix;
    }

    public void print(int n2, int n3) {
        this.print(new PrintWriter(System.out, true), n2, n3);
    }

    public void print(PrintWriter printWriter, int n2, int n3) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n3);
        decimalFormat.setMinimumFractionDigits(n3);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n2 + 2);
    }

    public void print(NumberFormat numberFormat, int n2) {
        this.print(new PrintWriter(System.out, true), numberFormat, n2);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n2) {
        printWriter.println();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                String string = numberFormat.format(this.A[i2][i3]);
                int n3 = Math.max(1, n2 - string.length());
                for (int i4 = 0; i4 < n3; ++i4) {
                    printWriter.print(' ');
                }
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public static Matrix read(BufferedReader bufferedReader) throws IOException {
        int n2;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        Vector<Object> vector = new Vector<Object>();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vector.addElement(Double.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n3 = vector.size();
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = (Double)vector.elementAt(n2);
        }
        vector.removeAllElements();
        vector.addElement(dArray);
        while (streamTokenizer.nextToken() == -3) {
            dArray = new double[n3];
            vector.addElement(dArray);
            n2 = 0;
            do {
                if (n2 >= n3) {
                    throw new IOException("Row " + vector.size() + " is too long.");
                }
                dArray[n2++] = Double.valueOf(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n2 >= n3) continue;
            throw new IOException("Row " + vector.size() + " is too short.");
        }
        n2 = vector.size();
        double[][] dArrayArray = new double[n2][];
        vector.copyInto((Object[])dArrayArray);
        return new Matrix(dArrayArray);
    }

    private void checkMatrixDimensions(Matrix matrix) {
        if (matrix.m != this.m || matrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

